/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleSystem;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.BlockPosHelper;

@SideOnly(value=Side.CLIENT)
public class ParticleSystemHandler
extends EffectHandlerBase {
    private final Long2ObjectOpenHashMap<ParticleSystem> systems = new Long2ObjectOpenHashMap();

    public ParticleSystemHandler() {
        super("Particle Systems");
    }

    @Override
    public boolean doTick(int tick) {
        return !this.systems.isEmpty();
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        double range = ModOptions.effects.specialEffectRange;
        BlockPos min = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(-range, -range, -range);
        BlockPos max = EnvironStateHandler.EnvironState.getPlayerPosition().func_177963_a(range, range, range);
        this.systems.long2ObjectEntrySet().removeIf(entry -> {
            ParticleSystem system = (ParticleSystem)entry.getValue();
            if (BlockPosHelper.notContains((BlockPos)system.getPos(), (BlockPos)min, (BlockPos)max)) {
                system.setExpired();
            } else {
                system.onUpdate();
            }
            return !system.isAlive();
        });
    }

    @Override
    public void onConnect() {
        this.systems.clear();
    }

    @Override
    public void onDisconnect() {
        this.systems.clear();
    }

    public boolean okToSpawn(@Nonnull BlockPos pos) {
        return !this.systems.containsKey(pos.func_177986_g());
    }

    public void addSystem(@Nonnull ParticleSystem system) {
        this.systems.put(system.getPos().func_177986_g(), (Object)system);
    }
}

