/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityEntityFXData;
import org.orecruncher.dsurround.capabilities.entityfx.IEntityFX;
import org.orecruncher.dsurround.client.effects.EntityEffectHandler;
import org.orecruncher.dsurround.client.effects.EntityEffectLibrary;
import org.orecruncher.dsurround.client.effects.EventEffectLibrary;
import org.orecruncher.dsurround.client.effects.IParticleHelper;
import org.orecruncher.dsurround.client.effects.ISoundHelper;
import org.orecruncher.dsurround.client.handlers.DiagnosticHandler;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.handlers.effects.BreathEffect;
import org.orecruncher.dsurround.client.handlers.effects.CraftingSoundEffect;
import org.orecruncher.dsurround.client.handlers.effects.EntityBowSoundEffect;
import org.orecruncher.dsurround.client.handlers.effects.EntityChatEffect;
import org.orecruncher.dsurround.client.handlers.effects.EntityFootprintEffect;
import org.orecruncher.dsurround.client.handlers.effects.EntityHealthPopoffEffect;
import org.orecruncher.dsurround.client.handlers.effects.EntitySwingEffect;
import org.orecruncher.dsurround.client.handlers.effects.PlayerToolBarSoundEffect;
import org.orecruncher.dsurround.client.handlers.effects.VillagerChatEffect;
import org.orecruncher.dsurround.client.sound.ISoundInstance;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.lib.OutOfBandTimerEMA;
import org.orecruncher.dsurround.registry.RegistryDataEvent;
import org.orecruncher.dsurround.registry.effect.EffectRegistry;
import org.orecruncher.lib.gfx.ParticleHelper;
import org.orecruncher.lib.math.TimerEMA;

@SideOnly(value=Side.CLIENT)
public class FxHandler
extends EffectHandlerBase {
    private static final IParticleHelper PARTICLE_HELPER = p -> ParticleHelper.addParticle((Particle)p);
    private static final ISoundHelper SOUND_HELPER = new ISoundHelper(){

        @Override
        public boolean playSound(@Nonnull ISoundInstance sound2) {
            return SoundEffectHandler.INSTANCE.playSound((SoundInstance)sound2);
        }

        @Override
        public void stopSound(@Nonnull ISoundInstance sound2) {
            SoundEffectHandler.INSTANCE.stopSound((SoundInstance)sound2);
        }
    };
    private static final EntityEffectLibrary library = new EntityEffectLibrary(PARTICLE_HELPER, SOUND_HELPER);
    private final EventEffectLibrary eventLibrary = new EventEffectLibrary(PARTICLE_HELPER, SOUND_HELPER);
    private final TimerEMA compute = new OutOfBandTimerEMA("Entity Effect Updates");
    private long nanos;

    public FxHandler() {
        super("Special Effects");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.compute.update((double)this.nanos);
        this.nanos = 0L;
    }

    public List<String> getEffects(@Nonnull Entity entity) {
        EntityEffectHandler eh;
        IEntityFX caps = CapabilityEntityFXData.getCapability(entity);
        if (caps != null && (eh = caps.get()) != null) {
            return eh.getAttachedEffects();
        }
        return ImmutableList.of();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !entity.func_130014_f_().field_72995_K) {
            return;
        }
        long start = System.nanoTime();
        IEntityFX cap = CapabilityEntityFXData.getCapability(entity);
        if (cap != null) {
            double distanceThreshold = ModOptions.effects.specialEffectRange * ModOptions.effects.specialEffectRange;
            boolean inRange = entity.func_70068_e((Entity)EnvironStateHandler.EnvironState.getPlayer()) <= distanceThreshold;
            EntityEffectHandler handler = cap.get();
            if (handler != null && !inRange) {
                cap.clear();
            } else if (handler == null && inRange && entity.func_70089_S()) {
                cap.set(library.create(entity).get());
            } else if (handler != null) {
                handler.update();
            }
        }
        this.nanos += System.nanoTime() - start;
    }

    protected void clearHandlers() {
        World world = EnvironStateHandler.EnvironState.getWorld();
        if (world != null) {
            EnvironStateHandler.EnvironState.getWorld().func_72910_y().stream().map(e -> CapabilityEntityFXData.getCapability(e)).filter(Objects::nonNull).forEach(c -> c.clear());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoin(@Nonnull EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerSP) {
            this.clearHandlers();
        }
    }

    @SubscribeEvent
    public void registryReload(@Nonnull RegistryDataEvent.Reload event) {
        if (event.reg instanceof EffectRegistry) {
            this.clearHandlers();
        }
    }

    @Override
    public void onConnect() {
        this.clearHandlers();
        this.eventLibrary.register(new CraftingSoundEffect());
        ((DiagnosticHandler)EffectManager.instance().lookupService(DiagnosticHandler.class)).addTimer(this.compute);
    }

    @Override
    public void onDisconnect() {
        this.clearHandlers();
        this.eventLibrary.cleanup();
    }

    static {
        library.register(BreathEffect.DEFAULT_FILTER, new BreathEffect.Factory());
        library.register(EntityChatEffect.DEFAULT_FILTER, new EntityChatEffect.Factory());
        library.register(VillagerChatEffect.DEFAULT_FILTER, new VillagerChatEffect.Factory());
        library.register(PlayerToolBarSoundEffect.DEFAULT_FILTER, new PlayerToolBarSoundEffect.Factory());
        library.register(EntityFootprintEffect.DEFAULT_FILTER, new EntityFootprintEffect.Factory());
        library.register(EntitySwingEffect.DEFAULT_FILTER, new EntitySwingEffect.Factory());
        library.register(EntityBowSoundEffect.DEFAULT_FILTER, new EntityBowSoundEffect.Factory());
        library.register(EntityHealthPopoffEffect.DEFAULT_FILTER, new EntityHealthPopoffEffect.Factory());
    }
}

