/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.TemperatureRating;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.handlers.scanners.BattleScanner;
import org.orecruncher.dsurround.client.handlers.scanners.CeilingCoverage;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.expression.ExpressionEngine;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeRegistry;
import org.orecruncher.dsurround.registry.dimension.DimensionData;
import org.orecruncher.dsurround.registry.dimension.DimensionRegistry;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.lib.DiurnalUtils;
import org.orecruncher.lib.MinecraftClock;

@SideOnly(value=Side.CLIENT)
public class EnvironStateHandler
extends EffectHandlerBase {
    protected final CeilingCoverage ceiling = new CeilingCoverage();
    private static final String[] scripts = new String[]{"'Dim: ' + dim.id + '/' + dim.name", "'Biome: ' + biome.name + ' (' + biome.id + '); Temp ' + biome.temperature + '/' + biome.temperatureValue + ' rainfall: ' + biome.rainfall", "'Weather: ' + IF(weather.isRaining,'rainfall: ' + weather.rainfall,'not raining') + IF(weather.isThundering,' thundering','') + ' Temp: ' + weather.temperature + '/' + weather.temperatureValue + ' ice: ' + IF(weather.canWaterFreeze, 'true', 'false') + ' ' + IF(weather.temperatureValue < 0.2, '(breath)', '')", "'Season: ' + season.season + IF(diurnal.isNight,' night',' day') + IF(player.isInside,' inside',' outside') + ' celestialAngle: ' + diurnal.celestialAngle", "'Player: Temp ' + player.temperature + '; health ' + player.health + '/' + player.maxHealth + '; food ' + player.food.level + '; saturation ' + player.food.saturation + IF(player.isHurt,' isHurt','') + IF(player.isHungry,' isHungry','') + ' pos: (' + player.X + ',' + player.Y + ',' + player.Z + ') light: ' + player.lightLevel", "'Village: ' + player.inVillage"};

    public EnvironStateHandler() {
        super("State Handler");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        EnvironState.tick(player2.func_130014_f_(), player2);
        Weather.update();
        ExpressionEngine.instance().reset();
        this.ceiling.func_73660_a();
    }

    public boolean isReallyInside() {
        return this.ceiling.isReallyInside();
    }

    @Override
    public void onConnect() {
        EnvironState.reset();
        ExpressionEngine.instance();
    }

    @Override
    public void onDisconnect() {
        EnvironState.reset();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void diagnostics(DiagnosticEvent.Gather event) {
        event.output.add(TextFormatting.GREEN + "Minecraft Date: " + EnvironState.getClock().toString());
        for (String s : scripts) {
            String result = ExpressionEngine.instance().eval(s).toString();
            event.output.add(TextFormatting.YELLOW + result);
        }
        List<String> badScripts = ExpressionEngine.instance().getNaughtyList();
        for (String s : badScripts) {
            event.output.add("BAD SCRIPT: " + s);
        }
    }

    public static class EnvironState {
        private static BiomeInfo playerBiome = null;
        private static BiomeInfo truePlayerBiome = null;
        private static int dimensionId;
        private static String dimensionName;
        private static DimensionData dimInfo;
        private static BlockPos playerPosition;
        private static TemperatureRating playerTemperature;
        private static TemperatureRating biomeTemperature;
        private static boolean inside;
        private static ItemStack armorStack;
        private static ItemStack footArmorStack;
        private static boolean inVillage;
        private static boolean isUnderground;
        private static boolean isInSpace;
        private static boolean isInClouds;
        private static int lightLevel;
        private static int tickCounter;
        private static DiurnalUtils.DayCycle dayCycle;
        private static MinecraftClock clock;
        private static BattleScanner battle;

        private static BlockPos getPlayerPos() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return new BlockPos(player2.field_70165_t, player2.func_174813_aQ().field_72338_b, player2.field_70161_v);
        }

        private static void reset() {
            BiomeInfo WTF;
            playerBiome = WTF = RegistryManager.BIOME.WTF_INFO;
            truePlayerBiome = WTF;
            dimensionId = 0;
            dimensionName = "";
            dimInfo = DimensionData.NONE;
            playerPosition = BlockPos.field_177992_a;
            playerTemperature = TemperatureRating.MILD;
            biomeTemperature = TemperatureRating.MILD;
            inside = false;
            armorStack = ItemStack.field_190927_a;
            footArmorStack = ItemStack.field_190927_a;
            inVillage = false;
            isUnderground = false;
            isInSpace = false;
            isInClouds = false;
            lightLevel = 0;
            tickCounter = 1;
            dayCycle = DiurnalUtils.DayCycle.NO_SKY;
            clock = new MinecraftClock();
            battle = new BattleScanner();
        }

        private static void tick(World world, EntityPlayer player2) {
            BiomeRegistry biomes2 = RegistryManager.BIOME;
            ISeasonInfo season = CapabilitySeasonInfo.getCapability(EnvironState.getWorld());
            DimensionRegistry dimensions = RegistryManager.DIMENSION;
            EnvironStateHandler stateHandler = (EnvironStateHandler)EffectManager.instance().lookupService(EnvironStateHandler.class);
            if (stateHandler == null) {
                ModBase.log().warn("Null EnvironStateHandler in EnvironState.tick()", new Object[0]);
            }
            dimInfo = dimensions.getData(player2.func_130014_f_());
            clock.update(EnvironState.getWorld());
            playerBiome = biomes2.getPlayerBiome(player2, false);
            dimensionId = world.field_73011_w.getDimension();
            dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
            playerPosition = EnvironState.getPlayerPos();
            inside = stateHandler == null ? false : stateHandler.isReallyInside();
            truePlayerBiome = biomes2.getPlayerBiome(player2, true);
            playerTemperature = season.getPlayerTemperature();
            biomeTemperature = season.getBiomeTemperature(EnvironState.getPlayerPosition());
            armorStack = ItemClass.effectiveArmorStack((EntityLivingBase)player2);
            footArmorStack = ItemClass.footArmorStack((EntityLivingBase)player2);
            isUnderground = playerBiome == biomes2.UNDERGROUND_INFO;
            isInSpace = playerBiome == biomes2.OUTERSPACE_INFO;
            isInClouds = playerBiome == biomes2.CLOUDS_INFO;
            BlockPos pos = EnvironState.getPlayerPosition();
            int blockLight = world.func_175642_b(EnumSkyBlock.BLOCK, pos);
            int skyLight = world.func_175642_b(EnumSkyBlock.SKY, pos) - world.func_72967_a(1.0f);
            lightLevel = Math.max(blockLight, skyLight);
            dayCycle = DiurnalUtils.getCycle((World)world);
            battle.func_73660_a();
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ++tickCounter;
            }
        }

        public static MinecraftClock getClock() {
            return clock;
        }

        public static BattleScanner getBattleScanner() {
            return battle;
        }

        public static DimensionData getDimensionInfo() {
            return dimInfo;
        }

        public static BiomeInfo getPlayerBiome() {
            return playerBiome;
        }

        public static BiomeInfo getTruePlayerBiome() {
            return truePlayerBiome;
        }

        public static String getBiomeName() {
            return playerBiome.getBiomeName();
        }

        public static TemperatureRating getPlayerTemperature() {
            return playerTemperature;
        }

        public static TemperatureRating getBiomeTemperature() {
            return biomeTemperature;
        }

        public static int getDimensionId() {
            return dimensionId;
        }

        public static String getDimensionName() {
            return dimensionName;
        }

        public static EntityPlayer getPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        public static World getWorld() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null ? player2.func_130014_f_() : null;
        }

        public static BlockPos getPlayerPosition() {
            return playerPosition;
        }

        public static boolean isPlayer(Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player2 = EnvironState.getPlayer();
                EntityPlayer ep = (EntityPlayer)entity;
                return player2 == null || ep.func_110124_au().equals(player2.func_110124_au());
            }
            return false;
        }

        public static boolean isPlayer(UUID id) {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 == null || player2.func_110124_au().equals(id);
        }

        public static boolean isPlayer(int id) {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 == null || player2.func_145782_y() == id;
        }

        public static boolean isCreative() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.field_71075_bZ.field_75098_d;
        }

        public static boolean isPlayerHurt() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && ModOptions.player.playerHurtThreshold != 0.0f && !EnvironState.isCreative() && player2.func_110143_aJ() <= ModOptions.player.playerHurtThreshold * player2.func_110138_aP();
        }

        public static boolean isPlayerHungry() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && ModOptions.player.playerHungerThreshold != 0 && !EnvironState.isCreative() && player2.func_71024_bL().func_75116_a() <= ModOptions.player.playerHungerThreshold;
        }

        public static boolean isPlayerBurning() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70027_ad();
        }

        public static boolean isPlayerSuffocating() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70086_ai() <= 0;
        }

        public static boolean isPlayerFlying() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.field_71075_bZ.field_75100_b;
        }

        public static boolean isPlayerSprinting() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70051_ag();
        }

        public static boolean isPlayerInLava() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_180799_ab();
        }

        public static boolean isPlayerInvisible() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_82150_aj();
        }

        public static boolean isPlayerBlind() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70644_a(MobEffects.field_76440_q);
        }

        public static boolean isPlayerInWater() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70090_H();
        }

        public static boolean isPlayerRiding() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_184218_aH();
        }

        public static boolean isPlayerOnGround() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.field_70122_E;
        }

        public static boolean isPlayerMoving() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.field_70140_Q != player2.field_70141_P;
        }

        public static boolean isPlayerSneaking() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2 != null && player2.func_70093_af();
        }

        public static boolean isPlayerInside() {
            return inside;
        }

        public static boolean isPlayerUnderground() {
            return isUnderground;
        }

        public static boolean isPlayerInSpace() {
            return isInSpace;
        }

        public static boolean isPlayerInClouds() {
            return isInClouds;
        }

        public static ItemStack getPlayerItemStack() {
            return armorStack;
        }

        public static ItemStack getPlayerFootArmorStack() {
            return footArmorStack;
        }

        public static boolean inVillage() {
            return inVillage;
        }

        public static void setInVillage(boolean f) {
            inVillage = f;
        }

        public static int getLightLevel() {
            return lightLevel;
        }

        public static int getTickCounter() {
            return tickCounter;
        }

        public static DiurnalUtils.DayCycle getDayCycle() {
            return dayCycle;
        }

        public static float getPartialTick() {
            return Minecraft.func_71410_x().func_184121_ak();
        }

        static {
            dimInfo = DimensionData.NONE;
            clock = new MinecraftClock();
            battle = new BattleScanner();
        }
    }
}

