/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.sound.SoundBuilder;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.lib.task.Scheduler;

@SideOnly(value=Side.CLIENT)
public final class HumDinger {
    private static boolean hasPlayed = false;

    @SubscribeEvent
    public static void onGuiOpen(@Nonnull GuiOpenEvent event) {
        if (!hasPlayed && event.getGui() instanceof GuiMainMenu) {
            hasPlayed = true;
            String[] possibles = ModOptions.general.startupSoundList;
            if (possibles == null || possibles.length == 0) {
                return;
            }
            String res = possibles[XorShiftRandom.current().nextInt(possibles.length)];
            if (!StringUtils.isEmpty((CharSequence)res)) {
                SoundEvent se = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(res));
                if (se != null) {
                    Scheduler.scheduleDeferred((Side)Side.CLIENT, () -> {
                        try {
                            SoundInstance snd = SoundBuilder.create(se, SoundCategory.MASTER);
                            SoundEngine.instance().playSound(snd);
                        }
                        catch (Throwable t) {
                            ModBase.log().error("Error executing ding", t);
                        }
                    });
                } else {
                    ModBase.log().warn("Unable to locate startup sound [%s]", new Object[]{res});
                }
            } else {
                ModBase.log().warn("Improperly formatted startup sound list!", new Object[0]);
            }
        }
    }
}

