/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.gui;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dsurround")
public class GuiScreenOptionsSoundReplace
extends GuiScreenOptionsSounds {
    private static final int SLIDER_HEIGHT = 22;
    private static final Field parent = ReflectionHelper.findField(GuiScreenOptionsSounds.class, (String[])new String[]{"parent", "field_146505_f"});
    private final GameSettings settings;
    private String offDisplayString;

    public GuiScreenOptionsSoundReplace(GuiScreen parentIn, GameSettings settingsIn) {
        super(parentIn, settingsIn);
        this.settings = settingsIn;
    }

    public void func_73866_w_() {
        this.field_146507_a = I18n.func_135052_a((String)"options.sounds.title", (Object[])new Object[0]);
        this.offDisplayString = I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        int i = 0;
        this.field_146292_n.add(new Button(SoundCategory.MASTER.ordinal(), this.field_146294_l / 2 - 155 + i % 2 * 160, this.field_146295_m / 6 - 12 + 22 * (i >> 1), SoundCategory.MASTER, true));
        i += 2;
        for (SoundCategory soundcategory : SoundCategory.values()) {
            if (soundcategory == SoundCategory.MASTER) continue;
            this.field_146292_n.add(new Button(soundcategory.ordinal(), this.field_146294_l / 2 - 155 + i % 2 * 160, this.field_146295_m / 6 - 12 + 22 * (i >> 1), soundcategory, false));
            ++i;
        }
        int j = this.field_146294_l / 2 - 75;
        int k = this.field_146295_m / 6 - 12;
        this.field_146292_n.add(new GuiOptionButton(201, j, k + 22 * (++i >> 1), GameSettings.Options.SHOW_SUBTITLES, this.settings.func_74297_c(GameSettings.Options.SHOW_SUBTITLES)));
        this.field_146292_n.add(new GuiButton(200, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    protected String func_184097_a(SoundCategory category) {
        float f = this.settings.func_186711_a(category);
        return f == 0.0f ? this.offDisplayString : (int)(f * 100.0f) + "%";
    }

    @SubscribeEvent
    public static void guiOpenHandler(@Nonnull GuiOpenEvent evt) {
        if (evt.getGui() instanceof GuiScreenOptionsSounds) {
            try {
                GuiScreen p = (GuiScreen)parent.get(evt.getGui());
                evt.setGui((GuiScreen)new GuiScreenOptionsSoundReplace(p, Minecraft.func_71410_x().field_71474_y));
                evt.setResult(Event.Result.ALLOW);
            }
            catch (Throwable t) {
                ModBase.log().error("Unable to replace volume control screen", t);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    class Button
    extends GuiButton {
        private final SoundCategory category;
        private final String categoryName;
        public float volume;
        public boolean pressed;

        public Button(int buttonId, int x, int y, SoundCategory categoryIn, boolean master) {
            super(buttonId, x, y, master ? 310 : 150, 20, "");
            this.volume = 1.0f;
            this.category = categoryIn;
            this.categoryName = I18n.func_135052_a((String)("soundCategory." + categoryIn.func_187948_a()), (Object[])new Object[0]);
            this.field_146126_j = this.categoryName + ": " + GuiScreenOptionsSoundReplace.this.func_184097_a(categoryIn);
            this.volume = GuiScreenOptionsSoundReplace.this.settings.func_186711_a(categoryIn);
        }

        protected int func_146114_a(boolean mouseOver) {
            return 0;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.pressed) {
                    this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                    this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.0f, (float)1.0f);
                    mc.field_71474_y.func_186712_a(this.category, this.volume);
                    mc.field_71474_y.func_74303_b();
                    this.field_146126_j = this.categoryName + ": " + GuiScreenOptionsSoundReplace.this.func_184097_a(this.category);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h + (int)(this.volume * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.volume * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.volume = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.volume = MathHelper.func_76131_a((float)this.volume, (float)0.0f, (float)1.0f);
                mc.field_71474_y.func_186712_a(this.category, this.volume);
                mc.field_71474_y.func_74303_b();
                this.field_146126_j = this.categoryName + ": " + GuiScreenOptionsSoundReplace.this.func_184097_a(this.category);
                this.pressed = true;
                return true;
            }
            return false;
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
        }

        public void func_146118_a(int mouseX, int mouseY) {
            if (this.pressed) {
                GuiScreenOptionsSoundReplace.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            this.pressed = false;
        }
    }
}

