/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.system;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.fx.ParticleCollections;
import org.orecruncher.dsurround.client.fx.WaterSplashJetEffect;
import org.orecruncher.dsurround.client.fx.particle.mote.IParticleMote;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleJet;
import org.orecruncher.dsurround.client.sound.PositionedEmitter;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class ParticleWaterSplash
extends ParticleJet {
    private static final SoundEffect[] fallSounds = new SoundEffect[11];
    private static final BlockPos.MutableBlockPos pos;
    private final BlockPos location;
    private PositionedEmitter emitter;
    protected int particleLimit;

    public ParticleWaterSplash(int strength, World world, BlockPos loc, double x, double y, double z) {
        super(0, strength, world, x, y, z, 4);
        this.location = loc.func_185334_h();
        this.setSpawnCount((int)((float)strength * 2.5f));
    }

    public void setSpawnCount(int limit) {
        this.particleLimit = MathStuff.clamp((int)limit, (int)5, (int)20);
    }

    public int getSpawnCount() {
        switch (ParticleWaterSplash.SETTINGS.field_74362_aa) {
            case 2: {
                return 0;
            }
            case 0: {
                return this.particleLimit;
            }
        }
        return this.particleLimit / 2;
    }

    @Override
    public boolean shouldDie() {
        return this.particleAge % 10 == 0 && !WaterSplashJetEffect.isValidSpawnBlock(WorldUtils.getDefaultBlockStateProvider(), this.location);
    }

    private boolean setupSound() {
        return this.isAlive() && this.jetStrength >= ModOptions.effects.waterfallCutoff && this.emitter == null && RANDOM.nextInt(6) == 0;
    }

    @Override
    protected void soundUpdate() {
        if (this.setupSound()) {
            pos.func_189532_c(this.posX, this.posY, this.posZ);
            int idx = MathStuff.clamp((int)this.jetStrength, (int)0, (int)(fallSounds.length - 1));
            this.emitter = new PositionedEmitter(fallSounds[idx], (BlockPos)pos);
            this.emitter.setPitch(1.0f + 0.2f * (RANDOM.nextFloat() - RANDOM.nextFloat()));
        }
        if (this.emitter != null) {
            this.emitter.update();
        }
    }

    @Override
    protected void cleanUp() {
        if (this.emitter != null) {
            this.emitter.stop();
        }
        this.emitter = null;
        super.cleanUp();
    }

    @Override
    protected void spawnJetParticle() {
        if (ParticleCollections.canFitWaterSpray()) {
            int splashCount = this.getSpawnCount();
            int j = 0;
            while ((float)j < (float)splashCount) {
                double zOffset;
                double xOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
                if (!WorldUtils.isSolidBlock((World)this.world, (BlockPos)pos.func_189532_c(this.posX + xOffset, this.posY, this.posZ + (zOffset = (double)(RANDOM.nextFloat() * 2.0f - 1.0f))))) {
                    int motionStr = this.jetStrength + 3;
                    double motionX = xOffset * ((double)motionStr / 20.0);
                    double motionZ = zOffset * ((double)motionStr / 20.0);
                    double motionY = 0.1 + (double)(RANDOM.nextFloat() * (float)motionStr) / 20.0;
                    IParticleMote particle = ParticleCollections.addWaterSpray(this.world, this.posX + xOffset, this.posY, this.posZ + zOffset, motionX, motionY, motionZ);
                    if (particle == null) break;
                }
                ++j;
            }
        }
    }

    static {
        ParticleWaterSplash.fallSounds[0] = Sounds.WATERFALL0;
        ParticleWaterSplash.fallSounds[1] = Sounds.WATERFALL0;
        ParticleWaterSplash.fallSounds[2] = Sounds.WATERFALL1;
        ParticleWaterSplash.fallSounds[3] = Sounds.WATERFALL1;
        ParticleWaterSplash.fallSounds[4] = Sounds.WATERFALL2;
        ParticleWaterSplash.fallSounds[5] = Sounds.WATERFALL3;
        ParticleWaterSplash.fallSounds[6] = Sounds.WATERFALL3;
        ParticleWaterSplash.fallSounds[7] = Sounds.WATERFALL4;
        ParticleWaterSplash.fallSounds[8] = Sounds.WATERFALL4;
        ParticleWaterSplash.fallSounds[9] = Sounds.WATERFALL5;
        ParticleWaterSplash.fallSounds[10] = Sounds.WATERFALL5;
        pos = new BlockPos.MutableBlockPos();
    }
}

