/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.mote;

import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.lib.random.XorShiftRandom;

public enum RippleStyle {
    ORIGINAL("textures/particles/ripple.png"),
    CIRCLE("textures/particles/ripple1.png"),
    SQUARE("textures/particles/ripple2.png"),
    PIXELATED("textures/particles/pixel_ripples.png"){
        private final int FRAMES = 7;
        private final float DELTA = 0.14285715f;
        private final int MAX_AGE = 14;

        @Override
        public float getU1(int age) {
            return (float)(age / 2) * 0.14285715f;
        }

        @Override
        public float getU2(int age) {
            return this.getU1(age) + 0.14285715f;
        }

        @Override
        public boolean doScaling() {
            return false;
        }

        @Override
        public int getMaxAge() {
            return 14;
        }
    };

    private final ResourceLocation resource;

    private RippleStyle(String texture) {
        this.resource = new ResourceLocation("dsurround", texture);
    }

    @Nonnull
    public ResourceLocation getTexture() {
        return this.resource;
    }

    public float getU1(int age) {
        return 0.0f;
    }

    public float getU2(int age) {
        return 1.0f;
    }

    public float getV1(int age) {
        return 0.0f;
    }

    public float getV2(int age) {
        return 1.0f;
    }

    public boolean doScaling() {
        return true;
    }

    public boolean doAlpha() {
        return true;
    }

    public int getMaxAge() {
        return 12 + XorShiftRandom.current().nextInt(8);
    }

    @Nonnull
    public static RippleStyle getStyle(int v) {
        if (v >= RippleStyle.values().length) {
            return CIRCLE;
        }
        return RippleStyle.values()[v];
    }

    @Nonnull
    public static RippleStyle get() {
        return RippleStyle.getStyle(ModOptions.rain.rainRippleStyle);
    }
}

