/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle;

import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.ParticleCollections;
import org.orecruncher.dsurround.client.fx.particle.ParticleSteamCloud;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class ParticleDripOverride
extends ParticleDrip {
    private boolean firstTime = true;
    private final Material materialType;
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private int bobTimer = 40;

    protected ParticleDripOverride(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, Material materialType) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, materialType);
        this.materialType = materialType;
    }

    private boolean doSteamHiss(@Nonnull IBlockState state) {
        if (this.materialType == Material.field_151587_i && state.func_185904_a() == Material.field_151586_h) {
            return true;
        }
        return this.materialType == Material.field_151586_h && ParticleSteamCloud.isHotBlock(state.func_177230_c());
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.materialType == Material.field_151586_h) {
            this.field_70552_h = 0.2f;
            this.field_70553_i = 0.3f;
            this.field_70551_j = 1.0f;
        } else {
            this.field_70552_h = 1.0f;
            this.field_70553_i = 16.0f / (float)(40 - this.bobTimer + 16);
            this.field_70551_j = 4.0f / (float)(40 - this.bobTimer + 8);
        }
        this.field_187130_j -= (double)this.field_70545_g;
        if (this.bobTimer-- > 0) {
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
            this.func_70536_a(113);
        } else {
            this.func_70536_a(112);
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
        if (this.field_187132_l) {
            this.pos.func_189532_c(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            boolean doSteam = false;
            IBlockState state = ClientChunkCache.instance().func_180495_p((BlockPos)this.pos);
            if (state.func_177230_c() == Blocks.field_150353_l) {
                doSteam = true;
            } else if (state.func_185904_a().func_76224_d()) {
                doSteam = ParticleCollections.addWaterRipple(this.field_187122_b, this.field_187126_f, this.pos.func_177956_o() + 1, this.field_187128_h) != null && this.materialType == Material.field_151587_i;
            } else {
                this.pos.func_189536_c(EnumFacing.DOWN);
                state = ClientChunkCache.instance().func_180495_p((BlockPos)this.pos);
                doSteam = ParticleSteamCloud.isHotBlock(state.func_177230_c());
            }
            if (doSteam) {
                ParticleHelper.addParticle((Particle)new ParticleSteamCloud(this.field_187122_b, this.field_187126_f, this.pos.func_177956_o() + 1, this.field_187128_h, 0.01));
            } else if (this.materialType != Material.field_151587_i) {
                this.field_187122_b.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0, new int[0]);
            }
            this.func_187112_i();
        }
        if (this.field_187127_g < 1.0) {
            this.func_187112_i();
        }
        if (this.func_187113_k() && this.firstTime) {
            this.firstTime();
        }
    }

    protected void firstTime() {
        this.firstTime = false;
        IBlockAccessEx provider = ClientChunkCache.instance();
        this.pos.func_189532_c(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        IBlockState state = provider.func_180495_p((BlockPos)this.pos);
        if (!WorldUtils.isAirBlock((IBlockState)state)) {
            this.func_187112_i();
        } else {
            this.pos.func_189532_c(this.field_187126_f, this.field_187127_g + 0.3, this.field_187128_h);
            int y = this.pos.func_177956_o();
            state = provider.func_180495_p((BlockPos)this.pos);
            if (!WorldUtils.isAirBlock((IBlockState)state) && !WorldUtils.isLeaves((IBlockState)state)) {
                do {
                    this.pos.func_189534_c(EnumFacing.DOWN, 1);
                    state = provider.func_180495_p((BlockPos)this.pos);
                } while (this.pos.func_177956_o() > 0 && WorldUtils.isAirBlock((IBlockState)state));
                if (this.pos.func_177956_o() < 1) {
                    return;
                }
                int delay = 40 + (y - this.pos.func_177956_o()) * 2;
                this.pos.func_189534_c(EnumFacing.UP, 1);
                SoundEffect effect = this.doSteamHiss(state) ? Sounds.STEAM_HISS : (state.func_185904_a().func_76220_a() ? Sounds.WATER_DROP : (this.materialType == Material.field_151586_h ? Sounds.WATER_DRIP : Sounds.WATER_DROP));
                SoundEffectHandler.INSTANCE.playSoundAt((BlockPos)this.pos, effect, delay);
            }
        }
    }

    public static void register() {
        Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.DRIP_WATER.func_179348_c(), (IParticleFactory)new WaterFactory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.DRIP_LAVA.func_179348_c(), (IParticleFactory)new LavaFactory());
    }

    public static class WaterFactory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleDripOverride(worldIn, xCoordIn, yCoordIn, zCoordIn, Material.field_151586_h);
        }
    }

    public static class LavaFactory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new ParticleDripOverride(worldIn, xCoordIn, yCoordIn, zCoordIn, Material.field_151587_i);
        }
    }
}

