/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleWaterSplash;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class WaterSplashJetEffect
extends JetEffect {
    private static final Vec3i[] cardinal_offsets = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)};

    public WaterSplashJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.SPLASH_JET;
    }

    private static boolean isUnboundedLiquid(IBlockAccessEx provider, BlockPos pos) {
        BlockPos.MutableBlockPos tp = new BlockPos.MutableBlockPos();
        for (int i = 0; i < cardinal_offsets.length; ++i) {
            Vec3i offset = cardinal_offsets[i];
            tp.func_181079_c(pos.func_177958_n() + offset.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + offset.func_177952_p());
            IBlockState state = provider.func_180495_p((BlockPos)tp);
            if (state.func_177230_c() == Blocks.field_150350_a) {
                return true;
            }
            if (!state.func_185904_a().func_76224_d() || WorldUtils.isFullWaterBlock((IBlockState)state) || provider.func_180495_p((BlockPos)tp.func_189536_c(EnumFacing.UP)).func_185904_a().func_76224_d()) continue;
            return true;
        }
        return false;
    }

    private int liquidBlockCount(IBlockAccessEx provider, BlockPos pos) {
        int count;
        BlockPos.MutableBlockPos workBlock = new BlockPos.MutableBlockPos(pos);
        for (count = 0; count < 10 && provider.func_180495_p((BlockPos)workBlock).func_185904_a().func_76224_d(); ++count) {
            workBlock.func_185336_p(workBlock.func_177956_o() + 1);
        }
        return MathStuff.clamp((int)count, (int)0, (int)10);
    }

    public static boolean isValidSpawnBlock(IBlockAccessEx provider, BlockPos pos) {
        if (!provider.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        if (WaterSplashJetEffect.isUnboundedLiquid(provider, pos)) {
            BlockPos down = pos.func_177977_b();
            if (provider.func_180495_p(down).func_185904_a().func_76220_a()) {
                return true;
            }
            return !WaterSplashJetEffect.isUnboundedLiquid(provider, down);
        }
        return provider.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockDynamicLiquid;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WaterSplashJetEffect.isValidSpawnBlock(provider, pos) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = this.liquidBlockCount(provider, pos);
        if (strength <= 1) {
            return;
        }
        float height = BlockLiquid.func_149801_b((int)state.func_177230_c().func_176201_c(state)) + 0.1f;
        double y = height + (float)pos.func_177956_o();
        ParticleWaterSplash effect = new ParticleWaterSplash(strength, provider.getWorld(), pos, (double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
        this.addEffect(effect);
    }
}

