/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleJet;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.handlers.ParticleSystemHandler;
import org.orecruncher.dsurround.expression.ExpressionEngine;
import org.orecruncher.lib.chunk.IBlockAccessEx;

@SideOnly(value=Side.CLIENT)
public abstract class JetEffect
extends BlockEffect {
    protected static final int MAX_STRENGTH = 10;

    protected static int countBlocks(IBlockAccessEx provider, BlockPos pos, IBlockState state, int dir) {
        int count = 0;
        int idx = pos.func_177956_o();
        while (count < 10) {
            Block block = provider.getBlockState(pos.func_177958_n(), idx, pos.func_177952_p()).func_177230_c();
            if (block != state.func_177230_c()) {
                return count;
            }
            ++count;
            idx += dir;
        }
        return count;
    }

    protected static double jetSpawnHeight(IBlockState state, BlockPos pos) {
        int meta = state.func_177230_c().func_176201_c(state);
        return 1.1 - (double)BlockLiquid.func_149801_b((int)meta) + (double)pos.func_177956_o();
    }

    public JetEffect(int chance) {
        super(chance);
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (this.alwaysExecute() || random.nextInt(this.getChance()) == 0) {
            ParticleSystemHandler ps = (ParticleSystemHandler)EffectManager.instance().lookupService(ParticleSystemHandler.class);
            return ps.okToSpawn(pos) && ExpressionEngine.instance().check(this.getConditions());
        }
        return false;
    }

    protected void addEffect(ParticleJet fx) {
        ParticleSystemHandler ps = (ParticleSystemHandler)EffectManager.instance().lookupService(ParticleSystemHandler.class);
        ps.addSystem(fx);
    }
}

