/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import com.google.common.base.Optional;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.footsteps.BlockAcousticMap;
import org.orecruncher.dsurround.client.footsteps.Substrate;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.acoustics.AcousticRegistry;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.blockstate.BlockStateMatcher;
import org.orecruncher.lib.BlockNameUtil;

@SideOnly(value=Side.CLIENT)
public class BlockMap {
    private final AcousticRegistry acousticsManager;
    private final BlockAcousticMap metaMap;
    private final Map<Substrate, BlockAcousticMap> substrateMap = new EnumMap<Substrate, BlockAcousticMap>(Substrate.class);
    private static final Map<String, List<MacroEntry>> macros = new Object2ObjectOpenHashMap();

    public BlockMap(@Nonnull AcousticRegistry manager) {
        this.acousticsManager = manager;
        this.metaMap = new BlockAcousticMap(bs -> RegistryManager.FOOTSTEPS.resolve(bs));
    }

    public boolean hasAcoustics(@Nonnull IBlockState state) {
        return this.metaMap.getBlockAcoustics(state) != AcousticRegistry.EMPTY;
    }

    @Nonnull
    public IAcoustic[] getBlockAcoustics(@Nonnull IBlockState state) {
        return this.getBlockAcoustics(state, null);
    }

    @Nonnull
    public IAcoustic[] getBlockAcoustics(@Nonnull IBlockState state, @Nullable Substrate substrate) {
        if (state == Blocks.field_150350_a.func_176223_P()) {
            return AcousticRegistry.NOT_EMITTER;
        }
        if (substrate != null) {
            BlockAcousticMap sub = this.substrateMap.get((Object)substrate);
            return sub != null ? sub.getBlockAcoustics(state) : AcousticRegistry.EMPTY;
        }
        return this.metaMap.getBlockAcoustics(state);
    }

    private void put(@Nonnull BlockStateMatcher info, @Nonnull String substrate, @Nonnull String value) {
        Substrate s = Substrate.get(substrate);
        IAcoustic[] acoustics = this.acousticsManager.compileAcoustics(value);
        if (s == null) {
            this.metaMap.put(info, acoustics);
        } else {
            BlockAcousticMap sub = this.substrateMap.get((Object)s);
            if (sub == null) {
                sub = new BlockAcousticMap();
                this.substrateMap.put(s, sub);
            }
            sub.put(info, acoustics);
        }
    }

    private void expand(@Nonnull BlockStateMatcher info, @Nonnull String value) {
        List<MacroEntry> macro = macros.get(value);
        if (macro != null) {
            for (MacroEntry entry : macro) {
                IBlockState state = entry.withProperty(info.getBlock().func_176223_P());
                this.put(BlockStateMatcher.create(state), entry.substrate, entry.value);
            }
        } else {
            ModBase.log().debug("Unknown macro '%s'", new Object[]{value});
        }
    }

    public void register(@Nonnull String key, @Nonnull String value) {
        BlockNameUtil.NameResult name = BlockNameUtil.parseBlockName((String)key);
        if (name != null) {
            String blockName = name.getBlockName();
            Block block = name.getBlock();
            if (block == null) {
                ModBase.log().debug("Unable to locate block for blockMap '%s'", new Object[]{blockName});
            } else {
                BlockStateMatcher matcher = BlockStateMatcher.create(name);
                if (value.startsWith("#")) {
                    this.expand(matcher, value);
                } else {
                    String substrate = name.getExtras();
                    this.put(matcher, substrate, value);
                }
            }
        } else {
            ModBase.log().warn("Malformed key in blockMap '%s'", new Object[]{key});
        }
    }

    @Nonnull
    private static String combine(@Nonnull IAcoustic[] acoustics) {
        return Arrays.stream(acoustics).map(IAcoustic::getName).collect(Collectors.joining(","));
    }

    public void collectData(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull List<String> data) {
        IAcoustic[] temp = this.getBlockAcoustics(state);
        if (temp != AcousticRegistry.EMPTY) {
            data.add(BlockMap.combine(temp));
        }
        for (Map.Entry<Substrate, BlockAcousticMap> e : this.substrateMap.entrySet()) {
            IAcoustic[] acoustics = e.getValue().getBlockAcoustics(state);
            if (acoustics == AcousticRegistry.EMPTY) continue;
            data.add((Object)((Object)e.getKey()) + ":" + BlockMap.combine(acoustics));
        }
    }

    public void clear() {
        this.metaMap.clear();
        this.substrateMap.clear();
    }

    static {
        MacroEntry MESSY = new MacroEntry("messy", "MESSY_GROUND");
        ArrayList<MacroEntry> entries = new ArrayList<MacroEntry>();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#sapling", entries);
        macros.put("#reed", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "brush"));
        macros.put("#plant", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "leaves"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "brush_straw_transition"));
        macros.put("#bush", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("bigger", "bluntwood"));
        macros.put("#fence", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "straw"));
        entries.add(MESSY);
        entries.add(new MacroEntry("foliage", "straw"));
        macros.put("#vine", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(new MacroEntry("carpet", "rug"));
        macros.put("#moss", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "1", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "2", "foliage", "brush"));
        entries.add(new MacroEntry("age", "3", "foliage", "brush"));
        entries.add(new MacroEntry("age", "4", "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry("age", "5", "foliage", "brush_straw_transition"));
        entries.add(new MacroEntry("age", "6", "foliage", "straw"));
        entries.add(new MacroEntry("age", "7", "foliage", "straw"));
        macros.put("#wheat", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "1", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "2", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "3", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "4", "foliage", "brush"));
        entries.add(new MacroEntry("age", "5", "foliage", "brush"));
        entries.add(new MacroEntry("age", "6", "foliage", "brush"));
        entries.add(new MacroEntry("age", "7", "foliage", "brush"));
        macros.put("#crop", entries);
        entries = new ArrayList();
        entries.add(new MacroEntry(null, "NOT_EMITTER"));
        entries.add(MESSY);
        entries.add(new MacroEntry("age", "0", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "1", "foliage", "NOT_EMITTER"));
        entries.add(new MacroEntry("age", "2", "foliage", "brush"));
        entries.add(new MacroEntry("age", "3", "foliage", "brush"));
        macros.put("#beets", entries);
    }

    private static class MacroEntry {
        public final String propertyName;
        public final String propertyValue;
        public final String substrate;
        public final String value;

        public MacroEntry(@Nonnull String substrate, @Nonnull String value) {
            this(null, null, substrate, value);
        }

        public MacroEntry(@Nullable String propertyName, @Nullable String propertyValue, @Nonnull String substrate, @Nonnull String value) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.substrate = substrate;
            this.value = value;
        }

        @Nonnull
        public IBlockState withProperty(@Nonnull IBlockState state) {
            if (this.propertyName == null) {
                return state;
            }
            IProperty iProp = state.func_177230_c().func_176194_O().func_185920_a(this.propertyName);
            if (iProp != null) {
                return MacroEntry.setValueHelper(state, iProp, this.propertyValue);
            }
            return state;
        }

        private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState state, IProperty<T> prop, String value) {
            Optional optional = prop.func_185929_b(value);
            if (optional.isPresent()) {
                return state.func_177226_a(prop, (Comparable)optional.get());
            }
            return state;
        }
    }
}

