/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.acoustics.AcousticRegistry;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.blockstate.BlockStateMatcher;

@SideOnly(value=Side.CLIENT)
public final class BlockAcousticMap {
    protected final IAcousticResolver resolver;
    protected Map<BlockStateMatcher, IAcoustic[]> data = new Object2ObjectOpenHashMap();
    protected Map<IBlockState, IAcoustic[]> cache = new Reference2ObjectOpenHashMap();

    public BlockAcousticMap() {
        this(state -> AcousticRegistry.EMPTY);
    }

    public BlockAcousticMap(@Nonnull IAcousticResolver resolver) {
        this.resolver = resolver;
        this.data.put(BlockStateMatcher.AIR, AcousticRegistry.NOT_EMITTER);
    }

    @Nonnull
    protected IAcoustic[] cacheMiss(@Nonnull IBlockState state) {
        BlockStateMatcher matcher = BlockStateMatcher.create(state);
        IAcoustic[] result = this.data.get(matcher);
        if (result != null) {
            return result;
        }
        if (matcher.hasSubtypes()) {
            result = this.data.get(BlockStateMatcher.asGeneric(state));
        }
        if (result != null) {
            return result;
        }
        if (this.resolver != null) {
            result = this.resolver.resolve(state);
        }
        return result != null ? result : AcousticRegistry.EMPTY;
    }

    @Nonnull
    public IAcoustic[] getBlockAcoustics(@Nonnull IBlockState state) {
        IAcoustic[] result = this.cache.get(state);
        if (result == null) {
            result = this.cacheMiss(state);
            this.cache.put(state, result);
        }
        return result;
    }

    public void put(@Nonnull BlockStateMatcher info, @Nonnull IAcoustic[] acoustics) {
        this.data.put(info, acoustics);
    }

    public void clear() {
        this.data = new Object2ObjectOpenHashMap(this.data.size());
        this.cache = new Reference2ObjectOpenHashMap(this.cache.size());
    }

    public static interface IAcousticResolver {
        @Nullable
        public IAcoustic[] resolve(@Nonnull IBlockState var1);
    }
}

