/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.season;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.capabilities.season.SeasonInfo;
import org.orecruncher.dsurround.capabilities.season.SeasonType;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.lib.chunk.ClientChunkCache;
import sereneseasons.api.season.BiomeHooks;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;

@SideOnly(value=Side.CLIENT)
public class SeasonInfoSereneSeasons
extends SeasonInfo {
    public SeasonInfoSereneSeasons(@Nonnull World world) {
        super(world);
    }

    @Override
    @Nonnull
    public SeasonType getSeasonType() {
        Season season = SeasonHelper.getSeasonState((World)this.world).getSeason();
        switch (season) {
            case SUMMER: {
                return SeasonType.SUMMER;
            }
            case AUTUMN: {
                return SeasonType.AUTUMN;
            }
            case WINTER: {
                return SeasonType.WINTER;
            }
            case SPRING: {
                return SeasonType.SPRING;
            }
        }
        return SeasonType.NONE;
    }

    @Override
    @Nonnull
    public SeasonType.SubType getSeasonSubType() {
        Season.SubSeason sub = SeasonHelper.getSeasonState((World)this.world).getSubSeason();
        switch (sub) {
            case EARLY_SUMMER: 
            case EARLY_AUTUMN: 
            case EARLY_WINTER: 
            case EARLY_SPRING: {
                return SeasonType.SubType.EARLY;
            }
            case MID_SUMMER: 
            case MID_AUTUMN: 
            case MID_WINTER: 
            case MID_SPRING: {
                return SeasonType.SubType.MID;
            }
            case LATE_SUMMER: 
            case LATE_AUTUMN: 
            case LATE_WINTER: 
            case LATE_SPRING: {
                return SeasonType.SubType.LATE;
            }
        }
        return SeasonType.SubType.NONE;
    }

    @Override
    public float getFloatTemperature(@Nonnull Biome biome, @Nonnull BlockPos pos) {
        return BiomeHooks.getFloatTemperature((World)this.world, (Biome)biome, (BlockPos)pos);
    }

    @Override
    public PrecipitationType getPrecipitationType(@Nonnull BlockPos pos, @Nullable BiomeInfo biome) {
        Biome trueBiome;
        if (biome == null) {
            biome = RegistryManager.BIOME.get(ClientChunkCache.instance().func_180494_b(pos));
        }
        if ((trueBiome = biome.getBiome()) != null && BiomeConfig.usesTropicalSeasons((Biome)trueBiome)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState((World)this.world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return PrecipitationType.NONE;
                }
                case MID_WET: {
                    return PrecipitationType.RAIN;
                }
            }
        }
        return super.getPrecipitationType(pos, biome);
    }
}

