/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.season;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.PrecipitationType;
import org.orecruncher.dsurround.capabilities.season.SeasonInfoNether;
import org.orecruncher.dsurround.capabilities.season.SeasonInfoSereneSeasons;
import org.orecruncher.dsurround.capabilities.season.SeasonType;
import org.orecruncher.dsurround.capabilities.season.TemperatureRating;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.chunk.ClientChunkCache;

@SideOnly(value=Side.CLIENT)
public class SeasonInfo
implements ISeasonInfo {
    protected static final float FREEZE_TEMP = 0.15f;
    protected static final float BREATH_TEMP = 0.2f;
    protected static final String noSeason = Localization.loadString((String)"dsurround.season.noseason");
    protected final World world;

    public SeasonInfo() {
        this.world = null;
    }

    public SeasonInfo(@Nonnull World world) {
        this.world = world;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nonnull
    public SeasonType getSeasonType() {
        return SeasonType.NONE;
    }

    @Override
    @Nonnull
    public SeasonType.SubType getSeasonSubType() {
        return SeasonType.SubType.NONE;
    }

    @Override
    @Nonnull
    public String getSeasonString() {
        SeasonType season = this.getSeasonType();
        if (season == SeasonType.NONE) {
            return noSeason;
        }
        SeasonType.SubType sub = this.getSeasonSubType();
        String seasonStr = Localization.loadString((String)("dsurround.season." + season.getValue()));
        String subSeasonStr = Localization.loadString((String)("dsurround.season." + sub.getValue()));
        return Localization.format((String)"dsurround.season.format", (Object[])new Object[]{subSeasonStr, seasonStr});
    }

    @Override
    @Nonnull
    public TemperatureRating getPlayerTemperature() {
        return this.getBiomeTemperature(EnvironStateHandler.EnvironState.getPlayerPosition());
    }

    @Override
    @Nonnull
    public TemperatureRating getBiomeTemperature(@Nonnull BlockPos pos) {
        return TemperatureRating.fromTemp(this.getTemperature(pos));
    }

    @Override
    @Nonnull
    public BlockPos getPrecipitationHeight(@Nonnull BlockPos pos) {
        return ClientChunkCache.instance().getPrecipitationHeight(pos);
    }

    @Override
    public float getFloatTemperature(@Nonnull Biome biome, @Nonnull BlockPos pos) {
        return RegistryManager.BIOME.get(biome).getFloatTemperature(pos);
    }

    @Override
    public float getTemperature(@Nonnull BlockPos pos) {
        Biome biome = ClientChunkCache.instance().func_180494_b(pos);
        return this.getFloatTemperature(biome, pos);
    }

    @Override
    public boolean canWaterFreeze(@Nonnull BlockPos pos) {
        return this.getTemperature(pos) < 0.15f;
    }

    @Override
    public boolean showFrostBreath(@Nonnull BlockPos pos) {
        return this.getTemperature(pos) < 0.2f;
    }

    protected boolean doDust(@Nonnull BiomeInfo biome) {
        return ModOptions.fog.allowDesertFog && !Weather.doVanilla() && biome.getHasDust();
    }

    @Override
    public PrecipitationType getPrecipitationType(@Nonnull BlockPos pos, @Nullable BiomeInfo biome) {
        if (biome == null) {
            biome = RegistryManager.BIOME.get(ClientChunkCache.instance().func_180494_b(pos));
        }
        if (!biome.hasWeatherEffect()) {
            return PrecipitationType.NONE;
        }
        if (this.doDust(biome)) {
            return PrecipitationType.DUST;
        }
        return this.getFloatTemperature(biome.getBiome(), pos) < 0.15f ? PrecipitationType.SNOW : PrecipitationType.RAIN;
    }

    public static SeasonInfo factory(@Nonnull World world) {
        if (world.field_73011_w.getDimension() == -1) {
            ModBase.log().info("Creating Nether SeasonInfo", new Object[0]);
            return new SeasonInfoNether(world);
        }
        if (ModEnvironment.SereneSeasons.isLoaded()) {
            ModBase.log().info("Creating Serene Seasons SeasonInfo for dimension %s", new Object[]{world.field_73011_w.func_186058_p().func_186065_b()});
            return new SeasonInfoSereneSeasons(world);
        }
        ModBase.log().info("Creating default SeasonInfo for dimension %s", new Object[]{world.field_73011_w.func_186058_p().func_186065_b()});
        return new SeasonInfo(world);
    }
}

