/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.dimension;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfoEx;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.dimension.DimensionData;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

public class DimensionInfo
implements IDimensionInfoEx {
    public static final float MIN_INTENSITY = 0.0f;
    public static final float MAX_INTENSITY = 1.0f;
    private static final DecimalFormat FORMATTER = new DecimalFormat("0");
    private final Random RANDOM = XorShiftRandom.current();
    protected final World world;
    protected WeakReference<DimensionData> ref;
    private float intensity = 0.0f;
    private float currentIntensity = 0.0f;
    private float minIntensity = ModOptions.rain.defaultMinRainStrength;
    private float maxIntensity = ModOptions.rain.defaultMaxRainStrength;
    private int thunderTimer = 0;

    public DimensionInfo() {
        this.world = null;
    }

    public DimensionInfo(@Nonnull World world) {
        this.world = world;
        this.ref = new WeakReference<Object>(null);
    }

    protected DimensionData data() {
        DimensionData result = (DimensionData)this.ref.get();
        if (result == null) {
            result = RegistryManager.DIMENSION.getData(this.world);
            this.ref = new WeakReference<DimensionData>(result);
        }
        return result;
    }

    @Override
    public int getId() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.data().getName();
    }

    @Override
    public int getSeaLevel() {
        return this.data().getSeaLevel();
    }

    @Override
    public int getSkyHeight() {
        return this.data().getSkyHeight();
    }

    @Override
    public int getCloudHeight() {
        return this.data().getCloudHeight();
    }

    @Override
    public int getSpaceHeight() {
        return this.data().getSpaceHeight();
    }

    @Override
    public boolean hasHaze() {
        return this.data().getHasHaze();
    }

    @Override
    public boolean hasAuroras() {
        return this.data().getHasAuroras();
    }

    @Override
    public boolean hasWeather() {
        return this.data().getHasWeather();
    }

    @Override
    public boolean hasFog() {
        return this.data().getHasFog();
    }

    @Override
    public boolean playBiomeSounds() {
        return this.data().getPlayBiomeSounds();
    }

    @Override
    public float getRainIntensity() {
        return this.intensity;
    }

    @Override
    public float getCurrentRainIntensity() {
        return this.currentIntensity;
    }

    @Override
    public void setRainIntensity(float intensity) {
        this.intensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)1.0f);
    }

    @Override
    public void setCurrentRainIntensity(float intensity) {
        this.currentIntensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)this.intensity);
    }

    @Override
    public float getMinRainIntensity() {
        return this.minIntensity;
    }

    @Override
    public void setMinRainIntensity(float intensity) {
        this.minIntensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)this.maxIntensity);
    }

    @Override
    public float getMaxRainIntensity() {
        return this.maxIntensity;
    }

    @Override
    public void setMaxRainIntensity(float intensity) {
        this.maxIntensity = MathStuff.clamp((float)intensity, (float)this.minIntensity, (float)1.0f);
    }

    @Override
    public int getThunderTimer() {
        return this.thunderTimer;
    }

    @Override
    public void setThunderTimer(int time) {
        this.thunderTimer = MathStuff.clamp((int)time, (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public void randomizeRain() {
        float result;
        float delta = this.maxIntensity - this.minIntensity;
        if (delta <= 0.0f) {
            result = this.minIntensity;
        } else {
            float mid = delta / 2.0f;
            result = this.minIntensity + this.RANDOM.nextFloat() * mid + this.RANDOM.nextFloat() * mid;
        }
        this.setRainIntensity(MathStuff.clamp((float)result, (float)0.01f, (float)1.0f));
        this.setCurrentRainIntensity(0.0f);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("i", this.getRainIntensity());
        nbt.func_74776_a("ci", this.getCurrentRainIntensity());
        nbt.func_74776_a("min", this.getMinRainIntensity());
        nbt.func_74776_a("max", this.getMaxRainIntensity());
        nbt.func_74768_a("th", this.getThunderTimer());
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.setRainIntensity(nbt.func_74760_g("i"));
        this.setCurrentRainIntensity(nbt.func_74760_g("ci"));
        this.setMinRainIntensity(nbt.func_74760_g("min"));
        this.setMaxRainIntensity(nbt.func_74760_g("max"));
        this.setThunderTimer(nbt.func_74762_e("th"));
    }

    @Override
    @Nonnull
    public String configString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.getId()).append(": ");
        builder.append("rainIntensity [").append(FORMATTER.format(this.getMinRainIntensity() * 100.0f));
        builder.append(",").append(FORMATTER.format(this.getMaxRainIntensity() * 100.0f));
        builder.append("]");
        return builder.toString();
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.getId()).append(": ");
        builder.append("rainIntensity: ").append(FORMATTER.format(this.getRainIntensity() * 100.0f));
        builder.append('/').append(FORMATTER.format(this.getCurrentRainIntensity() * 100.0f));
        builder.append(" [").append(FORMATTER.format(this.getMinRainIntensity() * 100.0f));
        builder.append(",").append(FORMATTER.format(this.getMaxRainIntensity() * 100.0f));
        builder.append("], thunderTimer: ").append(this.getThunderTimer());
        return builder.toString();
    }

    private final class NBT {
        public static final String INTENSITY = "i";
        public static final String CURRENT_INTENSITY = "ci";
        public static final String MIN_INTENSITY = "min";
        public static final String MAX_INTENSITY = "max";
        public static final String THUNDER_TIMER = "th";

        private NBT() {
        }
    }
}

