/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround;

import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.config.Profiles;
import org.orecruncher.lib.ConfigProcessor;

public final class ModOptions {
    public static final String CATEGORY_ASM = "asm";
    public static final String CONFIG_ENABLE_WEATHER = "Enable Weather Control";
    public static final String CONFIG_DISABLE_ARROW_CRITICAL_TRAIL = "Disable Arrow Critical Particle Trail";
    public static final String CATEGORY_LOGGING_CONTROL = "logging";
    public static final String CONFIG_ENABLE_ONLINE_VERSION_CHECK = "Enable Online Version Check";
    public static final String CONFIG_ENABLE_DEBUG_LOGGING = "Enable Debug Logging";
    public static final String CONFIG_REPORT_SERVER_STATS = "Report Server Stats";
    public static final String CONFIG_DEBUG_FLAG_MASK = "Debug Flag Mask";
    public static final String CATEGORY_RAIN = "rain";
    public static final String CONFIG_VANILLA_RAIN = "Use Vanilla Algorithms";
    public static final String CONFIG_USE_VANILLA_RAIN_SOUND = "Use Vanilla Rain Sound";
    public static final String CONFIG_ENABLE_BACKGROUND_THUNDER = "Enable Background Thunder";
    public static final String CONFIG_THUNDER_THRESHOLD = "Rain Intensity for Background Thunder";
    public static final String CONFIG_RAIN_RIPPLE_STYLE = "Style of rain water ripple";
    public static final String CONFIG_MIN_RAIN_STRENGTH = "Default Minimum Rain Strength";
    public static final String CONFIG_MAX_RAIN_STRENGTH = "Default Maximum Rain Strength";
    public static final String CATEGORY_FOG = "fog";
    public static final String CONFIG_ENABLE_FOG_PROCESSING = "Enable Fog Processing";
    public static final String CONFIG_ENABLE_MORNING_FOG = "Morning Fog";
    public static final String CONFIG_MORNING_FOG_CHANCE = "Morning Fog Chance";
    public static final String CONFIG_ENABLE_WEATHER_FOG = "Weather Fog";
    public static final String CONFIG_ENABLE_BEDROCK_FOG = "Bedrock Fog";
    public static final String CONFIG_ALLOW_DESERT_FOG = "Desert Fog";
    public static final String CONFIG_ENABLE_ELEVATION_HAZE = "Elevation Haze";
    public static final String CONFIG_ENABLE_BIOME_FOG = "Biomes Fog";
    public static final String CATEGORY_GENERAL = "general";
    public static final String CONFIG_EXTERNAL_SCRIPTS = "External Configuration Files";
    public static final String CONFIG_STARTUP_SOUND_LIST = "Startup Sound List";
    public static final String CONFIG_HIDE_CHAT_NOTICES = "Hide Chat Notices";
    public static final String CONFIG_ENABLE_CLIENT_CHUNK_CACHING = "Enable Client Chunk Caching";
    public static final String CATEGORY_AURORA = "aurora";
    public static final String CONFIG_AURORA_ENABLED = "Enabled";
    public static final String CONFIG_AURORA_SHADER = "Use Shaders";
    public static final String CATEGORY_BIOMES = "biomes";
    public static final String CONFIG_BIOME_SEALEVEL = "Overworld Sealevel Override";
    public static final String CONFIG_BIOME_ALIASES = "Biomes Alias";
    public static final String CONFIG_BIOME_DIM_BLACKLIST = "Dimension Blacklist";
    public static final String CATEGORY_EFFECTS = "effects";
    public static final String CONFIG_FX_RANGE = "Special Effect Range";
    public static final String CONFIG_DISABLE_SUSPEND = "Disable Water Suspend Particles";
    public static final String CONFIG_WATERFALL_CUTOFF = "Waterfall Cutoff";
    public static final String CONFIG_BLOCK_EFFECT_STEAM = "Enable Steam";
    public static final String CONFIG_BLOCK_EFFECT_FIRE = "Enable FireJetEffect Jets";
    public static final String CONFIG_BLOCK_EFFECT_BUBBLE = "Enable Bubbles";
    public static final String CONFIG_BLOCK_EFFECT_DUST = "Enable DustJetEffect Motes";
    public static final String CONFIG_BLOCK_EFFECT_FOUNTAIN = "Enable FountainJetEffect";
    public static final String CONFIG_BLOCK_EFFECT_FIREFLY = "Enable Fireflies";
    public static final String CONFIG_BLOCK_EFFECT_SPLASH = "Enable Water Splash";
    public static final String CONFIG_ENABLE_POPOFFS = "Damage Popoffs";
    public static final String CONFIG_SHOW_CRIT_WORDS = "Show Crit Words";
    public static final String CONFIG_ENABLE_FOOTPRINTS = "Footprints";
    public static final String CONFIG_FOOTPRINT_STYLE = "Footprint Style";
    public static final String CONFIG_SHOW_BREATH = "Show Frost Breath";
    public static final String CATEGORY_SOUND = "sound";
    public static final String CONFIG_ENABLE_BATTLEMUSIC = "Battle Music";
    public static final String CONFIG_ENABLE_BIOME_SOUNDS = "Enable Biomes Sounds";
    public static final String CONFIG_MASTER_SOUND_FACTOR = "Master Sound Scale Factor";
    public static final String CONFIG_AUTO_CONFIG_CHANNELS = "Autoconfigure Channels";
    public static final String CONFIG_NORMAL_CHANNEL_COUNT = "Number Normal Channels";
    public static final String CONFIG_STREAMING_CHANNEL_COUNT = "Number Streaming Channels";
    public static final String CONFIG_STREAM_BUFFER_SIZE = "Stream Buffer Size";
    public static final String CONFIG_STREAM_BUFFER_COUNT = "Number of Stream Buffers per Channel";
    public static final String CONFIG_MUTE_WHEN_BACKGROUND = "Mute when Background";
    public static final String CONFIG_ENABLE_JUMP_SOUND = "Jump Sound";
    public static final String CONFIG_ENABLE_EQUIP_SOUND = "Equip Sound";
    public static final String CONFIG_SWORD_AS_TOOL_EQUIP_SOUND = "Sword Equip as Tool";
    public static final String CONFIG_ENABLE_CRAFTING_SOUND = "Crafting Sound";
    public static final String CONFIG_FOOTSTEPS_QUAD = "Footsteps as Quadruped";
    public static final String CONFIG_FOOTSTEPS_CADENCE = "First Person Footstep Cadence";
    public static final String CONFIG_ENABLE_ARMOR_SOUND = "Armor Sound";
    public static final String CONFIG_ENABLE_SWING_SOUND = "Swing Sound";
    public static final String CONFIG_ENABLE_PUDDLE_SOUND = "Rain Puddle Sound";
    public static final String CONFIG_SOUND_CULL_THRESHOLD = "Sound Culling Threshold";
    public static final String CONFIG_THUNDER_VOLUME = "Thunder Volume";
    public static final String CONFIG_SOUND_SETTINGS = "Sound Settings";
    public static final String CATEGORY_PLAYER = "player";
    public static final String CONFIG_SUPPRESS_POTION_PARTICLES = "Suppress Potion Particles";
    public static final String CONFIG_HURT_THRESHOLD = "Hurt Threshold";
    public static final String CONFIG_HUNGER_THRESHOLD = "Hunger Threshold";
    public static final String CATEGORY_SPEECHBUBBLES = "speechbubbles";
    public static final String CONFIG_OPTION_ENABLE_SPEECHBUBBLES = "Enable SpeechBubbles";
    public static final String CONFIG_OPTION_ENABLE_ENTITY_CHAT = "Enable Entity Chat";
    public static final String CONFIG_OPTION_SPEECHBUBBLE_DURATION = "Display Duration";
    public static final String CONFIG_OPTION_SPEECHBUBBLE_RANGE = "Visibility Range";
    public static final String CONFIG_OPTION_ANIMANIA_BADGES = "Animania Badges";
    public static final String CATEGORY_COMMANDS = "commands";
    public static final String CONFIG_COMMANDS_DS = "/ds";
    public static final String CONFIG_COMMANDS_CALC = "/calc";
    public static final String CONFIG_COMMAND_NAME = "name";
    public static final String CONFIG_COMMAND_ALIAS = "alias";
    public static final String CATEGORY_PROFILES = "profiles";

    public static void load(Configuration config) {
        ConfigProcessor.process((Configuration)config, ModOptions.class);
        if (ModBase.config() != null) {
            Profiles.tickle();
        }
        if (ModBase.config() != null) {
            for (String cat : config.getCategoryNames()) {
                ModOptions.scrubCategory(config.getCategory(cat));
            }
        }
    }

    private static void scrubCategory(ConfigCategory category) {
        ArrayList killList = new ArrayList();
        for (Map.Entry entry : category.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)((Property)entry.getValue()).getComment())) continue;
            killList.add(entry.getKey());
        }
        for (String kill : killList) {
            category.remove((Object)kill);
        }
    }

    @ConfigProcessor.Category(value="profiles")
    @ConfigProcessor.LangKey(value="dsurround.cfg.profiles.cat.Profiles")
    @ConfigProcessor.Comment(value="Enable/disable application of built in profiles")
    public static class profiles {
        public static String PATH = null;
    }

    @ConfigProcessor.Category(value="commands")
    @ConfigProcessor.LangKey(value="dsurround.cfg.commands.cat.Commands")
    @ConfigProcessor.Comment(value="Options for configuring commands")
    @ConfigProcessor.RestartRequired(server=true, world=true)
    public static class commands {
        public static String PATH = null;

        @ConfigProcessor.Category(value="/calc")
        public static class calc {
            public static String PATH = null;
            @ConfigProcessor.Option(value="name")
            @ConfigProcessor.DefaultValue(value="calc")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.Calc.Name")
            @ConfigProcessor.Comment(value="Name of the command")
            public static String commandNameCalc = "calc";
            @ConfigProcessor.Option(value="alias")
            @ConfigProcessor.DefaultValue(value="c math")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.Calc.Alias")
            @ConfigProcessor.Comment(value="Alias for the command")
            public static String commandAliasCalc = "c math";
        }

        @ConfigProcessor.Category(value="/ds")
        public static class ds {
            public static String PATH = null;
            @ConfigProcessor.Option(value="name")
            @ConfigProcessor.DefaultValue(value="ds")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.DS.Name")
            @ConfigProcessor.Comment(value="Name of the command")
            public static String commandNameDS = "ds";
            @ConfigProcessor.Option(value="alias")
            @ConfigProcessor.DefaultValue(value="dsurround rain")
            @ConfigProcessor.LangKey(value="dsurround.cfg.commands.DS.Alias")
            @ConfigProcessor.Comment(value="Alias for the command")
            public static String commandAliasDS = "dsurround rain";
        }
    }

    @ConfigProcessor.Category(value="speechbubbles")
    @ConfigProcessor.LangKey(value="dsurround.cfg.speech.cat.Speech")
    @ConfigProcessor.Comment(value="Options for configuring SpeechBubbles")
    public static class speechbubbles {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable SpeechBubbles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.EnableSpeechBubbles")
        @ConfigProcessor.Comment(value="Enables/disables speech bubbles above player heads")
        public static boolean enableSpeechBubbles = false;
        @ConfigProcessor.Option(value="Enable Entity Chat")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.EnableEntityChat")
        @ConfigProcessor.Comment(value="Enables/disables entity chat bubbles")
        public static boolean enableEntityChat = false;
        @ConfigProcessor.Option(value="Display Duration")
        @ConfigProcessor.DefaultValue(value="7")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.Duration")
        @ConfigProcessor.RangeFloat(min=5.0f, max=15.0f)
        @ConfigProcessor.Comment(value="Number of seconds to display speech before removing")
        public static float speechBubbleDuration = 7.0f;
        @ConfigProcessor.Option(value="Visibility Range")
        @ConfigProcessor.DefaultValue(value="16")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.Range")
        @ConfigProcessor.RangeInt(min=16, max=32)
        @ConfigProcessor.Comment(value="Range at which a SpeechBubble is visible.  Filtering occurs server side.")
        public static float speechBubbleRange = 16.0f;
        @ConfigProcessor.Option(value="Animania Badges")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.speech.AnimaniaBadges")
        @ConfigProcessor.Comment(value="Enable/disable display of food/water badges over Animania mobs")
        @ConfigProcessor.RestartRequired(world=true, server=true)
        public static boolean enableAnimaniaBadges = true;
    }

    @ConfigProcessor.Category(value="player")
    @ConfigProcessor.LangKey(value="dsurround.cfg.player.cat.Player")
    @ConfigProcessor.Comment(value="General options for defining sound and effects the player entity")
    public static class player {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Suppress Potion Particles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.PotionParticles")
        @ConfigProcessor.Comment(value="Suppress player's potion particles from rendering")
        public static boolean suppressPotionParticles = false;
        @ConfigProcessor.Option(value="Hurt Threshold")
        @ConfigProcessor.DefaultValue(value="0.25")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.HurtThreshold")
        @ConfigProcessor.Comment(value="Percentage of player health bar remaining to trigger player hurt sound (0 disable)")
        @ConfigProcessor.RangeFloat(min=0.0f, max=0.5f)
        public static float playerHurtThreshold = 0.25f;
        @ConfigProcessor.Option(value="Hunger Threshold")
        @ConfigProcessor.DefaultValue(value="8")
        @ConfigProcessor.LangKey(value="dsurround.cfg.player.HungerThreshold")
        @ConfigProcessor.Comment(value="Amount of food bar remaining to trigger player hunger sound (0 disable)")
        @ConfigProcessor.RangeInt(min=0, max=10)
        public static int playerHungerThreshold = 8;
    }

    @ConfigProcessor.Category(value="sound")
    @ConfigProcessor.LangKey(value="dsurround.cfg.sound.cat.Sound")
    @ConfigProcessor.Comment(value="General options for defining sound effects")
    public static class sound {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Battle Music")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.BattleMusic")
        @ConfigProcessor.Comment(value="Enable/disable Battle Music")
        public static boolean enableBattleMusic = false;
        @ConfigProcessor.Option(value="Enable Biomes Sounds")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.BiomeSounds")
        @ConfigProcessor.Comment(value="Enable biome background and spot sounds")
        public static boolean enableBiomeSounds = true;
        @ConfigProcessor.Option(value="Autoconfigure Channels")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.AutoConfig")
        @ConfigProcessor.Comment(value="Automatically configure sound channels")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean autoConfigureChannels = true;
        @ConfigProcessor.Option(value="Number Normal Channels")
        @ConfigProcessor.DefaultValue(value="28")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.NormalChannels")
        @ConfigProcessor.RangeInt(min=28, max=255)
        @ConfigProcessor.Comment(value="Number of normal sound channels to configure in the sound system (manual)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int normalSoundChannelCount = 28;
        @ConfigProcessor.Option(value="Number Streaming Channels")
        @ConfigProcessor.DefaultValue(value="4")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamingChannels")
        @ConfigProcessor.RangeInt(min=4, max=255)
        @ConfigProcessor.Comment(value="Number of streaming sound channels to configure in the sound system (manual)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamingSoundChannelCount = 4;
        @ConfigProcessor.Option(value="Stream Buffer Size")
        @ConfigProcessor.DefaultValue(value="16")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamBufferSize")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Size of a stream buffer in kilobytes (0: system default - usually 128K bytes)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamBufferSize = 16;
        @ConfigProcessor.Option(value="Number of Stream Buffers per Channel")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.StreamBufferCount")
        @ConfigProcessor.RangeInt(min=0, max=8)
        @ConfigProcessor.Comment(value="Number of stream buffers per channel (0: system default - usually 3 buffers)")
        @ConfigProcessor.RestartRequired(server=true)
        public static int streamBufferCount = 0;
        @ConfigProcessor.Option(value="Mute when Background")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Mute")
        @ConfigProcessor.Comment(value="Mute sound when Minecraft is in the background")
        public static boolean muteWhenBackground = true;
        @ConfigProcessor.Option(value="Thunder Volume")
        @ConfigProcessor.DefaultValue(value="10000")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.ThunderVolume")
        @ConfigProcessor.Comment(value="Sound Volume of Thunder")
        @ConfigProcessor.RangeFloat(min=15.0f, max=10000.0f)
        public static float thunderVolume = 10000.0f;
        @ConfigProcessor.Option(value="Jump Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Jump")
        @ConfigProcessor.Comment(value="Enable player Jump sound effect")
        public static boolean enableJumpSound = true;
        @ConfigProcessor.Option(value="Equip Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Equip")
        @ConfigProcessor.Comment(value="Enable Weapon/Tool Equip sound effect")
        public static boolean enableEquipSound = true;
        @ConfigProcessor.Option(value="Sword Equip as Tool")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.SwordEquipAsTool")
        @ConfigProcessor.Comment(value="Enable Sword Equip sound as Tool")
        @ConfigProcessor.RestartRequired(world=true, server=true)
        public static boolean swordEquipAsTool = false;
        @ConfigProcessor.Option(value="Crafting Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Craft")
        @ConfigProcessor.Comment(value="Enable Item Crafted sound effect")
        public static boolean enableCraftingSound = true;
        @ConfigProcessor.Option(value="Footsteps as Quadruped")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.FootstepQuad")
        @ConfigProcessor.Comment(value="Simulate quadruped with Footstep effects (horse)")
        public static boolean foostepsQuadruped = false;
        @ConfigProcessor.Option(value="First Person Footstep Cadence")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.FootstepCadence")
        @ConfigProcessor.Comment(value="true to match first person arm swing; false to match 3rd person leg animation")
        public static boolean firstPersonFootstepCadence = true;
        @ConfigProcessor.Option(value="Armor Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Armor")
        @ConfigProcessor.Comment(value="Enable/disable armor sounds when moving")
        public static boolean enableArmorSounds = true;
        @ConfigProcessor.Option(value="Swing Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Swing")
        @ConfigProcessor.Comment(value="Enable/disable item swing sounds")
        public static boolean enableSwingSounds = true;
        @ConfigProcessor.Option(value="Rain Puddle Sound")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.Puddle")
        @ConfigProcessor.Comment(value="Enable/disable rain puddle sound when moving in the rain")
        public static boolean enablePuddleSound = true;
        @ConfigProcessor.Option(value="Sound Culling Threshold")
        @ConfigProcessor.DefaultValue(value="20")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.CullInterval")
        @ConfigProcessor.RangeInt(min=0)
        @ConfigProcessor.Comment(value="Ticks between culled sound events (0 to disable culling)")
        public static int soundCullingThreshold = 20;
        @ConfigProcessor.Option(value="Sound Settings")
        @ConfigProcessor.Hidden
        @ConfigProcessor.DefaultValue(value="minecraft:block.water.ambient cull,minecraft:block.lava.ambient cull,minecraft:entity.sheep.ambient cull,minecraft:entity.chicken.ambient cull,minecraft:entity.cow.ambient cull,minecraft:entity.pig.ambient cull,dsurround:bison block")
        @ConfigProcessor.LangKey(value="dsurround.cfg.sound.SoundSettings")
        @ConfigProcessor.Comment(value="Configure how each individual sound will be handled")
        public static String[] soundSettings = new String[]{"minecraft:block.water.ambient cull", "minecraft:block.lava.ambient cull", "minecraft:entity.sheep.ambient cull", "minecraft:entity.chicken.ambient cull", "minecraft:entity.cow.ambient cull", "minecraft:entity.pig.ambient cull", "dsurround:bison block"};
    }

    @ConfigProcessor.Category(value="effects")
    @ConfigProcessor.LangKey(value="dsurround.cfg.effects.cat.Effects")
    @ConfigProcessor.Comment(value="Options for controlling various effects")
    public static class effects {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Special Effect Range")
        @ConfigProcessor.DefaultValue(value="24")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.FXRange")
        @ConfigProcessor.RangeInt(min=16, max=64)
        @ConfigProcessor.Comment(value="Block radius/range around player for special effect application")
        public static int specialEffectRange = 24;
        @ConfigProcessor.Option(value="Disable Water Suspend Particles")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Suspend")
        @ConfigProcessor.Comment(value="Enable/disable water depth particle effect")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean disableWaterSuspendParticle = false;
        @ConfigProcessor.Option(value="Waterfall Cutoff")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.WaterfallCutoff")
        @ConfigProcessor.RangeInt(min=0, max=10)
        @ConfigProcessor.Comment(value="Waterfall strength below which sounds will not play")
        public static int waterfallCutoff = 0;
        @ConfigProcessor.Option(value="Enable Steam")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Steam")
        @ConfigProcessor.Comment(value="Enable Steam Jets where lava meets water")
        public static boolean enableSteamJets = true;
        @ConfigProcessor.Option(value="Enable FireJetEffect Jets")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Fire")
        @ConfigProcessor.Comment(value="Enable FireJetEffect Jets in lava")
        public static boolean enableFireJets = true;
        @ConfigProcessor.Option(value="Enable Bubbles")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Bubble")
        @ConfigProcessor.Comment(value="Enable BubbleJetEffect Jets under water")
        public static boolean enableBubbleJets = true;
        @ConfigProcessor.Option(value="Enable DustJetEffect Motes")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Dust")
        @ConfigProcessor.Comment(value="Enable DustJetEffect motes dropping from blocks")
        public static boolean enableDustJets = true;
        @ConfigProcessor.Option(value="Enable FountainJetEffect")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Fountain")
        @ConfigProcessor.Comment(value="Enable FountainJetEffect jets")
        public static boolean enableFountainJets = true;
        @ConfigProcessor.Option(value="Enable Fireflies")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Fireflies")
        @ConfigProcessor.Comment(value="Enable Firefly effect around plants")
        public static boolean enableFireflies = true;
        @ConfigProcessor.Option(value="Enable Water Splash")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Splash")
        @ConfigProcessor.Comment(value="Enable Water Splash effects when water spills down")
        public static boolean enableWaterSplash = true;
        @ConfigProcessor.Option(value="Damage Popoffs")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Popoffs")
        @ConfigProcessor.Comment(value="Controls display of damage pop-offs when an entity is damaged")
        public static boolean enableDamagePopoffs = true;
        @ConfigProcessor.Option(value="Show Crit Words")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.CritWords")
        @ConfigProcessor.Comment(value="Display random power word on critical hit")
        public static boolean showCritWords = true;
        @ConfigProcessor.Option(value="Footprints")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.Footprints")
        @ConfigProcessor.Comment(value="Enable player footprints")
        public static boolean enableFootprints = true;
        @ConfigProcessor.Option(value="Footprint Style")
        @ConfigProcessor.DefaultValue(value="6")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.FootprintStyle")
        @ConfigProcessor.Comment(value="0: shoe print, 1: square print, 2: horse hoof, 3: bird, 4: paw, 5: solid square, 6: lowres square")
        @ConfigProcessor.RangeInt(min=0, max=6)
        public static int footprintStyle = 6;
        @ConfigProcessor.Option(value="Show Frost Breath")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.effects.ShowBreath")
        @ConfigProcessor.Comment(value="Show player frost breath in cold weather")
        public static boolean showBreath = true;
    }

    @ConfigProcessor.Category(value="biomes")
    @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.cat.Biomes")
    @ConfigProcessor.Comment(value="Options for controlling biome sound/effects")
    public static class biomes {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Overworld Sealevel Override")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.Sealevel")
        @ConfigProcessor.RangeInt(min=0, max=255)
        @ConfigProcessor.Comment(value="Sealevel to set for Overworld (0 use default for World)")
        public static int worldSealevelOverride = 0;
        @ConfigProcessor.Option(value="Biomes Alias")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.Aliases")
        @ConfigProcessor.Comment(value="Biomes alias list")
        public static String[] biomeAliases = new String[0];
        @ConfigProcessor.Option(value="Dimension Blacklist")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.biomes.DimBlacklist")
        @ConfigProcessor.Comment(value="Dimension IDs where biome sounds will not be played")
        public static String[] dimensionBlacklist = new String[0];
    }

    @ConfigProcessor.Category(value="aurora")
    @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.cat.Aurora")
    @ConfigProcessor.Comment(value="Options that control Aurora behavior and rendering")
    public static class aurora {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enabled")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.EnableAurora")
        @ConfigProcessor.Comment(value="Enable/disable Aurora processing on server/client")
        public static boolean auroraEnable = true;
        @ConfigProcessor.Option(value="Use Shaders")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.aurora.EnableShader")
        @ConfigProcessor.Comment(value="Use shader when rendering aurora")
        @ConfigProcessor.RestartRequired(world=true)
        public static boolean auroraUseShader = true;
    }

    @ConfigProcessor.Category(value="general")
    @ConfigProcessor.LangKey(value="dsurround.cfg.general.cat.General")
    @ConfigProcessor.Comment(value="Miscellaneous settings")
    public static class general {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Hide Chat Notices")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.HideChat")
        @ConfigProcessor.Comment(value="Toggles display of Dynamic Surroundings chat notices")
        public static boolean hideChatNotices = false;
        @ConfigProcessor.Option(value="External Configuration Files")
        @ConfigProcessor.DefaultValue(value="")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.ExternalScripts")
        @ConfigProcessor.Comment(value="Configuration files for customization")
        public static String[] externalScriptFiles = new String[0];
        @ConfigProcessor.Option(value="Startup Sound List")
        @ConfigProcessor.DefaultValue(value="minecraft:entity.experience_orb.pickup,minecraft:entity.chicken.egg")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.StartupSounds")
        @ConfigProcessor.Comment(value="Possible sounds to play when client reaches main game menu")
        public static String[] startupSoundList = new String[]{"minecraft:entity.experience_orb.pickup", "minecraft:entity.chicken.egg"};
        @ConfigProcessor.Option(value="Enable Client Chunk Caching")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.Comment(value="Enable/disable client side chunk caching for performance")
        @ConfigProcessor.LangKey(value="dsurround.cfg.general.ChunkCaching")
        public static boolean enableClientChunkCaching = true;
    }

    @ConfigProcessor.Category(value="fog")
    @ConfigProcessor.LangKey(value="dsurround.cfg.fog.cat.Fog")
    @ConfigProcessor.Comment(value="Options that control the various fog effects in the client")
    public static class fog {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable Fog Processing")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.Enable")
        @ConfigProcessor.Comment(value="Enable/disable fog processing")
        public static boolean enableFogProcessing = true;
        @ConfigProcessor.Option(value="Morning Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableMorning")
        @ConfigProcessor.Comment(value="Show morning fog that eventually burns off")
        public static boolean enableMorningFog = true;
        @ConfigProcessor.Option(value="Weather Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableWeather")
        @ConfigProcessor.Comment(value="Increase fog based on the strength of rain")
        public static boolean enableWeatherFog = true;
        @ConfigProcessor.Option(value="Bedrock Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.EnableBedrock")
        @ConfigProcessor.Comment(value="Increase fog at bedrock layers")
        public static boolean enableBedrockFog = true;
        @ConfigProcessor.Option(value="Desert Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.DesertFog")
        @ConfigProcessor.Comment(value="Enable/disable desert fog when raining")
        public static boolean allowDesertFog = true;
        @ConfigProcessor.Option(value="Elevation Haze")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.ElevationHaze")
        @ConfigProcessor.Comment(value="Higher the player elevation the more haze that is experienced")
        public static boolean enableElevationHaze = true;
        @ConfigProcessor.Option(value="Biomes Fog")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.BiomeFog")
        @ConfigProcessor.Comment(value="Enable biome specific fog density and color")
        public static boolean enableBiomeFog = true;
        @ConfigProcessor.Option(value="Morning Fog Chance")
        @ConfigProcessor.DefaultValue(value="1")
        @ConfigProcessor.RangeInt(min=1, max=10)
        @ConfigProcessor.LangKey(value="dsurround.cfg.fog.MorningFogChance")
        @ConfigProcessor.Comment(value="Chance morning fog will occurs expressed as 1 in N")
        public static int morningFogChance = 1;
    }

    @ConfigProcessor.Category(value="rain")
    @ConfigProcessor.LangKey(value="dsurround.cfg.rain.cat.Rain")
    @ConfigProcessor.Comment(value="Options that control rain effects in the client")
    public static class rain {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Use Vanilla Algorithms")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.VanillaRain")
        @ConfigProcessor.Comment(value="Let Vanilla handle rain intensity and time windows")
        @ConfigProcessor.RestartRequired
        public static boolean doVanillaRain = false;
        @ConfigProcessor.Option(value="Use Vanilla Rain Sound")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.UseVanillaSound")
        @ConfigProcessor.Comment(value="Use the Vanilla rain sound rather than the modified one")
        @ConfigProcessor.RestartRequired(server=true, world=true)
        public static boolean useVanillaRainSound = false;
        @ConfigProcessor.Option(value="Style of rain water ripple")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.RippleStyle")
        @ConfigProcessor.RangeInt(min=0, max=3)
        @ConfigProcessor.Comment(value="0: original round, 1: darker round, 2: square, 3: pixelated")
        public static int rainRippleStyle = 3;
        @ConfigProcessor.Option(value="Enable Background Thunder")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.EnableThunder")
        @ConfigProcessor.Comment(value="Allow background thunder when storming")
        public static boolean allowBackgroundThunder = true;
        @ConfigProcessor.Option(value="Rain Intensity for Background Thunder")
        @ConfigProcessor.DefaultValue(value="0.75")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.ThunderThreshold")
        @ConfigProcessor.RangeFloat(min=0.0f)
        @ConfigProcessor.Comment(value="Minimum rain intensity level for background thunder to occur")
        public static float stormThunderThreshold = 0.75f;
        @ConfigProcessor.Option(value="Default Minimum Rain Strength")
        @ConfigProcessor.DefaultValue(value="0.0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.MinRainStrength")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Default minimum rain strength for a dimension")
        public static float defaultMinRainStrength = 0.0f;
        @ConfigProcessor.Option(value="Default Maximum Rain Strength")
        @ConfigProcessor.DefaultValue(value="1.0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.rain.MaxRainStrength")
        @ConfigProcessor.RangeFloat(min=0.0f, max=1.0f)
        @ConfigProcessor.Comment(value="Default maximum rain strength for a dimension")
        public static float defaultMaxRainStrength = 1.0f;
    }

    @ConfigProcessor.Category(value="logging")
    @ConfigProcessor.LangKey(value="dsurround.cfg.logging.cat.Logging")
    @ConfigProcessor.Comment(value="Defines how Dynamic Surroundings logging will behave")
    public static class logging {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable Debug Logging")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.EnableDebug")
        @ConfigProcessor.Comment(value="Enables/disables debug logging of the mod")
        @ConfigProcessor.RestartRequired
        public static boolean enableDebugLogging = false;
        @ConfigProcessor.Option(value="Enable Online Version Check")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.VersionCheck")
        @ConfigProcessor.Comment(value="Enables/disables display of version check information")
        @ConfigProcessor.RestartRequired
        public static boolean enableVersionChecking = true;
        @ConfigProcessor.Option(value="Report Server Stats")
        @ConfigProcessor.DefaultValue(value="false")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.ServerStats")
        @ConfigProcessor.Comment(value="Enables/disables reporting of server stats")
        public static boolean reportServerStats = false;
        @ConfigProcessor.Option(value="Debug Flag Mask")
        @ConfigProcessor.DefaultValue(value="0")
        @ConfigProcessor.LangKey(value="dsurround.cfg.logging.FlagMask")
        @ConfigProcessor.Comment(value="Bitmask for toggling various debug traces")
        @ConfigProcessor.Hidden
        public static int debugFlagMask = 0;
    }

    @ConfigProcessor.Category(value="asm")
    @ConfigProcessor.LangKey(value="dsurround.cfg.asm.cat.ASM")
    @ConfigProcessor.Comment(value="Controls ASM transforms Dynamic Surroundings performs at startup")
    @ConfigProcessor.RestartRequired(server=true, world=true)
    public static class asm {
        public static String PATH = null;
        @ConfigProcessor.Option(value="Enable Weather Control")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.EnableWeather")
        @ConfigProcessor.Comment(value="Enable ASM transformations to permit weather (rain, snow, splash, dust storms, auroras)")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean enableWeatherASM = true;
        @ConfigProcessor.Option(value="Disable Arrow Critical Particle Trail")
        @ConfigProcessor.DefaultValue(value="true")
        @ConfigProcessor.LangKey(value="dsurround.cfg.asm.DisableArrow")
        @ConfigProcessor.Comment(value="Disable particle trail left by an arrow when it flies")
        @ConfigProcessor.RestartRequired(server=true)
        public static boolean disableArrowParticleTrail = true;
    }

    public static class Trace {
        public static final int SOUND_PLAY = 1;
        public static final int FOOTSTEP_ACOUSTIC = 2;
    }
}

