/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import io.netty.buffer.ByteBuf;
import knightminer.ceramics.network.PacketBase;
import knightminer.ceramics.tileentity.TileBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BarrelSizeChangedPacket
extends PacketBase {
    public BlockPos pos;
    public int capacity;
    public int height;

    public BarrelSizeChangedPacket() {
    }

    public BarrelSizeChangedPacket(BlockPos pos, int capacity, int height) {
        this.pos = pos;
        this.capacity = capacity;
        this.height = height;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.capacity = buf.readInt();
        this.height = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeInt(this.capacity);
        buf.writeInt(this.height);
    }

    public static class BarrelCapacityChangedHandler
    implements IMessageHandler<BarrelSizeChangedPacket, IMessage> {
        public IMessage onMessage(final BarrelSizeChangedPacket message, MessageContext ctx) {
            PacketBase.getMainThread(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                    if (te instanceof TileBarrel) {
                        ((TileBarrel)te).updateSize(message.capacity, message.height);
                    }
                }
            });
            return null;
        }
    }
}

