/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;

public abstract class TileEntityTypeBaseWithRail
extends TileEntityTypeBase {
    private EnumHelper.EnumPlatform railType;
    private CraftHelper.MaterialId railTexture1;
    private CraftHelper.MaterialId railTexture2;
    protected ItemStack railResource1 = ItemStack.field_190927_a;
    protected ItemStack railResource2 = ItemStack.field_190927_a;

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        if (this.hasRail()) {
            nbtTag.func_74774_a("railType", (byte)(this.railType.MATERIAL.VALUE + this.railType.TYPE.VALUE));
            nbtTag.func_74778_a("railTexture1", this.getTexture(this.railTexture1));
            nbtTag.func_74778_a("railTexture2", this.getTexture(this.railTexture2));
        } else {
            nbtTag.func_74774_a("railType", (byte)-1);
        }
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        byte railType = nbtTag.func_74771_c("railType");
        if (railType == -1) {
            this.removeRail();
        } else {
            this.setRail(railType);
            this.setRailTextures(nbtTag.func_74779_i("railTexture1"), nbtTag.func_74779_i("railTexture2"));
        }
    }

    @Override
    public String[] getTextures() {
        return new String[]{this.getTexture(this.texture1), this.getTexture(this.texture2), this.getTexture(this.railTexture1), this.getTexture(this.railTexture2)};
    }

    @Override
    public int getTint(int index) {
        return index == 3 || index == 4 ? Platforms.proxy.getTint(index == 3 ? this.railResource1 : this.railResource2) : (index < 3 ? super.getTint(index) : -1);
    }

    public void setRailTextures(String mId1, String mId2) {
        this.railTexture1 = CraftHelper.MaterialId.getFor(mId1);
        this.railTexture2 = CraftHelper.MaterialId.getFor(mId2);
        this.railResource1 = this.railTexture1.toStack();
        this.railResource2 = this.railTexture2.toStack();
    }

    public boolean hasRail() {
        return this.railType != null;
    }

    public EnumHelper.EnumPlatform getRail() {
        return this.railType;
    }

    public boolean setRail(int railType) {
        return this.setRail(EnumHelper.getPlatform(railType, railType));
    }

    public boolean setRail(EnumHelper.EnumPlatform enumPlatform) {
        if (enumPlatform != null && (enumPlatform.TYPE == EnumHelper.EnumPlatformType.RAIL || enumPlatform.TYPE == EnumHelper.EnumPlatformType.RISE)) {
            this.railType = enumPlatform;
            return true;
        }
        return false;
    }

    public void removeRail() {
        this.railType = null;
        this.railTexture1 = null;
        this.railTexture2 = null;
        this.railResource1 = ItemStack.field_190927_a;
        this.railResource2 = ItemStack.field_190927_a;
    }
}

