/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.asm;

import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class Transmorgrifier {
    private final String className;

    public Transmorgrifier(@Nonnull String className) {
        this.className = className;
    }

    public int classWriterFlags() {
        return 1;
    }

    @Nonnull
    public abstract String name();

    @Nonnull
    public String getClassName() {
        return this.className;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean matches(@Nonnull String name) {
        return this.className.equals(name);
    }

    public abstract boolean transmorgrify(ClassNode var1);

    protected MethodNode findMethod(@Nonnull ClassNode cn, @Nonnull String[] signatures, @Nonnull String[] names) {
        for (MethodNode m : cn.methods) {
            if (!this.isOneOf(m.name, names) || !this.isOneOf(m.desc, signatures)) continue;
            return m;
        }
        return null;
    }

    protected boolean isOneOf(@Nonnull String s, String ... possibles) {
        for (String p : possibles) {
            if (!s.equals(p)) continue;
            return true;
        }
        return false;
    }

    protected void logMethod(@Nonnull Logger log, @Nonnull MethodNode node, @Nonnull String message) {
        String text = String.format("%s%s: %s", node.name, node.desc, message);
        log.info(text);
    }
}

