/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.asm;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.orecruncher.dsurround.asm.Transformer;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.TransformerExclusions(value={"org.orecruncher.dsurround.asm."})
@IFMLLoadingPlugin.SortingIndex(value=10001)
@IFMLLoadingPlugin.Name(value="DynamicSurroundingsCore")
public class TransformLoader
implements IFMLLoadingPlugin {
    public static final String MOD_ID = "dsurroundcore";
    public static final String MOD_NAME = "DynamicSurroundingsCore";
    public static final Logger logger = LogManager.getLogger((String)"dsurroundcore");
    public static boolean enableWeatherASM = true;
    public static boolean enableArrowPatch = true;

    public String getModContainerClass() {
        return "org.orecruncher.dsurround.asm.TransformLoader$Container";
    }

    public String[] getASMTransformerClass() {
        return new String[]{Transformer.class.getName()};
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> map) {
        File configFile = new File((File)map.get("mcLocation"), "/config/dsurround/dsurround.cfg");
        if (configFile.exists()) {
            Configuration config = new Configuration(configFile);
            enableArrowPatch = config.getBoolean("Disable Arrow Critical Particle Trail", "asm", true, "");
            enableWeatherASM = config.getBoolean("Enable Weather Control", "asm", true, "");
        }
    }

    public static class Container
    extends DummyModContainer {
        public Container() {
            super(new ModMetadata());
            ModMetadata meta = this.getMetadata();
            meta.modId = TransformLoader.MOD_ID;
            meta.name = TransformLoader.MOD_NAME;
            meta.authorList.add("OreCruncher");
            meta.version = "3.5.4.0";
            meta.description = "CoreMod for Dynamic Surroundings";
            meta.url = "https://github.com/OreCruncher/DynamicSurroundings/wiki";
        }

        public boolean registerBus(EventBus bus, LoadController controller) {
            bus.register((Object)this);
            return true;
        }
    }
}

