/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DebugHook;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.InputMap;
import de.matthiasmann.twl.KeyStroke;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.PositionAnimatedPanel;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.renderer.CacheContext;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.FontMapper;
import de.matthiasmann.twl.renderer.FontParameter;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.theme.HasBorder;
import de.matthiasmann.twl.theme.ImageManager;
import de.matthiasmann.twl.theme.ParameterListImpl;
import de.matthiasmann.twl.theme.ParameterMapImpl;
import de.matthiasmann.twl.theme.ParserUtil;
import de.matthiasmann.twl.theme.ThemeException;
import de.matthiasmann.twl.theme.ThemeInfoImpl;
import de.matthiasmann.twl.utils.AbstractMathInterpreter;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelect;
import de.matthiasmann.twl.utils.StringList;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twl.utils.XMLParser;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.lwjgl.opengl.Util;
import org.xmlpull.v1.XmlPullParserException;

public class ThemeManager {
    private static final HashMap<String, Class<? extends Enum<?>>> enums = new HashMap();
    static final Object NULL;
    final ParameterMapImpl constants = new ParameterMapImpl(this, null);
    private final Renderer renderer;
    private final CacheContext cacheContext;
    private final ImageManager imageManager;
    private final HashMap<String, Font> fonts;
    private final HashMap<String, ThemeInfoImpl> themes;
    private final HashMap<String, InputMap> inputMaps;
    private final MathInterpreter mathInterpreter;
    private Font defaultFont;
    private Font firstFont;
    final ParameterMapImpl emptyMap;
    final ParameterListImpl emptyList;

    private ThemeManager(Renderer renderer, CacheContext cacheContext) throws XmlPullParserException, IOException {
        this.renderer = renderer;
        this.cacheContext = cacheContext;
        this.imageManager = new ImageManager(this.constants, renderer);
        this.fonts = new HashMap();
        this.themes = new HashMap();
        this.inputMaps = new HashMap();
        this.emptyMap = new ParameterMapImpl(this, null);
        this.emptyList = new ParameterListImpl(this, null);
        this.mathInterpreter = new MathInterpreter();
    }

    public CacheContext getCacheContext() {
        return this.cacheContext;
    }

    public void destroy() {
        for (Font font : this.fonts.values()) {
            font.destroy();
        }
        this.cacheContext.destroy();
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public static ThemeManager createThemeManager(URL url, Renderer renderer) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        return ThemeManager.createThemeManager(url, renderer, renderer.createNewCacheContext());
    }

    public static ThemeManager createThemeManager(URL url, Renderer renderer, CacheContext cacheContext) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer is null");
        }
        if (cacheContext == null) {
            throw new IllegalArgumentException("cacheContext is null");
        }
        try {
            renderer.setActiveCacheContext(cacheContext);
            ThemeManager tm = new ThemeManager(renderer, cacheContext);
            tm.insertDefaultConstants();
            tm.parseThemeFile(url);
            if (tm.defaultFont == null) {
                tm.defaultFont = tm.firstFont;
            }
            return tm;
        }
        catch (XmlPullParserException ex) {
            throw (IOException)new IOException().initCause(ex);
        }
    }

    public static <E extends Enum<E>> void registerEnumType(String name, Class<E> enumClazz) {
        if (!enumClazz.isEnum()) {
            throw new IllegalArgumentException("not an enum class");
        }
        Class<? extends Enum<?>> curClazz = enums.get(name);
        if (curClazz != null && curClazz != enumClazz) {
            throw new IllegalArgumentException("Enum type name \"" + name + "\" is already in use by " + curClazz);
        }
        enums.put(name, enumClazz);
    }

    public ThemeInfo findThemeInfo(String themePath) {
        return this.findThemeInfo(themePath, true, true);
    }

    private ThemeInfo findThemeInfo(String themePath, boolean warn, boolean useFallback) {
        int start = TextUtil.indexOf(themePath, '.', 0);
        ThemeInfo info = this.themes.get(themePath.substring(0, start));
        if (info == null && (info = (ThemeInfo)this.themes.get("*")) != null) {
            if (!useFallback) {
                return null;
            }
            DebugHook.getDebugHook().usingFallbackTheme(themePath);
        }
        while (info != null && ++start < themePath.length()) {
            int next = TextUtil.indexOf(themePath, '.', start);
            info = info.getChildTheme(themePath.substring(start, next));
            start = next;
        }
        if (info == null && warn) {
            DebugHook.getDebugHook().missingTheme(themePath);
        }
        return info;
    }

    public Image getImageNoWarning(String name) {
        return this.imageManager.getImage(name);
    }

    public Image getImage(String name) {
        Image img = this.imageManager.getImage(name);
        if (img == null) {
            DebugHook.getDebugHook().missingImage(name);
        }
        return img;
    }

    public Object getCursor(String name) {
        return this.imageManager.getCursor(name);
    }

    public ParameterMap getConstants() {
        return this.constants;
    }

    private void insertDefaultConstants() {
        this.constants.put("SINGLE_COLUMN", -1);
        this.constants.put("MAX", (short)Short.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseThemeFile(URL url) throws IOException {
        try {
            XMLParser xmlp = new XMLParser(url);
            try {
                xmlp.setLoggerName(ThemeManager.class.getName());
                xmlp.require(0, null, null);
                xmlp.nextTag();
                this.parseThemeFile(xmlp, url);
            }
            finally {
                xmlp.close();
            }
        }
        catch (XmlPullParserException ex) {
            throw new ThemeException(ex.getMessage(), url, ex.getLineNumber(), ex.getColumnNumber(), ex);
        }
        catch (ThemeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (IOException)new IOException("while parsing Theme XML: " + url).initCause(ex);
        }
    }

    private void parseThemeFile(XMLParser xmlp, URL baseUrl) throws XmlPullParserException, IOException {
        xmlp.require(2, null, "themes");
        xmlp.nextTag();
        while (!xmlp.isEndTag()) {
            xmlp.require(2, null, null);
            String tagName = xmlp.getName();
            if ("images".equals(tagName) || "textures".equals(tagName)) {
                this.imageManager.parseImages(xmlp, baseUrl);
            } else if ("include".equals(tagName)) {
                String fontFileName = xmlp.getAttributeNotNull("filename");
                try {
                    this.parseThemeFile(new URL(baseUrl, fontFileName));
                }
                catch (ThemeException ex) {
                    ex.addIncludedBy(baseUrl, xmlp.getLineNumber(), xmlp.getColumnNumber());
                    throw ex;
                }
                xmlp.nextTag();
            } else {
                String name = xmlp.getAttributeNotNull("name");
                if ("theme".equals(tagName)) {
                    if (this.themes.containsKey(name)) {
                        throw xmlp.error("theme \"" + name + "\" already defined");
                    }
                    this.themes.put(name, this.parseTheme(xmlp, name, null, baseUrl));
                } else if ("inputMapDef".equals(tagName)) {
                    if (this.inputMaps.containsKey(name)) {
                        throw xmlp.error("inputMap \"" + name + "\" already defined");
                    }
                    this.inputMaps.put(name, this.parseInputMap(xmlp, name, null));
                } else if ("fontDef".equals(tagName)) {
                    if (this.fonts.containsKey(name)) {
                        throw xmlp.error("font \"" + name + "\" already defined");
                    }
                    boolean makeDefault = xmlp.parseBoolFromAttribute("default", false);
                    Font font = this.parseFont(xmlp, baseUrl);
                    this.fonts.put(name, font);
                    if (this.firstFont == null) {
                        this.firstFont = font;
                    }
                    if (makeDefault) {
                        if (this.defaultFont != null) {
                            throw xmlp.error("default font already set");
                        }
                        this.defaultFont = font;
                    }
                } else if ("constantDef".equals(tagName)) {
                    this.parseParam(xmlp, baseUrl, "constantDef", null, this.constants);
                } else {
                    throw xmlp.unexpected();
                }
            }
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
        }
        xmlp.require(3, null, "themes");
    }

    private InputMap getInputMap(XMLParser xmlp, String name) throws XmlPullParserException {
        InputMap im = this.inputMaps.get(name);
        if (im == null) {
            throw xmlp.error("Undefined input map: " + name);
        }
        return im;
    }

    private InputMap parseInputMap(XMLParser xmlp, String name, ThemeInfoImpl parent) throws XmlPullParserException, IOException {
        String baseName;
        InputMap base = InputMap.empty();
        if (xmlp.parseBoolFromAttribute("merge", false)) {
            if (parent == null) {
                throw xmlp.error("Can't merge on top level");
            }
            Object o = parent.getParam(name);
            if (o instanceof InputMap) {
                base = (InputMap)o;
            } else if (o != null) {
                throw xmlp.error("Can only merge with inputMap - found a " + o.getClass().getSimpleName());
            }
        }
        if ((baseName = xmlp.getAttributeValue(null, "ref")) != null) {
            base = base.addKeyStrokes(this.getInputMap(xmlp, baseName));
        }
        xmlp.nextTag();
        LinkedHashSet<KeyStroke> keyStrokes = InputMap.parseBody(xmlp);
        InputMap im = base.addKeyStrokes(keyStrokes);
        return im;
    }

    private Font parseFont(XMLParser xmlp, URL baseUrl) throws XmlPullParserException, IOException {
        Font font;
        FontMapper fontMapper;
        URL url = baseUrl;
        String fileName = xmlp.getAttributeValue(null, "filename");
        if (fileName != null) {
            url = new URL(url, fileName);
        }
        StringList fontFamilies = ThemeManager.parseList(xmlp, "families");
        int fontSize = 0;
        int fontStyle = 0;
        if (fontFamilies != null) {
            fontSize = xmlp.parseIntFromAttribute("size");
            for (StringList style = ThemeManager.parseList(xmlp, "style"); style != null; style = style.getNext()) {
                if ("bold".equalsIgnoreCase(style.getValue())) {
                    fontStyle |= 1;
                    continue;
                }
                if (!"italic".equalsIgnoreCase(style.getValue())) continue;
                fontStyle |= 2;
            }
        }
        FontParameter baseParams = new FontParameter();
        this.parseFontParameter(xmlp, baseParams);
        ArrayList<FontParameter> fontParams = new ArrayList<FontParameter>();
        ArrayList<StateExpression> stateExpr = new ArrayList<StateExpression>();
        xmlp.nextTag();
        while (!xmlp.isEndTag()) {
            xmlp.require(2, null, "fontParam");
            StateExpression cond = ParserUtil.parseCondition(xmlp);
            if (cond == null) {
                throw xmlp.error("Condition required");
            }
            stateExpr.add(cond);
            FontParameter params = new FontParameter(baseParams);
            this.parseFontParameter(xmlp, params);
            fontParams.add(params);
            xmlp.nextTag();
            xmlp.require(3, null, "fontParam");
            xmlp.nextTag();
        }
        fontParams.add(baseParams);
        StateSelect stateSelect = new StateSelect(stateExpr);
        FontParameter[] stateParams = fontParams.toArray(new FontParameter[fontParams.size()]);
        Util.checkGLError();
        if (fontFamilies != null && (fontMapper = this.renderer.getFontMapper()) != null && (font = fontMapper.getFont(fontFamilies, fontSize, fontStyle, stateSelect, stateParams)) != null) {
            return font;
        }
        Util.checkGLError();
        return this.renderer.loadFont(url, stateSelect, stateParams);
    }

    private void parseFontParameter(XMLParser xmlp, FontParameter fp) throws XmlPullParserException {
        int n = xmlp.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name;
            FontParameter.Parameter<?> type;
            if (!xmlp.isAttributeUnused(i) || (type = FontParameter.getParameter(name = xmlp.getAttributeName(i))) == null) continue;
            String value = xmlp.getAttributeValue(i);
            Class<?> dataClass = type.getDataClass();
            if (dataClass == Color.class) {
                FontParameter.Parameter<?> colorType = type;
                fp.put(colorType, ParserUtil.parseColor(xmlp, value, this.constants));
                continue;
            }
            if (dataClass == Integer.class) {
                FontParameter.Parameter<?> intType = type;
                fp.put(intType, this.parseMath(xmlp, value).intValue());
                continue;
            }
            if (dataClass == Boolean.class) {
                FontParameter.Parameter<?> boolType = type;
                fp.put(boolType, xmlp.parseBool(value));
                continue;
            }
            if (dataClass == String.class) {
                FontParameter.Parameter<?> strType = type;
                fp.put(strType, value);
                continue;
            }
            throw xmlp.error("dataClass not yet implemented: " + dataClass);
        }
    }

    private static StringList parseList(XMLParser xmlp, String name) {
        String value = xmlp.getAttributeValue(null, name);
        if (value != null) {
            return ThemeManager.parseList(value, 0);
        }
        return null;
    }

    private static StringList parseList(String value, int idx) {
        if ((idx = TextUtil.skipSpaces(value, idx)) >= value.length()) {
            return null;
        }
        int end = TextUtil.indexOf(value, ',', idx);
        String part = TextUtil.trim(value, idx, end);
        return new StringList(part, ThemeManager.parseList(value, end + 1));
    }

    private void parseThemeWildcardRef(XMLParser xmlp, ThemeInfoImpl parent) throws IOException, XmlPullParserException {
        String ref = xmlp.getAttributeValue(null, "ref");
        if (parent == null) {
            throw xmlp.error("Can't declare wildcard themes on top level");
        }
        if (ref == null) {
            throw xmlp.error("Reference required for wildcard theme");
        }
        if (!ref.endsWith("*")) {
            throw xmlp.error("Wildcard reference must end with '*'");
        }
        String refPath = ref.substring(0, ref.length() - 1);
        if (refPath.length() > 0 && !refPath.endsWith(".")) {
            throw xmlp.error("Wildcard must end with \".*\" or be \"*\"");
        }
        parent.wildcardImportPath = refPath;
        xmlp.nextTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThemeInfoImpl parseTheme(XMLParser xmlp, String themeName, ThemeInfoImpl parent, URL baseUrl) throws IOException, XmlPullParserException {
        if (!themeName.equals("*") || parent != null) {
            ParserUtil.checkNameNotEmpty(themeName, xmlp);
            if (themeName.indexOf(46) >= 0) {
                throw xmlp.error("'.' is not allowed in names");
            }
        }
        ThemeInfoImpl ti = new ThemeInfoImpl(this, themeName, parent);
        ThemeInfoImpl oldEnv = this.mathInterpreter.setEnv(ti);
        try {
            String ref;
            if (xmlp.parseBoolFromAttribute("merge", false)) {
                if (parent == null) {
                    throw xmlp.error("Can't merge on top level");
                }
                ThemeInfoImpl tiPrev = parent.getTheme(themeName);
                if (tiPrev != null) {
                    ti.copy(tiPrev);
                }
            }
            if ((ref = xmlp.getAttributeValue(null, "ref")) != null) {
                ThemeInfoImpl tiRef = null;
                if (parent != null) {
                    tiRef = parent.getTheme(ref);
                }
                if (tiRef == null) {
                    tiRef = (ThemeInfoImpl)this.findThemeInfo(ref);
                }
                if (tiRef == null) {
                    throw xmlp.error("referenced theme info not found: " + ref);
                }
                ti.copy(tiRef);
            }
            ti.maybeUsedFromWildcard = xmlp.parseBoolFromAttribute("allowWildcard", true);
            xmlp.nextTag();
            while (!xmlp.isEndTag()) {
                xmlp.require(2, null, null);
                String tagName = xmlp.getName();
                String name = xmlp.getAttributeNotNull("name");
                if ("param".equals(tagName)) {
                    this.parseParam(xmlp, baseUrl, "param", ti, ti);
                } else if ("theme".equals(tagName)) {
                    if (name.length() == 0) {
                        this.parseThemeWildcardRef(xmlp, ti);
                    } else {
                        ThemeInfoImpl tiChild = this.parseTheme(xmlp, name, ti, baseUrl);
                        ti.putTheme(name, tiChild);
                    }
                } else {
                    throw xmlp.unexpected();
                }
                xmlp.require(3, null, tagName);
                xmlp.nextTag();
            }
        }
        finally {
            this.mathInterpreter.setEnv(oldEnv);
        }
        return ti;
    }

    private void parseParam(XMLParser xmlp, URL baseUrl, String tagName, ThemeInfoImpl parent, ParameterMapImpl target) throws XmlPullParserException, IOException {
        try {
            xmlp.require(2, null, tagName);
            String name = xmlp.getAttributeNotNull("name");
            xmlp.nextTag();
            String valueTagName = xmlp.getName();
            Object value = this.parseValue(xmlp, valueTagName, name, baseUrl, parent);
            xmlp.require(3, null, valueTagName);
            xmlp.nextTag();
            xmlp.require(3, null, tagName);
            if (value instanceof Map) {
                Map map = (Map)value;
                if (parent == null && map.size() != 1) {
                    throw xmlp.error("constant definitions must define exactly 1 value");
                }
                target.put(map);
            } else {
                ParserUtil.checkNameNotEmpty(name, xmlp);
                target.put(name, value);
            }
        }
        catch (NumberFormatException ex) {
            throw xmlp.error("unable to parse value", ex);
        }
    }

    private ParameterListImpl parseList(XMLParser xmlp, URL baseUrl, ThemeInfoImpl parent) throws XmlPullParserException, IOException {
        ParameterListImpl result = new ParameterListImpl(this, parent);
        xmlp.nextTag();
        while (xmlp.isStartTag()) {
            String tagName = xmlp.getName();
            Object obj = this.parseValue(xmlp, tagName, null, baseUrl, parent);
            xmlp.require(3, null, tagName);
            result.params.add(obj);
            xmlp.nextTag();
        }
        return result;
    }

    private ParameterMapImpl parseMap(XMLParser xmlp, URL baseUrl, String name, ThemeInfoImpl parent) throws XmlPullParserException, IOException, NumberFormatException {
        String ref;
        ParameterMapImpl result = new ParameterMapImpl(this, parent);
        if (xmlp.parseBoolFromAttribute("merge", false)) {
            if (parent == null) {
                throw xmlp.error("Can't merge on top level");
            }
            Object obj = parent.getParam(name);
            if (obj instanceof ParameterMapImpl) {
                ParameterMapImpl base = (ParameterMapImpl)obj;
                result.copy(base);
            } else if (obj != null) {
                throw xmlp.error("Can only merge with map - found a " + obj.getClass().getSimpleName());
            }
        }
        if ((ref = xmlp.getAttributeValue(null, "ref")) != null) {
            Object obj = parent.getParam(ref);
            if (obj == null && (obj = this.constants.getParam(ref)) == null) {
                throw new IOException("Referenced map not found: " + ref);
            }
            if (obj instanceof ParameterMapImpl) {
                ParameterMapImpl base = (ParameterMapImpl)obj;
                result.copy(base);
            } else {
                throw new IOException("Expected a map got a " + obj.getClass().getSimpleName());
            }
        }
        xmlp.nextTag();
        while (xmlp.isStartTag()) {
            String tagName = xmlp.getName();
            this.parseParam(xmlp, baseUrl, "param", parent, result);
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
        }
        return result;
    }

    private Object parseValue(XMLParser xmlp, String tagName, String wildcardName, URL baseUrl, ThemeInfoImpl parent) throws XmlPullParserException, IOException, NumberFormatException {
        try {
            if ("list".equals(tagName)) {
                return this.parseList(xmlp, baseUrl, parent);
            }
            if ("map".equals(tagName)) {
                return this.parseMap(xmlp, baseUrl, wildcardName, parent);
            }
            if ("inputMapDef".equals(tagName)) {
                return this.parseInputMap(xmlp, wildcardName, parent);
            }
            if ("fontDef".equals(tagName)) {
                return this.parseFont(xmlp, baseUrl);
            }
            if ("enum".equals(tagName)) {
                String enumType = xmlp.getAttributeNotNull("type");
                Class<? extends Enum<?>> enumClazz = enums.get(enumType);
                if (enumClazz == null) {
                    throw xmlp.error("enum type \"" + enumType + "\" not registered");
                }
                return xmlp.parseEnumFromText(enumClazz);
            }
            if ("bool".equals(tagName)) {
                return xmlp.parseBoolFromText();
            }
            String value = xmlp.nextText();
            if ("color".equals(tagName)) {
                return ParserUtil.parseColor(xmlp, value, this.constants);
            }
            if ("float".equals(tagName)) {
                return Float.valueOf(this.parseMath(xmlp, value).floatValue());
            }
            if ("int".equals(tagName)) {
                return this.parseMath(xmlp, value).intValue();
            }
            if ("string".equals(tagName)) {
                return value;
            }
            if ("font".equals(tagName)) {
                Font font = this.fonts.get(value);
                if (font == null) {
                    throw xmlp.error("Font \"" + value + "\" not found");
                }
                return font;
            }
            if ("border".equals(tagName)) {
                return this.parseObject(xmlp, value, Border.class);
            }
            if ("dimension".equals(tagName)) {
                return this.parseObject(xmlp, value, Dimension.class);
            }
            if ("gap".equals(tagName) || "size".equals(tagName)) {
                return this.parseObject(xmlp, value, DialogLayout.Gap.class);
            }
            if ("constant".equals(tagName)) {
                Object result = this.constants.getParam(value);
                if (result == null) {
                    throw xmlp.error("Unknown constant: " + value);
                }
                if (result == NULL) {
                    result = null;
                }
                return result;
            }
            if ("image".equals(tagName)) {
                if (value.endsWith(".*")) {
                    if (wildcardName == null) {
                        throw new IllegalArgumentException("Wildcard's not allowed");
                    }
                    return this.imageManager.getImages(value, wildcardName);
                }
                return this.imageManager.getReferencedImage(xmlp, value);
            }
            if ("cursor".equals(tagName)) {
                if (value.endsWith(".*")) {
                    if (wildcardName == null) {
                        throw new IllegalArgumentException("Wildcard's not allowed");
                    }
                    return this.imageManager.getCursors(value, wildcardName);
                }
                return this.imageManager.getReferencedCursor(xmlp, value);
            }
            if ("inputMap".equals(tagName)) {
                return this.getInputMap(xmlp, value);
            }
            throw xmlp.error("Unknown type \"" + tagName + "\" specified");
        }
        catch (NumberFormatException ex) {
            throw xmlp.error("unable to parse value", ex);
        }
    }

    private Number parseMath(XMLParser xmlp, String str) throws XmlPullParserException {
        try {
            return this.mathInterpreter.execute(str);
        }
        catch (ParseException ex) {
            throw xmlp.error("unable to evaluate", this.unwrap(ex));
        }
    }

    private <T> T parseObject(XMLParser xmlp, String str, Class<T> type) throws XmlPullParserException {
        try {
            return this.mathInterpreter.executeCreateObject(str, type);
        }
        catch (ParseException ex) {
            throw xmlp.error("unable to evaluate", this.unwrap(ex));
        }
    }

    private Throwable unwrap(ParseException ex) {
        if (ex.getCause() != null) {
            return ex.getCause();
        }
        return ex;
    }

    ThemeInfo resolveWildcard(String base, String name, boolean useFallback) {
        assert (base.length() == 0 || base.endsWith("."));
        String fullPath = base.concat(name);
        ThemeInfo info = this.findThemeInfo(fullPath, false, useFallback);
        if (info != null && ((ThemeInfoImpl)info).maybeUsedFromWildcard) {
            return info;
        }
        return null;
    }

    static {
        ThemeManager.registerEnumType("alignment", Alignment.class);
        ThemeManager.registerEnumType("direction", PositionAnimatedPanel.Direction.class);
        NULL = new Object();
    }

    class MathInterpreter
    extends AbstractMathInterpreter {
        private ThemeInfoImpl env;

        MathInterpreter() {
        }

        public ThemeInfoImpl setEnv(ThemeInfoImpl env) {
            ThemeInfoImpl oldEnv = this.env;
            this.env = env;
            return oldEnv;
        }

        @Override
        public void accessVariable(String name) {
            ThemeInfoImpl e = this.env;
            while (e != null) {
                Object obj = e.getParam(name);
                if (obj != null) {
                    this.push(obj);
                    return;
                }
                obj = e.getChildThemeImpl(name, false);
                if (obj != null) {
                    this.push(obj);
                    return;
                }
                e = e.parent;
            }
            Object obj = ThemeManager.this.constants.getParam(name);
            if (obj != null) {
                this.push(obj);
                return;
            }
            Font font = (Font)ThemeManager.this.fonts.get(name);
            if (font != null) {
                this.push(font);
                return;
            }
            throw new IllegalArgumentException("variable not found: " + name);
        }

        @Override
        protected Object accessField(Object obj, String field) {
            Object result;
            if (obj instanceof ThemeInfoImpl && (result = ((ThemeInfoImpl)obj).getTheme(field)) != null) {
                return result;
            }
            if (obj instanceof ParameterMapImpl) {
                result = ((ParameterMapImpl)obj).getParam(field);
                if (result == null) {
                    throw new IllegalArgumentException("field not found: " + field);
                }
                return result;
            }
            if (obj instanceof Image && "border".equals(field)) {
                Border border = null;
                if (obj instanceof HasBorder) {
                    border = ((HasBorder)obj).getBorder();
                }
                return border != null ? border : Border.ZERO;
            }
            return super.accessField(obj, field);
        }
    }
}

