/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer;

import java.util.ArrayList;
import java.util.HashMap;

public interface AnimationState {
    public int getAnimationTime(StateKey var1);

    public boolean getAnimationState(StateKey var1);

    public boolean getShouldAnimateState(StateKey var1);

    public static final class StateKey {
        private final String name;
        private final int id;
        private static final HashMap<String, StateKey> keys = new HashMap();
        private static final ArrayList<StateKey> keysByID = new ArrayList();

        private StateKey(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StateKey) {
                StateKey other = (StateKey)obj;
                return this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public static synchronized StateKey get(String name) {
            if (name.length() == 0) {
                throw new IllegalArgumentException("name");
            }
            StateKey key = keys.get(name);
            if (key == null) {
                key = new StateKey(name, keys.size());
                keys.put(name, key);
                keysByID.add(key);
            }
            return key;
        }

        public static synchronized StateKey get(int id) {
            return keysByID.get(id);
        }

        public static synchronized int getNumStateKeys() {
            return keys.size();
        }
    }
}

