/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractTableSelectionModel;

public class TableSingleSelectionModel
extends AbstractTableSelectionModel {
    public static final int NO_SELECTION = -1;
    private int selection;

    @Override
    public void rowsInserted(int index, int count) {
        boolean changed = false;
        if (this.selection >= index) {
            this.selection += count;
            changed = true;
        }
        super.rowsInserted(index, count);
        if (changed) {
            this.fireSelectionChange();
        }
    }

    @Override
    public void rowsDeleted(int index, int count) {
        boolean changed = false;
        if (this.selection >= index) {
            this.selection = this.selection < index + count ? -1 : (this.selection -= count);
            changed = true;
        }
        super.rowsDeleted(index, count);
        if (changed) {
            this.fireSelectionChange();
        }
    }

    @Override
    public void clearSelection() {
        if (this.hasSelection()) {
            this.selection = -1;
            this.fireSelectionChange();
        }
    }

    @Override
    public void setSelection(int index0, int index1) {
        this.updateLeadAndAnchor(index0, index1);
        this.selection = index1;
        this.fireSelectionChange();
    }

    @Override
    public void addSelection(int index0, int index1) {
        this.updateLeadAndAnchor(index0, index1);
        this.selection = index1;
        this.fireSelectionChange();
    }

    @Override
    public void invertSelection(int index0, int index1) {
        this.updateLeadAndAnchor(index0, index1);
        this.selection = this.selection == index1 ? -1 : index1;
        this.fireSelectionChange();
    }

    @Override
    public void removeSelection(int index0, int index1) {
        this.updateLeadAndAnchor(index0, index1);
        if (this.hasSelection()) {
            int first = Math.min(index0, index1);
            int last = Math.max(index0, index1);
            if (this.selection >= first && this.selection <= last) {
                this.selection = -1;
            }
            this.fireSelectionChange();
        }
    }

    @Override
    public boolean isSelected(int index) {
        return this.selection == index;
    }

    @Override
    public boolean hasSelection() {
        return this.selection >= 0;
    }

    @Override
    public int getFirstSelected() {
        return this.selection;
    }

    @Override
    public int getLastSelected() {
        return this.selection;
    }

    @Override
    public int[] getSelection() {
        if (this.selection >= 0) {
            return new int[]{this.selection};
        }
        return new int[0];
    }
}

