/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.IEnvironmentClass;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolLocal;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentMethod
implements IEnvironmentMethod {
    private final MethodOutput output;
    private final HashMap<SymbolLocal, Integer> locals;
    private final IEnvironmentClass environment;
    private final Map<String, IZenSymbol> local;

    public EnvironmentMethod(MethodOutput output, IEnvironmentClass environment) {
        this.output = output;
        this.locals = new HashMap();
        this.environment = environment;
        this.local = new HashMap<String, IZenSymbol>();
    }

    @Override
    public MethodOutput getOutput() {
        return this.output;
    }

    @Override
    public ClassVisitor getClassOutput() {
        return this.environment.getClassOutput();
    }

    @Override
    public int getLocal(SymbolLocal variable) {
        if (!this.locals.containsKey(variable)) {
            this.locals.put(variable, this.output.local(variable.getType().toASMType()));
        }
        return this.locals.get(variable);
    }

    @Override
    public ZenType getType(Type type) {
        return this.environment.getType(type);
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.environment.error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.environment.warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.environment.info(position, message);
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.environment.getEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return this.environment.getExpansion(name);
    }

    @Override
    public String makeClassName() {
        return this.environment.makeClassName();
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.environment.putClass(name, data);
    }

    @Override
    public boolean containsClass(String name) {
        return this.environment.containsClass(name);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.local.containsKey(name)) {
            return this.local.get(name).instance(position);
        }
        return this.environment.getValue(name, position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.local.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.local.put(name, value);
        }
    }

    @Override
    public Set<String> getClassNames() {
        return this.environment.getClassNames();
    }

    @Override
    public byte[] getClass(String name) {
        return this.environment.getClass(name);
    }

    @Override
    public void error(String message) {
        this.environment.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.environment.error(message, e);
    }

    @Override
    public void warning(String message) {
        this.environment.warning(message);
    }

    @Override
    public void info(String message) {
        this.environment.info(message);
    }
}

