/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorldProvider;
import crafttweaker.mc1120.world.MCBiome;
import crafttweaker.mc1120.world.MCBlockPos;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public class MCWorldProvider
implements IWorldProvider {
    private final WorldProvider provider;

    public MCWorldProvider(int id) {
        this.provider = DimensionManager.getProvider((int)id);
    }

    public MCWorldProvider(WorldProvider provider) {
        this.provider = provider;
    }

    @Override
    public int getActualHeight() {
        return this.provider.getActualHeight();
    }

    @Override
    public int getAverageGroundLevel() {
        return this.provider.func_76557_i();
    }

    @Override
    public IBiome getBiomeForCoords(IBlockPos pos) {
        return new MCBiome(this.provider.getBiomeForCoords((BlockPos)pos.getInternal()));
    }

    @Override
    public float getCloudHeight() {
        return this.provider.func_76571_f();
    }

    @Override
    public float getCurrentMoonPhaseFactor() {
        return this.provider.getCurrentMoonPhaseFactor();
    }

    @Override
    public int getDimensionID() {
        return this.provider.getDimension();
    }

    @Override
    public int getHeight() {
        return this.provider.getHeight();
    }

    @Override
    public double getHorizon() {
        return this.provider.getHorizon();
    }

    @Override
    public float[] getLightBrightnesTable() {
        return this.provider.func_177497_p();
    }

    @Override
    public int getMoonPhase(long time) {
        return this.provider.func_76559_b(time);
    }

    @Override
    public double getMovementFactor() {
        return this.provider.getMovementFactor();
    }

    @Override
    public IBlockPos getRandomizedSpawnPoint() {
        return new MCBlockPos(this.provider.getRandomizedSpawnPoint());
    }

    @Override
    public IWorldProvider getRespawnDimension(IPlayer player) {
        if (!(player.getInternal() instanceof EntityPlayerMP)) {
            return null;
        }
        return new MCWorldProvider(this.provider.getRespawnDimension((EntityPlayerMP)player.getInternal()));
    }

    @Override
    public String getSaveFolder() {
        return this.provider.getSaveFolder();
    }

    @Override
    public long getSeed() {
        return this.provider.getSeed();
    }

    @Override
    public IBlockPos getSpawnCoordinate() {
        return new MCBlockPos(this.provider.func_177496_h());
    }

    @Override
    public IBlockPos getSpawnPoint() {
        return new MCBlockPos(this.provider.getSpawnPoint());
    }

    @Override
    public float getStarBrightness(float something) {
        return this.provider.getStarBrightness(something);
    }

    @Override
    public float getSunBrightness(float something) {
        return this.provider.getSunBrightness(something);
    }

    @Override
    public float getSunBrightnessFactor(float something) {
        return this.provider.getSunBrightnessFactor(something);
    }

    @Override
    public double getVoidFogYFactor() {
        return this.provider.func_76565_k();
    }

    @Override
    public long getWorldTime() {
        return this.provider.getWorldTime();
    }

    @Override
    public boolean canRespawnHere() {
        return this.provider.func_76567_e();
    }

    @Override
    public boolean doesWaterVaporize() {
        return this.provider.func_177500_n();
    }

    @Override
    public boolean hasSkyLight() {
        return this.provider.func_191066_m();
    }

    @Override
    public boolean isBlockHighHumidity(IBlockPos pos) {
        return this.provider.isBlockHighHumidity((BlockPos)pos.getInternal());
    }

    @Override
    public boolean isDaytime() {
        return this.provider.isDaytime();
    }

    @Override
    public boolean isNether() {
        return this.provider.func_177495_o();
    }

    @Override
    public boolean isSkyColored() {
        return this.provider.func_76561_g();
    }

    @Override
    public boolean isSurfaceWorld() {
        return this.provider.func_76569_d();
    }
}

