/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.liquid;

import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.liquid.MCLiquidDefinition;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MCLiquidStack
implements ILiquidStack {
    private final FluidStack stack;
    private IData tag = null;

    public MCLiquidStack(FluidStack stack) {
        this.stack = stack;
    }

    private MCLiquidStack(FluidStack stack, IData tag) {
        this.stack = stack;
        this.tag = tag;
    }

    @Override
    public ILiquidDefinition getDefinition() {
        return new MCLiquidDefinition(this.stack.getFluid());
    }

    @Override
    public String getName() {
        return this.stack.getFluid().getName();
    }

    @Override
    public String getDisplayName() {
        return this.stack.getFluid().getLocalizedName(this.stack);
    }

    @Override
    public int getAmount() {
        return this.stack.amount;
    }

    @Override
    public IData getTag() {
        if (this.tag == null) {
            if (this.stack.tag == null) {
                return null;
            }
            this.tag = NBTConverter.from((NBTBase)this.stack.tag, true);
        }
        return this.tag;
    }

    @Override
    public ILiquidStack withTag(IData data) {
        FluidStack result = new FluidStack(this.stack.getFluid(), this.stack.amount);
        result.tag = (NBTTagCompound)NBTConverter.from(data);
        return new MCLiquidStack(result, data.immutable());
    }

    @Override
    public ILiquidStack withAmount(int amount) {
        FluidStack result = new FluidStack(this.stack.getFluid(), amount);
        result.tag = this.stack.tag;
        return new MCLiquidStack(result, this.tag);
    }

    @Override
    public int getLuminosity() {
        return this.stack.getFluid().getLuminosity(this.stack);
    }

    @Override
    public int getDensity() {
        return this.stack.getFluid().getDensity(this.stack);
    }

    @Override
    public int getTemperature() {
        return this.stack.getFluid().getTemperature(this.stack);
    }

    @Override
    public int getViscosity() {
        return this.stack.getFluid().getViscosity(this.stack);
    }

    @Override
    public boolean isGaseous() {
        return this.stack.getFluid().isGaseous(this.stack);
    }

    @Override
    public Object getInternal() {
        return this.stack;
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public List<IItemStack> getItems() {
        return Collections.emptyList();
    }

    @Override
    public IItemStack[] getItemArray() {
        return new IItemStack[0];
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.singletonList(this);
    }

    @Override
    public IIngredient amount(int amount) {
        return this.withAmount(amount);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        throw new UnsupportedOperationException("Liquid stack can't have transformers");
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        throw new UnsupportedOperationException("Liquid stack can't have conditions");
    }

    @Override
    public IIngredient marked(String mark) {
        throw new UnsupportedOperationException("Liquid stack can't be marked");
    }

    @Override
    public boolean matches(IItemStack item) {
        return false;
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return false;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return this.getDefinition().equals(liquid.getDefinition()) && this.getAmount() <= liquid.getAmount();
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        if (!ingredient.getItems().isEmpty()) {
            return false;
        }
        for (ILiquidStack liquid : ingredient.getLiquids()) {
            if (this.matches(liquid)) continue;
            return false;
        }
        return false;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return item;
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        return item;
    }

    @Override
    public boolean hasNewTransformers() {
        return false;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        throw new UnsupportedOperationException("Liquid stack can't have transformers");
    }

    public String toString() {
        return "<liquid:" + this.getName() + ">";
    }

    @Override
    public String toCommandString() {
        return this.toString();
    }
}

