/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events.handling;

import crafttweaker.api.event.BlockHarvestDropsEvent;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.events.handling.MCBlockEvent;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.BlockEvent;

public class MCBlockHarvestDropsEvent
extends MCBlockEvent
implements BlockHarvestDropsEvent {
    private final BlockEvent.HarvestDropsEvent event;

    public MCBlockHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        super((BlockEvent)event);
        this.event = event;
    }

    @Override
    public float getDropChance() {
        return this.event.getDropChance();
    }

    @Override
    public void setDropChance(float dropChance) {
        this.event.setDropChance(dropChance);
    }

    @Override
    public int getFortuneLevel() {
        return this.event.getFortuneLevel();
    }

    @Override
    public List<WeightedItemStack> getDrops() {
        return CraftTweakerMC.getWeightedItemStackList(this.event.getDrops());
    }

    @Override
    public void setDrops(List<WeightedItemStack> drops) {
        this.event.getDrops().clear();
        for (WeightedItemStack drop : drops) {
            this.addItem(drop);
        }
    }

    @Override
    public void addItem(WeightedItemStack itemStack) {
        if (this.event.getWorld().field_73012_v.nextFloat() <= itemStack.getChance()) {
            this.event.getDrops().add(CraftTweakerMC.getItemStack(itemStack.getStack()));
        }
    }

    @Override
    public boolean isSilkTouch() {
        return this.event.isSilkTouching();
    }

    @Override
    public boolean isPlayer() {
        return this.event.getHarvester() instanceof EntityPlayerMP || this.event.getHarvester() instanceof EntityPlayerSP;
    }

    @Override
    public IPlayer getPlayer() {
        return CraftTweakerMC.getIPlayer(this.event.getHarvester());
    }
}

