/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.CraftTweakerAPI;

public class NBTUtils {
    public static String getAppealingString(String string) {
        CraftTweakerAPI.logInfo("Compact NBT:");
        CraftTweakerAPI.logInfo(string);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilderNonColor = new StringBuilder();
        int currentIndent = 0;
        boolean inQuotes = false;
        boolean isInValue = false;
        stringBuilder.append("\u00a7e\u00e2\u201d\u0153");
        stringBuilderNonColor.append("\n\u00e2\u201d\u0153");
        block7: for (int i = 0; i < string.length(); ++i) {
            char[] cArray = new char[1];
            string.getChars(i, i + 1, cArray, 0);
            char c = cArray[0];
            switch (c) {
                case '\"': {
                    inQuotes = !inQuotes;
                    stringBuilder.append("\u00a73\"");
                    stringBuilderNonColor.append(c);
                    continue block7;
                }
                case '[': 
                case '{': {
                    if (!inQuotes) {
                        isInValue = false;
                        stringBuilder.append("\u00a72").append(c);
                        NBTUtils.addNewLine(stringBuilder, ++currentIndent);
                        stringBuilderNonColor.append(c);
                        NBTUtils.addNewLineNoColor(stringBuilderNonColor, currentIndent);
                        continue block7;
                    }
                    stringBuilder.append("\u00a7b").append(c);
                    stringBuilderNonColor.append(c);
                    continue block7;
                }
                case ']': 
                case '}': {
                    if (!inQuotes) {
                        isInValue = false;
                        NBTUtils.addNewLine(stringBuilder, --currentIndent);
                        stringBuilder.append("\u00a72").append(c);
                        NBTUtils.addNewLineNoColor(stringBuilderNonColor, currentIndent);
                        stringBuilderNonColor.append(c);
                        continue block7;
                    }
                    stringBuilder.append("\u00a7b").append(c);
                    stringBuilderNonColor.append(c);
                    continue block7;
                }
                case ',': {
                    if (!inQuotes) {
                        isInValue = false;
                        stringBuilder.append("\u00a72,");
                        NBTUtils.addNewLine(stringBuilder, currentIndent);
                        stringBuilderNonColor.append(c);
                        NBTUtils.addNewLineNoColor(stringBuilderNonColor, currentIndent);
                        continue block7;
                    }
                    stringBuilder.append("\u00a7b,");
                    stringBuilderNonColor.append(c);
                    continue block7;
                }
                case ':': {
                    if (!inQuotes) {
                        isInValue = true;
                        stringBuilder.append("\u00a72").append(c);
                        stringBuilderNonColor.append(c);
                        continue block7;
                    }
                    stringBuilder.append("\u00a7b").append(c);
                    stringBuilderNonColor.append(c);
                    continue block7;
                }
                default: {
                    if (inQuotes) {
                        stringBuilder.append("\u00a7b").append(c);
                        stringBuilderNonColor.append(c);
                        continue block7;
                    }
                    if (isInValue) {
                        stringBuilder.append("\u00a7b").append(c);
                        stringBuilderNonColor.append(c);
                        continue block7;
                    }
                    stringBuilder.append(c);
                    stringBuilderNonColor.append(c);
                }
            }
        }
        CraftTweakerAPI.logInfo("Fancy NBT:");
        CraftTweakerAPI.logInfo(stringBuilderNonColor.toString());
        return stringBuilder.toString();
    }

    private static void addNewLine(StringBuilder s, int indent) {
        s.append("\n\u00a7e\u00e2\u201d\u0153");
        for (int j = 0; j < indent; ++j) {
            s.append("\u00a7e    ");
        }
    }

    private static void addNewLineNoColor(StringBuilder s, int indent) {
        s.append("\n\u00e2\u201d\u0153");
        for (int j = 0; j < indent; ++j) {
            s.append("    ");
        }
    }
}

