/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.brackets;

import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import crafttweaker.zenscript.GlobalRegistry;
import crafttweaker.zenscript.IBracketHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

@BracketHandler(priority=100)
@ZenRegister
public class BracketHandlerLiquid
implements IBracketHandler {
    private static final Map<String, Fluid> fluidNames = new HashMap<String, Fluid>();
    private final IJavaMethod method = JavaMethod.get(GlobalRegistry.getTypes(), BracketHandlerLiquid.class, "getLiquid", String.class);

    public static void rebuildLiquidRegistry() {
        fluidNames.clear();
        for (String fluidName : FluidRegistry.getRegisteredFluids().keySet()) {
            fluidNames.put(fluidName.replace(" ", ""), FluidRegistry.getFluid((String)fluidName));
        }
    }

    public static ILiquidStack getLiquid(String name) {
        Fluid fluid = fluidNames.get(name);
        if (fluid != null) {
            return new MCLiquidStack(new FluidStack(fluid, 1));
        }
        return null;
    }

    @Override
    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() > 2 && (tokens.get(0).getValue().equals("liquid") || tokens.get(0).getValue().equals("fluid")) && tokens.get(1).getValue().equals(":")) {
            return this.find(environment, tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        Fluid fluid = fluidNames.get(valueBuilder.toString());
        if (fluid != null) {
            return position -> new ExpressionCallStatic(position, environment, this.method, new ExpressionString(position, valueBuilder.toString()));
        }
        return null;
    }

    @Override
    public Class<?> getReturnedClass() {
        return ILiquidStack.class;
    }

    @Override
    public String getRegexMatchingString() {
        return "(fluid|liquid):.*";
    }
}

