/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import crafttweaker.api.block.BlockPatternOr;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IBlockPattern;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MCWorldBlock
implements IBlock {
    private final IBlockAccess blocks;
    private final BlockPos pos;

    public MCWorldBlock(IBlockAccess blocks, int x, int y, int z) {
        this.blocks = blocks;
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public IBlockDefinition getDefinition() {
        return CraftTweakerMC.getBlockDefinition(this.blocks.func_180495_p(this.pos).func_177230_c());
    }

    @Override
    public int getMeta() {
        return this.blocks.func_180495_p(this.pos).func_177230_c().func_176201_c(this.blocks.func_180495_p(this.pos));
    }

    @Override
    public IData getTileData() {
        TileEntity tileEntity = this.blocks.func_175625_s(this.pos);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        tileEntity.func_189515_b(nbt);
        return CraftTweakerMC.getIData((NBTBase)nbt);
    }

    @Override
    public String getDisplayName() {
        Block block = this.blocks.func_180495_p(this.pos).func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        return new ItemStack(item, 1, this.getMeta()).func_82833_r();
    }

    @Override
    public List<IBlock> getBlocks() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(IBlock block) {
        return this.getDefinition() == block.getDefinition() && (this.getMeta() == Short.MAX_VALUE || this.getMeta() == block.getMeta()) && (this.getTileData() == null || block.getTileData() != null && block.getTileData().contains(this.getTileData()));
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(this, pattern);
    }
}

