/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.BlockStateMatcherOr;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.block.BlockStateMatcher;
import crafttweaker.mc1120.block.MCBlockProperties;
import crafttweaker.mc1120.block.MCSpecificBlock;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockProperties;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MCBlockState
extends MCBlockProperties
implements crafttweaker.api.block.IBlockState {
    private final IBlockState blockState;
    private IBlock block;

    public MCBlockState(IBlockState blockState) {
        super((IBlockProperties)blockState);
        this.blockState = blockState;
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        this.block = new MCSpecificBlock(block, meta);
    }

    @Override
    public IBlock getBlock() {
        return this.block;
    }

    @Override
    public int getMeta() {
        return this.block.getMeta();
    }

    @Override
    public boolean isReplaceable(IWorld world, IBlockPos blockPos) {
        return this.blockState.func_177230_c().func_176200_f((IBlockAccess)((World)world.getInternal()), (BlockPos)blockPos.getInternal());
    }

    @Override
    public int compare(crafttweaker.api.block.IBlockState other) {
        int result = 0;
        if (!this.getInternal().equals(other.getInternal())) {
            if (this.blockState.func_177230_c().equals(((IBlockState)other.getInternal()).func_177230_c())) {
                result = Integer.compare(this.getMeta(), other.getMeta());
            } else {
                int blockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)((IBlockState)this.getInternal()).func_177230_c());
                int otherBlockId = ((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)((IBlockState)other.getInternal()).func_177230_c());
                result = Integer.compare(blockId, otherBlockId);
            }
        }
        return result;
    }

    @Override
    public crafttweaker.api.block.IBlockState withProperty(String name, String value) {
        IProperty property = this.blockState.func_177230_c().func_176194_O().func_185920_a(name);
        if (property == null) {
            CraftTweakerAPI.logWarning("Invalid property name");
        } else {
            Optional propValue = property.func_185929_b(value);
            if (propValue.isPresent()) {
                return new MCBlockState(this.blockState.func_177226_a(property, (Comparable)propValue.get()));
            }
            CraftTweakerAPI.logWarning("Invalid property value");
        }
        return this;
    }

    @Override
    public boolean matches(crafttweaker.api.block.IBlockState other) {
        return this.compare(other) == 0;
    }

    @Override
    public IBlockStateMatcher allowValuesForProperty(String propertyName, String ... propertyValues) {
        HashMap<String, List<String>> newProps = new HashMap<String, List<String>>();
        newProps.put(propertyName, (List<String>)ImmutableList.copyOf((Object[])propertyValues));
        return new BlockStateMatcher(this, newProps);
    }

    @Override
    public IBlockStateMatcher or(IBlockStateMatcher matcher) {
        return new BlockStateMatcherOr(this, matcher);
    }

    @Override
    public Collection<crafttweaker.api.block.IBlockState> getMatchingBlockStates() {
        return ImmutableList.of((Object)this);
    }
}

