/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public final class StackWrapper {
    private ItemStack stack;
    private int size;

    public StackWrapper(ItemStack stack, int size) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException();
        }
        this.stack = stack.func_77946_l();
        this.size = size;
    }

    public StackWrapper(ItemStack stack) {
        this(stack, stack.func_190916_E());
    }

    private StackWrapper() {
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("stack");
        this.stack = new ItemStack(c);
        this.size = compound.func_74762_e("size");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        this.stack.func_77955_b(c);
        compound.func_74782_a("stack", (NBTBase)c);
        compound.func_74768_a("size", this.size);
        return compound;
    }

    public String toString() {
        return "[" + this.size + "x" + this.stack.func_77973_b().func_77658_a() + "@" + this.stack.func_77952_i() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackWrapper)) {
            return false;
        }
        StackWrapper o = (StackWrapper)obj;
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)o.stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            throw new NullPointerException();
        }
        this.stack = stack.func_77946_l();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public StackWrapper copy() {
        return new StackWrapper(this.stack.func_77946_l(), this.size);
    }

    public boolean canInsert(ItemStack stack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.stack);
    }

    public boolean insert(ItemStack stack) {
        if (this.canInsert(stack)) {
            this.size += stack.func_190916_E();
        } else {
            return false;
        }
        return true;
    }

    public ItemStack extract(int size) {
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        size = Math.min(size, this.size);
        this.size -= size;
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.stack, (int)size);
    }

    public static StackWrapper loadStackWrapperFromNBT(NBTTagCompound nbt) {
        StackWrapper wrap = new StackWrapper();
        wrap.readFromNBT(nbt);
        return !wrap.getStack().func_190926_b() ? wrap : null;
    }

    @Deprecated
    public static NonNullList<ItemStack> toStackList(List<StackWrapper> list) {
        NonNullList lis = NonNullList.func_191196_a();
        for (StackWrapper s : list) {
            if (s == null || s.getStack().func_190926_b()) continue;
            int maxstacksize = s.getStack().func_77976_d();
            int stacks = s.size / maxstacksize + (s.size % maxstacksize != 0 ? 1 : 0);
            for (int i = 0; i < stacks; ++i) {
                ItemStack toAdd = s.getStack().func_77946_l();
                toAdd.func_190920_e(s.size == maxstacksize ? maxstacksize : (i < stacks - 1 ? maxstacksize : s.size % maxstacksize));
                lis.add((Object)toAdd);
            }
        }
        return lis;
    }

    @Deprecated
    public static NonNullList<ItemStack> toStackList(StackWrapper wrap) {
        return StackWrapper.toStackList(Collections.singletonList(wrap));
    }

    public static List<StackWrapper> toWrapperList(List<ItemStack> list) {
        ArrayList lis = Lists.newArrayList();
        for (ItemStack s : list) {
            if (s.func_190926_b()) continue;
            boolean added = false;
            for (int i = 0; i < lis.size(); ++i) {
                ItemStack stack = ((StackWrapper)lis.get(i)).getStack();
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                ((StackWrapper)lis.get((int)i)).size += s.func_190916_E();
                added = true;
                break;
            }
            if (added) continue;
            lis.add(new StackWrapper(s, s.func_190916_E()));
        }
        return lis;
    }

    public static void add(StackWrapper wrap, List<StackWrapper> lis) {
        boolean added = false;
        for (StackWrapper w : lis) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)wrap.stack, (ItemStack)w.stack)) continue;
            w.size += wrap.size;
            added = true;
            break;
        }
        if (!added) {
            lis.add(wrap);
        }
    }
}

