/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4f;
import mrriegel.limelib.LimeConfig;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.datapart.RenderRegistry;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.helper.EnergyHelper;
import mrriegel.limelib.helper.ParticleHelper;
import mrriegel.limelib.helper.RecipeHelper;
import mrriegel.limelib.tile.IHUDProvider;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="limelib", value={Side.CLIENT})
public class ClientEventHandler {
    private static Minecraft mc = null;
    public static Map<BlockPos, Pair<Long, Long>> energyTiles = Maps.newHashMap();
    public static Map<BlockPos, List<String>> supplierTexts = Maps.newHashMap();
    public static DataPart rayTrace = null;

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent event) {
        event.getMap().func_174942_a(ParticleHelper.roundParticle);
        event.getMap().func_174942_a(ParticleHelper.sparkleParticle);
        event.getMap().func_174942_a(ParticleHelper.squareParticle);
    }

    private static Minecraft getMC() {
        if (mc == null) {
            mc = Minecraft.func_71410_x();
        }
        return mc;
    }

    @SubscribeEvent
    public static void renderEnergy(RenderGameOverlayEvent.Post event) {
        Minecraft mc = ClientEventHandler.getMC();
        if (!LimeConfig.showEnergy || mc.field_71441_e == null || mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK || mc.field_71476_x.func_178782_a() == null || mc.field_71441_e.func_175625_s(mc.field_71476_x.func_178782_a()) == null || energyTiles.isEmpty()) {
            return;
        }
        BlockPos p = mc.field_71476_x.func_178782_a();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && energyTiles.containsKey(p)) {
            EnergyHelper.Energy energyType = null;
            energyType = EnergyHelper.isEnergyContainer((ICapabilityProvider)mc.field_71441_e.func_175625_s(p), null);
            if (energyType == null) {
                energyTiles.remove(p);
                return;
            }
            ScaledResolution sr = event.getResolution();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GuiDrawer drawer = new GuiDrawer(0, 0, 0, 0, 0.0f);
            int color = 0;
            drawer.drawColoredRectangle(0, 0, 44, 44, color);
            long energy = (Long)energyTiles.get(p).getLeft();
            long max = (Long)energyTiles.get(p).getRight();
            String text = (!GuiScreen.func_146272_n() ? Utils.formatNumber(energy) : Long.valueOf(energy)) + "/" + (!GuiScreen.func_146272_n() ? Utils.formatNumber(max) : Long.valueOf(max)) + " " + energyType.unit;
            int lenght = 90;
            mc.field_71466_p.func_175065_a(text, (float)((sr.func_78326_a() - mc.field_71466_p.func_78256_a(text)) / 2), (float)((sr.func_78328_b() - 15 - mc.field_71466_p.field_78288_b) / 2), GuiScreen.func_146272_n() ? 0xFFFF00 : -2130706688, true);
            if (LimeConfig.energyConfigHint) {
                boolean before = mc.field_71466_p.func_82883_a();
                mc.field_71466_p.func_78264_a(true);
                String config = "Can be disabled in LimeLib config.";
                mc.field_71466_p.func_175065_a(config, (float)((sr.func_78326_a() - mc.field_71466_p.func_78256_a(config)) / 2), (float)((sr.func_78328_b() + 40 - mc.field_71466_p.field_78288_b) / 2), 0x40FFFF00, true);
                mc.field_71466_p.func_78264_a(before);
            }
            drawer.drawEnergyBarH((sr.func_78326_a() - lenght) / 2, (sr.func_78328_b() + 20 - 8) / 2, lenght, (float)((double)energy / (double)max));
            drawer.drawFrame((sr.func_78326_a() - lenght) / 2 - 1, (sr.func_78328_b() + 20 - 8) / 2 - 1, lenght + 2, 9, 1, Color.BLACK.getRGB());
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        Minecraft mc = ClientEventHandler.getMC();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null && !mc.func_147113_T()) {
            DataPartRegistry reg = DataPartRegistry.get((World)mc.field_71441_e);
            if (reg != null) {
                for (DataPart part : reg.getParts().stream().filter(p -> p != null && mc.field_71441_e.func_175667_e(p.getPos())).collect(Collectors.toList())) {
                    part.updateClient((World)mc.field_71441_e);
                    ++part.ticksExisted;
                }
            }
            if (mc.field_71439_g != null && mc.field_71439_g.field_70173_aa % 2 == 0) {
                rayTrace = DataPart.rayTrace((EntityPlayer)mc.field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        DataPartRegistry reg;
        RayTraceResult rtr = ClientEventHandler.getMC().field_71476_x;
        if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK && ClientEventHandler.getMC().field_71415_G) {
            IHUDProvider tile;
            TileEntity t = ClientEventHandler.getMC().field_71441_e.func_175625_s(rtr.func_178782_a());
            IHUDProvider iHUDProvider = tile = IHUDProvider.isHUDProvider(t) ? IHUDProvider.getHUDProvider(t) : null;
            if (tile != null) {
                List<String> foo;
                boolean sneak = ClientEventHandler.getMC().field_71439_g.func_70093_af();
                EnumFacing face = rtr.field_178784_b.func_176734_d();
                boolean playerhorizontal = false;
                if (face.func_176740_k() == EnumFacing.Axis.Y || playerhorizontal) {
                    face = ClientEventHandler.getMC().field_71439_g.func_174811_aO();
                }
                List<String> tmp = null;
                tmp = tile.readingSide().isServer() ? ((foo = supplierTexts.get(t.func_174877_v())) != null ? foo : tile.getData(sneak, face.func_176734_d())) : tile.getData(sneak, face.func_176734_d());
                if (tmp != null && !tmp.isEmpty()) {
                    double x = (double)t.func_174877_v().func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
                    double y = (double)t.func_174877_v().func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
                    double z = (double)t.func_174877_v().func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
                    GlStateManager.func_179094_E();
                    double dx = face.func_176740_k() == EnumFacing.Axis.Z ? 0.5 : Math.max(-0.001, (double)face.func_176743_c().func_179524_a() * -1.001);
                    double dz = face.func_176740_k() == EnumFacing.Axis.X ? 0.5 : Math.max(-0.001, (double)face.func_176743_c().func_179524_a() * -1.001);
                    GlStateManager.func_179137_b((double)((double)((float)x) + dx), (double)((float)y + 1.0f), (double)((double)((float)z) + dz));
                    float f1 = (float)face.func_176736_b() * 90.0f;
                    if (face.func_176740_k() == EnumFacing.Axis.Z) {
                        f1 += 180.0f;
                    }
                    GlStateManager.func_179114_b((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179091_B();
                    FontRenderer fontrenderer = ClientEventHandler.getMC().field_71466_p;
                    float f3 = 0.010416667f;
                    GlStateManager.func_179152_a((float)f3, (float)(-f3), (float)f3);
                    GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)(-f3));
                    GlStateManager.func_179132_a((boolean)false);
                    int maxWordLength = 93;
                    boolean cutLongLines = tile.lineBreak(sneak, face.func_176734_d());
                    double factor = MathHelper.func_151237_a((double)tile.scale(sneak, face.func_176734_d()), (double)0.1, (double)2.0);
                    List text = tmp.stream().filter(s -> s != null).flatMap(s -> (!cutLongLines ? Collections.singletonList(s) : fontrenderer.func_78271_c(s, (int)(93.0 / factor))).stream()).collect(Collectors.toList());
                    int lineHeight = fontrenderer.field_78288_b + 1;
                    int oy = (int)(-((double)(lineHeight * text.size()) * factor));
                    int ysize = -oy;
                    new GuiDrawer(0, 0, 0, 0, 0.0f).drawColoredRectangle(-48, oy, 96, ysize, tile.getBackgroundColor(sneak, face.func_176734_d()));
                    GlStateManager.func_179137_b((double)0.0, (double)((double)(-text.size() * lineHeight) * factor), (double)0.0);
                    GlStateManager.func_179139_a((double)factor, (double)factor, (double)factor);
                    for (int j = 0; j < text.size(); ++j) {
                        int xx;
                        String s2 = (String)text.get(j);
                        boolean shadow = s2.contains("?~_\u6f2b~%z");
                        if (shadow) {
                            s2 = s2.replace("?~_\u6f2b~%z", "");
                        }
                        int width = fontrenderer.func_78256_a(s2);
                        boolean tooLong = !cutLongLines && (double)width * factor > 93.0;
                        double fac = 93.0 / ((double)width * factor);
                        int n = xx = tile.center(sneak, face.func_176734_d()) || tooLong ? -width / 2 : (int)(-46.0 / factor);
                        if (tooLong) {
                            GlStateManager.func_179139_a((double)fac, (double)1.0, (double)1.0);
                        }
                        fontrenderer.func_175065_a(s2, (float)xx, (float)(j * 10 + 1), -1, shadow);
                        if (!tooLong) continue;
                        GlStateManager.func_179139_a((double)(1.0 / fac), (double)1.0, (double)1.0);
                    }
                    GlStateManager.func_179139_a((double)(1.0 / factor), (double)(1.0 / factor), (double)(1.0 / factor));
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                }
            }
        }
        if ((reg = DataPartRegistry.get((World)ClientEventHandler.getMC().field_71441_e)) != null) {
            reg.getParts().stream().filter(p -> p != null && ClientEventHandler.getMC().field_71439_g.func_70011_f((double)p.getX(), (double)p.getY(), (double)p.getZ()) < 64.0).forEach(p -> {
                RenderRegistry.RenderDataPart<? extends DataPart> ren = RenderRegistry.map.get(p.getClass());
                if (ren != null) {
                    ren.render((DataPart)p, (double)p.getX() - TileEntityRendererDispatcher.field_147554_b, (double)p.getY() - TileEntityRendererDispatcher.field_147555_c, (double)p.getZ() - TileEntityRendererDispatcher.field_147552_d, event.getPartialTicks());
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void itemToolTip(ItemTooltipEvent event) {
        Minecraft mc = ClientEventHandler.getMC();
        if (LimeConfig.commandBlockCreativeTab && mc.field_71462_r instanceof GuiContainerCreative && ((GuiContainerCreative)mc.field_71462_r).func_147056_g() == CreativeTabs.field_78028_d.func_78021_a() && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof BlockCommandBlock) {
            event.getToolTip().add(TextFormatting.YELLOW + "Can be disabled in LimeLib config.");
        }
    }

    @SubscribeEvent
    public static void draw(DrawBlockHighlightEvent event) {
        DataPart part = rayTrace;
        if (part != null && part.getHighlightBox() != null) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos blockpos = part.getPos();
            double d0 = TileEntityRendererDispatcher.field_147554_b;
            double d1 = TileEntityRendererDispatcher.field_147555_c;
            double d2 = TileEntityRendererDispatcher.field_147552_d;
            RenderGlobal.func_189697_a((AxisAlignedBB)part.getHighlightBox().func_186670_a(blockpos).func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void test(RenderWorldLastEvent event) {
        if (!RecipeHelper.dev) {
            return;
        }
        Vec3d arr = new Vec3d(9.5, 6.0, 5.5);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (arr.func_72438_d(player.func_174791_d()) > 32.0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        double d3 = TileEntityRendererDispatcher.field_147554_b;
        double d4 = TileEntityRendererDispatcher.field_147555_c;
        double d5 = TileEntityRendererDispatcher.field_147552_d;
        boolean color = false;
        GlStateManager.func_179137_b((double)(arr.field_72450_a - d3), (double)(arr.field_72448_b - d4), (double)(arr.field_72449_c - d5));
        float angle = System.currentTimeMillis() / 10L % 360L;
        Vector2d arrow = new Vector2d(arr.field_72450_a, arr.field_72449_c);
        Entity e = null;
        List lis = player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(arr.func_72441_c(6.0, 6.0, 6.0), arr.func_72441_c(-6.0, -6.0, -6.0)));
        if (!lis.isEmpty()) {
            e = (Entity)lis.get(0);
            Vector2d vector2d = new Vector2d(e.field_70165_t, e.field_70161_v);
        }
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder bb = tes.func_178180_c();
        GL11.glLineWidth((float)(5.0f / (float)arr.func_72438_d(new Vec3d(d3, d4, d5))));
        bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.5, -0.5, 0.5).func_181666_a(0.9f, 0.4f, 0.7f, 1.0f).func_181675_d();
        bb.func_181662_b(0.5, 1.5, 0.5).func_181666_a(0.9f, 0.4f, 0.7f, 1.0f).func_181675_d();
        tes.func_78381_a();
        bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Random ran = new Random(System.identityHashCode(player));
        Vector4f col = new Vector4f(0.1f, 0.4f, 0.6f, 1.0f);
        float diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.EAST);
        bb.func_181662_b(0.0, 0.4, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.6, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.6, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.4, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.UP);
        bb.func_181662_b(0.0, 0.6, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.6, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.DOWN);
        bb.func_181662_b(0.0, 0.4, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.4, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.NORTH);
        bb.func_181662_b(0.0, 0.4, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.6, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.3).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(1.0, 0.6, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(1.0, 0.4, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.SOUTH);
        bb.func_181662_b(0.6, 0.4, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.6, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.0, 0.4, 0.7).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(1.0, 0.4, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(1.0, 0.6, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        tes.func_78381_a();
        bb.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.UP);
        bb.func_181662_b(0.6, 0.6, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.6, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(1.0, 0.6, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        diffuse = LightUtil.diffuseLight((EnumFacing)EnumFacing.DOWN);
        bb.func_181662_b(1.0, 0.4, 0.5).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.9).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        bb.func_181662_b(0.6, 0.4, 0.1).func_181666_a(col.x * diffuse, col.y * diffuse, col.z * diffuse, col.w).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

