/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mrriegel.limelib.helper.RecipeHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public abstract class AbstractRecipe<S, T> {
    protected final List<S> output;
    protected final boolean order;
    protected final List<Ingredient> input;

    public AbstractRecipe(List<S> output, boolean order, Object ... input) {
        if (output.contains(null)) {
            throw new IllegalArgumentException("output contains null");
        }
        this.output = Collections.unmodifiableList(output);
        this.order = order;
        this.input = Collections.unmodifiableList(Arrays.asList(input).stream().map(o -> this.getIngredient(o)).collect(Collectors.toList()));
    }

    protected abstract List<ItemStack> getIngredients(T var1);

    public abstract boolean removeIngredients(T var1, boolean var2);

    public abstract List<ItemStack> getResult(T var1);

    protected Ingredient getIngredient(Object obj) {
        return RecipeHelper.getIngredient(obj);
    }

    public List<S> getOutput() {
        return this.output;
    }

    public boolean isOrder() {
        return this.order;
    }

    public List<Ingredient> getInput() {
        return this.input;
    }

    public boolean match(T object) {
        List<ItemStack> list = this.getIngredients(object);
        if (list.size() != this.input.size()) {
            return false;
        }
        if (this.order) {
            for (int i = 0; i < this.input.size(); ++i) {
                if (this.match(list.get(i), this.input.get(i))) continue;
                return false;
            }
            return true;
        }
        ArrayList foo = Lists.newArrayList(this.input);
        for (ItemStack stack : list) {
            if (stack.func_190926_b()) continue;
            boolean flag = false;
            for (int i = 0; i < foo.size(); ++i) {
                Ingredient o = (Ingredient)foo.get(i);
                if (!this.match(stack, o)) continue;
                flag = true;
                foo.remove(i);
                break;
            }
            if (flag) continue;
            return false;
        }
        return foo.isEmpty();
    }

    protected boolean match(ItemStack stack, Ingredient o) {
        return o.apply(stack);
    }
}

