/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.particle;

import java.awt.Color;
import java.util.Random;
import javax.vecmath.Vector4f;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.helper.ColorHelper;
import mrriegel.limelib.helper.ParticleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CommonParticle
extends Particle {
    protected double flouncing = 0.0;
    protected int visibleRange = 32;
    protected int brightness = -1;
    protected boolean depth = true;
    protected boolean smoothEnd = true;
    protected IColorCall colors;

    public CommonParticle(double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed) {
        super(LimeLib.proxy.getClientWorld(), xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.field_187129_i = xSpeed;
        this.field_187130_j = ySpeed;
        this.field_187131_k = zSpeed;
        this.setTexture(ParticleHelper.roundParticle);
        this.colors = par -> new Vector4f(par.field_70552_h, par.field_70553_i, par.field_70551_j, par.field_82339_as);
    }

    public CommonParticle(double xCoord, double yCoord, double zCoord) {
        this(xCoord, yCoord, zCoord, 0.0, 0.0, 0.0);
    }

    public void func_189213_a() {
        float percent;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i += (this.field_187136_p.nextDouble() - 0.5) * this.flouncing;
        this.field_187130_j += (this.field_187136_p.nextDouble() - 0.5) * this.flouncing;
        this.field_187131_k += (this.field_187136_p.nextDouble() - 0.5) * this.flouncing;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        if (this.smoothEnd && (percent = (float)this.field_70546_d / (float)this.field_70547_e) > 0.7f) {
            this.field_82339_as /= 2.0f - percent;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Vector4f color = this.colors.getColor(this);
        this.field_70552_h = color.x;
        this.field_70553_i = color.y;
        this.field_70551_j = color.z;
        this.field_82339_as = color.w;
        if (entityIn.func_70011_f(this.field_187126_f, this.field_187127_g, this.field_187128_h) <= (double)this.visibleRange) {
            if (this.depth) {
                super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            } else {
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            }
        }
    }

    public int func_189214_a(float p_189214_1_) {
        int i;
        if (this.brightness < 0) {
            return super.func_189214_a(p_189214_1_);
        }
        int j = i = MathHelper.func_76125_a((int)this.brightness, (int)0, (int)15);
        return i << 20 | j << 4;
    }

    public int func_70537_b() {
        return 1;
    }

    public boolean func_187111_c() {
        return true;
    }

    public CommonParticle setColor(int color, int diff) {
        diff = MathHelper.func_76125_a((int)diff, (int)0, (int)255);
        Random random = new Random();
        if (diff > 0) {
            int red = MathHelper.func_76125_a((int)(ColorHelper.getRed(color) + MathHelper.func_76136_a((Random)random, (int)(-diff), (int)diff)), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)(ColorHelper.getGreen(color) + MathHelper.func_76136_a((Random)random, (int)(-diff), (int)diff)), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)(ColorHelper.getBlue(color) + MathHelper.func_76136_a((Random)random, (int)(-diff), (int)diff)), (int)0, (int)255);
            color = new Color(red, green, blue, ColorHelper.getAlpha(color)).getRGB();
        }
        this.field_70552_h = (float)ColorHelper.getRed(color) / 255.0f;
        this.field_70553_i = (float)ColorHelper.getGreen(color) / 255.0f;
        this.field_70551_j = (float)ColorHelper.getBlue(color) / 255.0f;
        this.field_82339_as = (float)ColorHelper.getAlpha(color) / 255.0f;
        return this;
    }

    public CommonParticle setColor(int color, int alpha, int diff) {
        return this.setColor(ColorHelper.getRGB(color, alpha), diff);
    }

    public CommonParticle setFlouncing(double flouncing) {
        this.flouncing = flouncing;
        return this;
    }

    public CommonParticle setMaxAge2(int ticks) {
        this.field_70547_e = ticks;
        return this;
    }

    public CommonParticle setTexture(ResourceLocation texture) {
        this.func_187117_a(Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString()));
        return this;
    }

    public CommonParticle setScale(float scale) {
        this.field_70544_f = scale;
        return this;
    }

    public CommonParticle setGravity(float gravity) {
        this.field_70545_g = gravity;
        return this;
    }

    public CommonParticle setNoClip(boolean noClip) {
        this.field_190017_n = !noClip;
        return this;
    }

    public CommonParticle setVisibleRange(int visibleRange) {
        this.visibleRange = visibleRange;
        return this;
    }

    public CommonParticle setBrightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public CommonParticle setDepth(boolean depth) {
        this.depth = depth;
        return this;
    }

    public CommonParticle setSmoothEnd(boolean smoothEnd) {
        this.smoothEnd = smoothEnd;
        return this;
    }

    public CommonParticle setColors(IColorCall colors) {
        this.colors = colors;
        return this;
    }

    @FunctionalInterface
    public static interface IColorCall {
        public Vector4f getColor(CommonParticle var1);
    }
}

