/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.TeleportMessage;
import mrriegel.limelib.util.GlobalBlockPos;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TeleportationHelper {
    static Field invul = ReflectionHelper.findField(EntityPlayerMP.class, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj"});

    public static void prepareEntity(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            try {
                invul.set(entity, true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean canTeleport(Entity entity) {
        return entity != null && !entity.field_70170_p.field_72995_K && entity.func_70089_S() && !entity.func_184207_aI() && !entity.func_184218_aH() && (entity instanceof EntityLivingBase || entity instanceof EntityItem);
    }

    public static Optional<Entity> teleport(Entity entity, GlobalBlockPos pos) {
        return TeleportationHelper.teleport(entity, pos.getPos(), pos.getDimension());
    }

    public static Optional<Entity> teleport(Entity entity, BlockPos pos) {
        return TeleportationHelper.teleport(entity, pos, entity.field_70170_p.field_73011_w.getDimension());
    }

    public static Optional<Entity> teleport(Entity entity, Vec3d vec) {
        return TeleportationHelper.teleport(entity, vec, entity.field_70170_p.field_73011_w.getDimension());
    }

    public static Optional<Entity> teleport(Entity entity, BlockPos pos, int targetDim) {
        return TeleportationHelper.teleport(entity, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5), targetDim);
    }

    public static Optional<Entity> teleport(Entity entity, Vec3d vec, int targetDim) {
        if (!TeleportationHelper.canTeleport(entity)) {
            return Optional.empty();
        }
        TeleportationHelper.prepareEntity(entity);
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        int from = entity.field_70170_p.field_73011_w.getDimension();
        if (from != targetDim) {
            if (!DimensionManager.isDimensionRegistered((int)targetDim)) {
                LimeLib.log.error("serverTeleport: Dimension " + targetDim + " is not registered.");
                return Optional.empty();
            }
            MinecraftServer server = entity.field_70170_p.func_73046_m();
            WorldServer fromDim = server.func_71218_a(from);
            WorldServer toDim = server.func_71218_a(targetDim);
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_82242_a(0);
                Tele teleporter = new Tele(toDim, x, y, z, entity.field_70177_z, entity.field_70125_A);
                if (from == 1) {
                    entity.field_70170_p.func_72900_e(entity);
                }
                TeleportationHelper.print("1t", (World)toDim);
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, targetDim, (Teleporter)teleporter);
                if (from == 1 && entity.func_70089_S()) {
                    toDim.func_72838_d(entity);
                    toDim.func_72866_a(entity, false);
                    entity.func_70634_a(x, y, z);
                }
                TeleportationHelper.print("2t", (World)toDim);
                PacketHandler.sendTo(new TeleportMessage(), (EntityPlayerMP)entity);
                Entity e = entity;
                if ("".isEmpty()) {
                    toDim.func_73046_m().field_175589_i.add(new FutureTask<Object>(Executors.callable(() -> TeleportationHelper.prepareEntity(e))));
                }
            } else {
                NBTTagCompound tagCompound = entity.serializeNBT();
                float rotationYaw = entity.field_70177_z;
                float rotationPitch = entity.field_70125_A;
                fromDim.func_72900_e(entity);
                try {
                    Entity newEntity = EntityList.func_75615_a((NBTTagCompound)tagCompound, (World)toDim);
                    newEntity.func_70012_b(x, y, z, rotationYaw, rotationPitch);
                    newEntity.field_98038_p = true;
                    toDim.func_72838_d(newEntity);
                    newEntity.field_98038_p = false;
                    entity = newEntity;
                }
                catch (Exception e) {
                    LimeLib.log.error("serverTeleport: Error creating a entity to be created in new dimension.");
                    return Optional.empty();
                }
            }
            TeleportationHelper.print("3t", (World)toDim);
        } else {
            entity.func_70634_a(x, y, z);
        }
        return Optional.of(entity);
    }

    public static final void print(String pre, World world) {
    }

    public static class Tele
    extends Teleporter {
        double x;
        double y;
        double z;
        float yaw;
        float pitch;

        public Tele(WorldServer worldIn, double x, double y, double z, float yaw, float pitch) {
            super(worldIn);
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public boolean func_85188_a(Entity p_makePortal_1_) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            return true;
        }

        public void func_180266_a(Entity entity, float rotationYaw) {
            if (!entity.field_70170_p.func_175667_e(new BlockPos(this.x, this.y, this.z))) {
                entity.field_70170_p.func_180495_p(new BlockPos(this.x, this.y, this.z));
            }
            TeleportationHelper.teleport(entity, new Vec3d(this.x, this.y, this.z));
            entity.field_70177_z = this.yaw;
            entity.field_70125_A = this.pitch;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
        }

        public void func_85189_a(long p_removeStalePortalLocations_1_) {
        }
    }
}

