/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mrriegel.limelib.util.Utils;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="limelib")
public class RegistryHelper {
    private static final List<IForgeRegistryEntry<?>> entries = Lists.newArrayList();
    private static final Map<Pair<Item, Integer>, ModelResourceLocation> models = Maps.newHashMap();

    @SubscribeEvent
    public static <T extends IForgeRegistryEntry<T>> void registerEvent(RegistryEvent.Register event) {
        Class clazz = (Class)event.getGenericType();
        Iterator<IForgeRegistryEntry<?>> it = entries.iterator();
        while (it.hasNext()) {
            IForgeRegistryEntry<?> entry = it.next();
            if (!clazz.isAssignableFrom(entry.getClass())) continue;
            event.getRegistry().register(entry);
            it.remove();
        }
    }

    @SubscribeEvent
    public static void registerModelEvent(ModelRegistryEvent event) {
        for (Map.Entry<Pair<Item, Integer>, ModelResourceLocation> e : models.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)((Item)e.getKey().getKey()), (int)((Integer)e.getKey().getValue()), (ModelResourceLocation)e.getValue());
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistryEntry<T> entry) {
        entries.add(entry);
    }

    public static <T extends IForgeRegistryEntry<T>> void unregister(IForgeRegistryEntry<T> entry) {
        entries.remove(entry);
    }

    public static void initModel(Item item, int meta, ModelResourceLocation mrl) {
        Validate.isTrue((item != null && item != Items.field_190931_a ? 1 : 0) != 0);
        models.put((Pair<Item, Integer>)Pair.of((Object)item, (Object)meta), mrl);
    }

    public static void setRegistryName(IForgeRegistryEntry.Impl<?> entry, ResourceLocation rl) {
        if (Utils.getCurrentModID().equals(rl.func_110624_b())) {
            entry.setRegistryName(rl);
        } else {
            ReflectionHelper.setPrivateValue(IForgeRegistryEntry.Impl.class, entry, (Object)rl, (String[])new String[]{"registryName"});
        }
    }
}

