/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.helper.RegistryHelper;
import mrriegel.limelib.recipe.ShapedRecipeExt;
import mrriegel.limelib.recipe.ShapelessRecipeExt;
import mrriegel.limelib.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;

public class RecipeHelper {
    public static final boolean dev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    private static Map<String, RecipeHelper> helpers = Maps.newHashMap();
    private File DIR;
    private final Set<String> USED_OD_NAMES = Sets.newTreeSet();
    private boolean oldway = true;

    private static RecipeHelper getHelper() {
        String modid = Utils.getCurrentModID();
        RecipeHelper rh = helpers.get(modid);
        if (rh != null) {
            return rh;
        }
        rh = new RecipeHelper(modid);
        helpers.put(modid, rh);
        return rh;
    }

    private RecipeHelper(String modid) {
        this.DIR = new File("").toPath().resolve("../src/main/resources/assets/" + modid + "/recipes/").toFile();
        if (!this.DIR.exists() && dev) {
            this.DIR.mkdirs();
        }
        if (!dev) {
            File jar = Loader.instance().activeModContainer().getSource();
            try {
                JarInputStream jis = new JarInputStream(new FileInputStream(jar));
                JarEntry e = null;
                while ((e = jis.getNextJarEntry()) != null) {
                    if (!e.getName().equals("assets/" + modid + "/recipes/")) continue;
                    this.oldway = false;
                    break;
                }
                jis.close();
            }
            catch (IOException iOException) {}
        } else {
            this.oldway = false;
        }
    }

    @Deprecated
    public static void addShapedOreRecipe(ItemStack stack, Object ... input) {
        RecipeHelper.addShapedRecipe(stack, input);
    }

    public static void addShapedRecipe(ItemStack stack, Object ... input) {
        RecipeHelper rh = RecipeHelper.getHelper();
        ResourceLocation rl = RecipeHelper.name(stack, input);
        if (Arrays.stream(input).anyMatch(o -> o instanceof Collection)) {
            RecipeHelper.addRecipe(rl, (IRecipe)new ShapedRecipeExt(rl, stack, input));
        } else if (Arrays.stream(input).anyMatch(o -> o instanceof String && OreDictionary.doesOreNameExist((String)((String)o)))) {
            if (rh.oldway) {
                RecipeHelper.addRecipe(rl, (IRecipe)new ShapedOreRecipe(rl, stack, input));
            } else {
                rh.addRecipe(rl, true, true, stack, input);
            }
        } else if (rh.oldway) {
            CraftingHelper.ShapedPrimer sp = CraftingHelper.parseShaped((Object[])input);
            RecipeHelper.addRecipe(rl, (IRecipe)new ShapedRecipes("", sp.width, sp.height, sp.input, stack));
        } else {
            rh.addRecipe(rl, true, false, stack, input);
        }
    }

    @Deprecated
    public static void addShapelessOreRecipe(ItemStack stack, Object ... input) {
        RecipeHelper.addShapelessRecipe(stack, input);
    }

    public static void addShapelessRecipe(ItemStack stack, Object ... input) {
        RecipeHelper rh = RecipeHelper.getHelper();
        ResourceLocation rl = RecipeHelper.name(stack, input);
        if (Arrays.stream(input).anyMatch(o -> o instanceof Collection)) {
            RecipeHelper.addRecipe(rl, (IRecipe)new ShapelessRecipeExt(rl, stack, input));
        } else if (Arrays.stream(input).anyMatch(o -> o instanceof String && OreDictionary.doesOreNameExist((String)((String)o)))) {
            if (rh.oldway) {
                RecipeHelper.addRecipe(rl, (IRecipe)new ShapelessOreRecipe(rl, stack, input));
            } else {
                rh.addRecipe(rl, false, true, stack, input);
            }
        } else if (rh.oldway) {
            RecipeHelper.addRecipe(rl, (IRecipe)new ShapelessRecipes("", stack, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])Lists.newArrayList((Object[])input).stream().map(o -> CraftingHelper.getIngredient((Object)o)).filter(o -> o != null).collect(Collectors.toList()).toArray(new Ingredient[0]))));
        } else {
            rh.addRecipe(rl, false, false, stack, input);
        }
    }

    public static void add(IRecipe recipe) {
        Validate.isTrue((!recipe.getClass().getName().startsWith("net.minecraft") ? 1 : 0) != 0, (String)"Use JSON instead", (Object[])new Object[0]);
        ResourceLocation rl = RecipeHelper.name(recipe.func_77571_b(), recipe.func_192400_c().toArray((Object[])new Ingredient[0]));
        RecipeHelper.addRecipe(rl, recipe);
    }

    private static void addRecipe(ResourceLocation rl, IRecipe recipe) {
        Validate.isTrue((!recipe.func_77571_b().func_190926_b() ? 1 : 0) != 0);
        recipe.setRegistryName(rl);
        RegistryHelper.register(recipe);
    }

    private void addRecipe(ResourceLocation rl, boolean shaped, boolean ore, ItemStack stack, Object ... input) {
        if (!dev) {
            return;
        }
        HashMap json = Maps.newHashMap();
        if (shaped) {
            int i;
            ArrayList pattern = Lists.newArrayList();
            for (i = 0; i < input.length && input[i] instanceof String; ++i) {
                pattern.add((String)input[i]);
            }
            json.put("pattern", pattern);
            HashMap key = Maps.newHashMap();
            Character curKey = null;
            while (i < input.length) {
                Object o2 = input[i];
                if (o2 instanceof Character) {
                    if (curKey != null) {
                        throw new IllegalArgumentException("Provided two char keys in a row");
                    }
                    curKey = (Character)o2;
                } else {
                    if (curKey == null) {
                        throw new IllegalArgumentException("Providing object without a char key");
                    }
                    key.put(Character.toString(curKey.charValue()), this.serializeItem(o2));
                    curKey = null;
                }
                ++i;
            }
            json.put("key", key);
        } else {
            json.put("ingredients", Arrays.stream(input).map(o -> this.serializeItem(o)).collect(Collectors.toList()));
        }
        json.put("type", shaped ? (ore ? "forge:ore_shaped" : "minecraft:crafting_shaped") : (ore ? "forge:ore_shapeless" : "minecraft:crafting_shapeless"));
        json.put("result", this.serializeItem(stack));
        if (!stack.func_190926_b()) {
            File f = new File(this.DIR, rl.func_110623_a().replace('/', '|') + ".json");
            RecipeHelper.writeToFile(f, json);
        } else {
            LimeLib.log.warn("ItemStack is empty. Can't create a recipe. " + Arrays.toString(input));
        }
    }

    private static ResourceLocation name(ItemStack stack, Object ... input) {
        List lis = Arrays.stream(input).map(o -> {
            if (o instanceof String) {
                return o.toString();
            }
            if (o instanceof Item) {
                return ((Item)o).getRegistryName().func_110623_a().toString();
            }
            if (o instanceof Block) {
                return ((Block)o).getRegistryName().func_110623_a().toString();
            }
            if (o instanceof ItemStack) {
                return ((ItemStack)o).func_77973_b().getRegistryName().func_110623_a().toString();
            }
            if (o instanceof Ingredient) {
                return Joiner.on((String)" ").join((Iterable)Arrays.stream(((Ingredient)o).func_193365_a()).map(s -> s.func_77973_b().getRegistryName().func_110623_a().toString()).sorted().collect(Collectors.toList()));
            }
            return "";
        }).collect(Collectors.toList());
        return new ResourceLocation(Utils.getCurrentModID(), stack.func_77973_b().getRegistryName().func_110623_a() + "/" + stack.func_77952_i() + "#" + stack.func_190916_E() + "_" + Math.abs(lis.hashCode()) % 9999);
    }

    public static Ingredient getIngredient(Object obj) {
        Ingredient ret = CraftingHelper.getIngredient((Object)obj);
        if (ret != null) {
            return ret;
        }
        ArrayList lis = Lists.newArrayList();
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                lis.add(CraftingHelper.getIngredient(o));
            }
        }
        return new CompoundIngredient(lis);
    }

    private Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return this.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return this.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap ret = Maps.newHashMap();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                throw new IllegalArgumentException("nbt not implemented");
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap ret = Maps.newHashMap();
            this.USED_OD_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase());
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public static void generateConstants() {
        if (!dev) {
            return;
        }
        for (RecipeHelper rh : helpers.values()) {
            ArrayList json = Lists.newArrayList();
            for (String s : rh.USED_OD_NAMES) {
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("name", s.toUpperCase());
                entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
                json.add(entry);
            }
            if (rh.USED_OD_NAMES.isEmpty()) continue;
            File file = new File(rh.DIR, "_constants.json");
            RecipeHelper.writeToFile(file, json);
        }
    }

    private static void writeToFile(File file, Object o) {
        String newJson = Utils.getGSON().toJson(o).trim();
        String oldJson = null;
        try {
            oldJson = !file.exists() ? "" : Files.lines(file.toPath()).collect(Collectors.joining(Configuration.NEW_LINE)).trim();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!oldJson.equals(newJson)) {
            try (FileWriter fw = new FileWriter(file);){
                Utils.getGSON().toJson(o, (Appendable)fw);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class CompoundIngredient
    extends net.minecraftforge.common.crafting.CompoundIngredient {
        protected CompoundIngredient(Collection<Ingredient> children) {
            super((Collection)children.stream().filter(i -> i != null).collect(Collectors.toList()));
        }
    }
}

