/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class NBTHelper {
    private static Set<INBTable> iNBTs = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<INBTable>(){

        public int hashCode(INBTable o) {
            return System.identityHashCode(o);
        }

        public boolean equals(INBTable a, INBTable b) {
            return a == b;
        }
    });

    public static boolean hasTag(NBTTagCompound nbt, String keyName) {
        return nbt != null && nbt.func_74764_b(keyName);
    }

    public static void removeTag(NBTTagCompound nbt, String keyName) {
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o(keyName);
    }

    public static int getSize(NBTTagCompound nbt) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        return buf.readableBytes();
    }

    public static Pair<NBTTagCompound, NBTTagCompound> split(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        List ns = nbt.func_150296_c().stream().map(s -> Pair.of((Object)s, (Object)nbt.func_74781_a(s))).collect(Collectors.toList());
        int nsize = ns.size();
        if (nsize < 2) {
            return Pair.of((Object)nbt, (Object)new NBTTagCompound());
        }
        NBTTagCompound a = new NBTTagCompound();
        NBTTagCompound b = new NBTTagCompound();
        List as = ns.subList(0, (nsize + 1) / 2);
        List bs = ns.subList((nsize + 1) / 2, nsize);
        for (Pair p : as) {
            a.func_74782_a((String)p.getKey(), (NBTBase)p.getValue());
        }
        for (Pair p : bs) {
            b.func_74782_a((String)p.getKey(), (NBTBase)p.getValue());
        }
        return Pair.of((Object)a, (Object)b);
    }

    @Deprecated
    public static void register(INBTable n) {
        iNBTs.add(n);
    }

    private static INBTable getINBT(Class<?> clazz) {
        for (INBTable n : iNBTs) {
            if (!n.classValid(clazz)) continue;
            return n;
        }
        return null;
    }

    public static <T> INBTable of(T defaultValue, BiFunction<NBTTagCompound, String, T> getter, BiConsumer<NBTTagCompound, Pair<String, T>> setter, Class<T> ... classes) {
        return NBTHelper.of(defaultValue, getter, setter, clazz -> Arrays.stream(classes).anyMatch(c -> clazz == c));
    }

    public static <T> INBTable of(final T defaultValue, final BiFunction<NBTTagCompound, String, T> getter, final BiConsumer<NBTTagCompound, Pair<String, T>> setter, final Predicate<Class<T>> pred) {
        return new INBTable<T>(){

            @Override
            public void set(NBTTagCompound nbt, String name, T value) {
                setter.accept(nbt, Pair.of((Object)name, value));
            }

            @Override
            public T get(NBTTagCompound nbt, String name, Class<T> clazz) {
                return getter.apply(nbt, name);
            }

            @Override
            public boolean classValid(Class<T> clazz) {
                return pred.apply(clazz);
            }

            @Override
            public T defaultValue() {
                return defaultValue;
            }
        };
    }

    public static <T> T get(NBTTagCompound nbt, String name, Class<T> clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            Optional<Integer> o = NBTHelper.getSafe(nbt, name, Integer.class);
            return o.isPresent() ? (T)clazz.getEnumConstants()[o.get()] : null;
        }
        NBTType type = NBTType.m.get(clazz);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (nbt == null || !nbt.func_74764_b(name)) {
            return (T)type.defaultValue();
        }
        return (T)type.get(nbt, name, clazz);
    }

    public static <T> Optional<T> getSafe(NBTTagCompound nbt, String name, Class<T> clazz) {
        if (nbt == null || nbt.func_74764_b(name)) {
            return Optional.of(NBTHelper.get(nbt, name, clazz));
        }
        return Optional.empty();
    }

    public static NBTTagCompound set(NBTTagCompound nbt, String name, Object value) {
        if (nbt == null || value == null) {
            return nbt;
        }
        Class<?> clazz = value.getClass();
        if (Enum.class.isAssignableFrom(clazz)) {
            return NBTHelper.set(nbt, name, ((Enum)value).ordinal());
        }
        NBTType type = NBTType.m.get(clazz);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        type.set(nbt, name, value);
        return nbt;
    }

    public static <T> List<T> getList(NBTTagCompound nbt, String name, Class<T> clazz) {
        if (!NBTType.validClass(clazz)) {
            throw new IllegalArgumentException();
        }
        ObjectArrayList values = new ObjectArrayList();
        if (nbt == null || !nbt.func_150297_b(name, 10)) {
            return values;
        }
        NBTTagCompound lis = nbt.func_74775_l(name);
        int size = lis.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            values.add(NBTHelper.get(lis, "__" + i, clazz));
        }
        return values;
    }

    public static <T> Optional<List<T>> getListSafe(NBTTagCompound nbt, String name, Class<T> clazz) {
        if (nbt == null || nbt.func_150297_b(name, 10)) {
            return Optional.of(NBTHelper.getList(nbt, name, clazz));
        }
        return Optional.empty();
    }

    public static NBTTagCompound setList(NBTTagCompound nbt, String name, List<?> values) {
        if (nbt == null || values.isEmpty()) {
            return nbt;
        }
        for (Object o : values) {
            if (o == null) continue;
            if (NBTType.validClass(o.getClass())) break;
            throw new IllegalArgumentException();
        }
        NBTTagCompound lis = new NBTTagCompound();
        lis.func_74768_a("size", values.size());
        for (int i = 0; i < values.size(); ++i) {
            NBTHelper.set(lis, "__" + i, values.get(i));
        }
        nbt.func_74782_a(name, (NBTBase)lis);
        return nbt;
    }

    public static <K, V> Map<K, V> getMap(NBTTagCompound nbt, String name, Class<K> keyClazz, Class<V> valClazz) {
        if (!NBTType.validClass(keyClazz) || !NBTType.validClass(valClazz)) {
            throw new IllegalArgumentException();
        }
        Object2ObjectOpenHashMap values = new Object2ObjectOpenHashMap();
        if (nbt == null || !nbt.func_150297_b(name, 10)) {
            return values;
        }
        NBTTagCompound map = nbt.func_74775_l(name);
        List<K> keys = NBTHelper.getList(map, "key", keyClazz);
        List<V> vals = NBTHelper.getList(map, "value", valClazz);
        Validate.isTrue((keys.size() == vals.size() ? 1 : 0) != 0);
        for (int i = 0; i < keys.size(); ++i) {
            values.put(keys.get(i), vals.get(i));
        }
        return values;
    }

    public static <K, V> Optional<Map<K, V>> getMapSafe(NBTTagCompound nbt, String name, Class<K> keyClazz, Class<V> valClazz) {
        if (nbt == null || nbt.func_150297_b(name, 10)) {
            return Optional.of(NBTHelper.getMap(nbt, name, keyClazz, valClazz));
        }
        return Optional.empty();
    }

    public static NBTTagCompound setMap(NBTTagCompound nbt, String name, Map<?, ?> values) {
        if (nbt == null || values.isEmpty()) {
            return nbt;
        }
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<?, ?> o : values.entrySet()) {
            if (!NBTType.validClass(o.getKey().getClass()) || !NBTType.validClass(o.getValue().getClass())) {
                throw new IllegalArgumentException();
            }
            entries.add(o);
        }
        NBTTagCompound map = new NBTTagCompound();
        NBTHelper.setList(map, "key", entries.stream().map(e -> e.getKey()).collect(Collectors.toList()));
        NBTHelper.setList(map, "value", entries.stream().map(e -> e.getValue()).collect(Collectors.toList()));
        nbt.func_74782_a(name, (NBTBase)map);
        return nbt;
    }

    static {
        NBTHelper.register(new INBTable<Enum>(){

            @Override
            public void set(NBTTagCompound nbt, String name, Enum value) {
                nbt.func_74768_a(name, value.ordinal());
            }

            @Override
            public Enum<?> get(NBTTagCompound nbt, String name, Class<Enum> clazz) {
                return clazz.getEnumConstants()[nbt.func_74762_e(name)];
            }

            @Override
            public boolean classValid(Class<Enum> clazz) {
                return Enum.class.isAssignableFrom(clazz);
            }
        });
        NBTHelper.register(new INBTable<IForgeRegistryEntry>(){

            @Override
            public void set(NBTTagCompound nbt, String name, IForgeRegistryEntry value) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74778_a("id", value.getRegistryName().toString());
                entry.func_74778_a("class", value.getRegistryType().getCanonicalName());
                nbt.func_74782_a(name, (NBTBase)entry);
            }

            @Override
            public IForgeRegistryEntry get(NBTTagCompound nbt, String name, Class<IForgeRegistryEntry> clazz) {
                NBTTagCompound entry = nbt.func_74775_l(name);
                String id = entry.func_74779_i("id");
                String clas = entry.func_74779_i("class");
                try {
                    IForgeRegistry reg = GameRegistry.findRegistry(Class.forName(clas));
                    if (reg != null) {
                        return reg.getValue(new ResourceLocation(id));
                    }
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return null;
            }

            @Override
            public boolean classValid(Class<IForgeRegistryEntry> clazz) {
                return IForgeRegistryEntry.class.isAssignableFrom(clazz);
            }
        });
    }

    private static enum NBTType {
        BOOLEAN(false, (n, s) -> n.func_74767_n(s), (n, p) -> n.func_74757_a((String)p.getKey(), ((Boolean)p.getValue()).booleanValue()), Boolean.class, Boolean.TYPE),
        BYTE((byte)0, (n, s) -> n.func_74771_c(s), (n, p) -> n.func_74774_a((String)p.getKey(), ((Byte)p.getValue()).byteValue()), Byte.class, Byte.TYPE),
        SHORT((short)0, (n, s) -> n.func_74765_d(s), (n, p) -> n.func_74777_a((String)p.getKey(), ((Short)p.getValue()).shortValue()), Short.class, Short.TYPE),
        INT(0, (n, s) -> n.func_74762_e(s), (n, p) -> n.func_74768_a((String)p.getKey(), ((Integer)p.getValue()).intValue()), Integer.class, Integer.TYPE),
        LONG(0L, (n, s) -> n.func_74763_f(s), (n, p) -> n.func_74772_a((String)p.getKey(), ((Long)p.getValue()).longValue()), Long.class, Long.TYPE),
        FLOAT(Float.valueOf(0.0f), (n, s) -> Float.valueOf(n.func_74760_g(s)), (n, p) -> n.func_74776_a((String)p.getKey(), ((Float)p.getValue()).floatValue()), Float.class, Float.TYPE),
        DOUBLE(0.0, (n, s) -> n.func_74769_h(s), (n, p) -> n.func_74780_a((String)p.getKey(), ((Double)p.getValue()).doubleValue()), Double.class, Double.TYPE),
        STRING(null, (n, s) -> n.func_74779_i(s), (n, p) -> n.func_74778_a((String)p.getKey(), (String)p.getValue()), String.class),
        NBT(null, (n, s) -> n.func_74775_l(s), (n, p) -> n.func_74782_a((String)p.getKey(), (NBTBase)((NBTTagCompound)p.getValue())), NBTTagCompound.class),
        ITEMSTACK(ItemStack.field_190927_a, (n, s) -> new ItemStack(n.func_74775_l(s)), (n, p) -> n.func_74782_a((String)p.getKey(), (NBTBase)((ItemStack)p.getValue()).func_77955_b(new NBTTagCompound())), ItemStack.class),
        BLOCKPOS(null, (n, s) -> BlockPos.func_177969_a((long)n.func_74763_f(s)), (n, p) -> n.func_74772_a((String)p.getKey(), ((BlockPos)p.getValue()).func_177986_g()), BlockPos.class, BlockPos.MutableBlockPos.class),
        FLUIDSTACK(null, (n, s) -> FluidStack.loadFluidStackFromNBT((NBTTagCompound)n.func_74775_l(s)), (n, p) -> n.func_74782_a((String)p.getKey(), (NBTBase)((FluidStack)p.getValue()).writeToNBT(new NBTTagCompound())), FluidStack.class);

        Object defaultValue;
        Class<?>[] classes;
        BiFunction<NBTTagCompound, String, Object> getter;
        BiConsumer<NBTTagCompound, Pair<String, Object>> setter;
        public static Map<Class<?>, NBTType> m;

        private NBTType(Object defaultValue, BiFunction<NBTTagCompound, String, Object> getter, BiConsumer<NBTTagCompound, Pair<String, Object>> setter, Class<?> ... classes) {
            this.defaultValue = defaultValue;
            this.classes = classes;
            this.getter = getter;
            this.setter = setter;
        }

        public static boolean validClass(Class<?> clazz) {
            return Enum.class.isAssignableFrom(clazz) || m.get(clazz) != null;
        }

        public void set(NBTTagCompound nbt, String name, Object value) {
            this.setter.accept(nbt, (Pair<String, Object>)Pair.of((Object)name, (Object)value));
        }

        public Object get(NBTTagCompound nbt, String name, Class<?> clazz) {
            return this.getter.apply(nbt, name);
        }

        public boolean classValid(Class<?> clazz) {
            return m.get(clazz) != null;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        static {
            m = new HashMap();
            for (NBTType n2 : NBTType.values()) {
                for (Class<?> c : n2.classes) {
                    m.put(c, n2);
                }
            }
        }
    }

    public static interface INBTable<T> {
        public void set(NBTTagCompound var1, String var2, T var3);

        public T get(NBTTagCompound var1, String var2, Class<T> var3);

        public boolean classValid(Class<T> var1);

        default public T defaultValue() {
            return null;
        }

        default public Map<?, ?> getEmptyMap() {
            return new Object2ObjectOpenHashMap();
        }

        default public List<?> getEmptyList() {
            return new ObjectArrayList();
        }
    }
}

