/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import java.util.List;
import java.util.function.Predicate;
import mrriegel.limelib.helper.StackHelper;
import mrriegel.limelib.util.StackWrapper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InvHelper {
    public static boolean hasItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || tile instanceof IInventory;
    }

    public static boolean hasItemHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.hasItemHandler(world.func_175625_s(pos), side);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static IItemHandler getItemHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.getItemHandler(world.func_175625_s(pos), side);
    }

    public static ItemStack insert(TileEntity tile, ItemStack stack, EnumFacing side) {
        if (tile == null) {
            return stack;
        }
        IItemHandler inv = InvHelper.getItemHandler(tile, side);
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
    }

    public static int canInsert(IItemHandler inv, ItemStack stack) {
        if (inv == null || stack.func_190926_b()) {
            return 0;
        }
        ItemStack s = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true);
        int rest = s.func_190916_E();
        return stack.func_190916_E() - rest;
    }

    public static boolean contains(IItemHandler inv, Predicate<ItemStack> pred) {
        if (inv == null) {
            return false;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!pred.test(inv.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    public static int getAmount(IItemHandler inv, Predicate<ItemStack> pred) {
        if (inv == null || pred == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (!pred.test(slot)) continue;
            amount += slot.func_190916_E();
        }
        return amount;
    }

    public static ItemStack extractItem(IItemHandler inv, Predicate<ItemStack> pred, int num, boolean simulate) {
        if (inv == null || pred == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = ItemStack.field_190927_a;
        int missing = num;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!pred.test(slot) || (ex = inv.extractItem(i, missing, simulate)).func_190926_b()) continue;
            if (extracted.func_190926_b()) {
                extracted = ex.func_77946_l();
            } else {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)extracted, (ItemStack)ex)) continue;
                extracted.func_190917_f(ex.func_190916_E());
            }
            if ((missing -= ex.func_190916_E()) != 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)ex, (int)num);
        }
        return extracted;
    }

    public static boolean transfer(IItemHandler from, IItemHandler to, int amount, Predicate<ItemStack> pred) {
        for (int i = 0; i < from.getSlots(); ++i) {
            int ins;
            ItemStack st = from.extractItem(i, amount, true);
            if (st.func_190926_b() || !pred.test(st) || (ins = st.func_190916_E() - ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)st, (boolean)true).func_190916_E()) == 0) continue;
            ItemStack ex = from.extractItem(i, Math.min(amount, ins), false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)ex, (boolean)false);
            return true;
        }
        return false;
    }

    public static IInventory toInventory(final IItemHandler handler) {
        return new InventoryBasic("Null", false, handler.getSlots()){

            public int func_70302_i_() {
                return handler.getSlots();
            }

            public boolean func_191420_l() {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (this.func_70301_a(i).func_190926_b()) continue;
                    return false;
                }
                return true;
            }

            public ItemStack func_70301_a(int index) {
                return handler.getStackInSlot(index);
            }

            public ItemStack func_70298_a(int index, int count) {
                if (handler instanceof IItemHandlerModifiable) {
                    ItemStack s = ItemHandlerHelper.copyStackWithSize((ItemStack)this.func_70301_a(index), (int)Math.min(count, this.func_70301_a(index).func_190916_E()));
                    ItemStack k = this.func_70301_a(count).func_77946_l();
                    k.func_190918_g(s.func_190916_E());
                    ((IItemHandlerModifiable)handler).setStackInSlot(index, k);
                    return s;
                }
                return handler.extractItem(index, count, false);
            }

            public ItemStack func_70304_b(int index) {
                if (handler instanceof IItemHandlerModifiable) {
                    ItemStack s = handler.getStackInSlot(index).func_77946_l();
                    ((IItemHandlerModifiable)handler).setStackInSlot(index, ItemStack.field_190927_a);
                    return s;
                }
                return handler.extractItem(index, 64, false);
            }

            public void func_70299_a(int index, ItemStack stack) {
                if (handler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(index, stack);
                } else {
                    this.func_70304_b(index);
                    handler.insertItem(index, stack, false);
                }
            }

            public int func_70297_j_() {
                int max = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    max = Math.max(max, handler.getSlotLimit(i));
                }
                return max;
            }

            public void func_174888_l() {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    this.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        };
    }

    public static void sort(IItemHandler inv) {
        NonNullList<ItemStack> ex = StackHelper.inv2list(inv);
        List<StackWrapper> wraps = StackWrapper.toWrapperList(ex);
        NonNullList<ItemStack> lis = StackWrapper.toStackList(wraps);
        InvHelper.clear(inv);
        StackHelper.list2inv(lis, inv);
    }

    public static void clear(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            if (inv instanceof IItemHandlerModifiable) {
                ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            inv.extractItem(i, inv.getStackInSlot(i).func_190916_E(), false);
        }
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        return tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.hasFluidHandler(world.func_175625_s(pos), side);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        }
        return null;
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return InvHelper.getFluidHandler(world.func_175625_s(pos), side);
    }

    public static boolean contains(IFluidHandler inv, FluidStack stack) {
        if (inv == null || stack == null) {
            return false;
        }
        for (IFluidTankProperties p : inv.getTankProperties()) {
            if (!stack.isFluidEqual(p.getContents())) continue;
            return true;
        }
        return false;
    }

    public static int getAmount(IFluidHandler inv, FluidStack stack) {
        if (inv == null || stack == null) {
            return 0;
        }
        int amount = 0;
        for (IFluidTankProperties p : inv.getTankProperties()) {
            if (!stack.isFluidEqual(p.getContents())) continue;
            amount += p.getContents().amount;
        }
        return amount;
    }

    public static void clear(IFluidHandler inv) {
        if (inv == null) {
            return;
        }
        for (IFluidTankProperties p : inv.getTankProperties()) {
            if (!p.canDrain()) continue;
            inv.drain(Integer.MAX_VALUE, true);
        }
    }
}

