/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.helper;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import mrriegel.limelib.LimeLib;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static Energy isEnergyContainer(ICapabilityProvider container, EnumFacing side, Energy ... energys) {
        if (container == null) {
            return null;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return Energy.FORGE;
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return Energy.TESLA;
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof IEnergyHandler) {
            return Energy.RF;
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return Energy.RF;
        }
        return null;
    }

    public static Energy isEnergyContainer(ICapabilityProvider container, EnumFacing side) {
        return EnergyHelper.isEnergyContainer(container, side, Energy.values());
    }

    public static long getEnergy(ICapabilityProvider container, EnumFacing side, Energy ... energys) {
        if (container == null) {
            return 0L;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).getEnergyStored();
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return ((ITeslaHolder)container.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)).getStoredPower();
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof IEnergyHandler) {
            return ((IEnergyHandler)container).getEnergyStored(side);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).getEnergyStored((ItemStack)container);
        }
        return 0L;
    }

    public static long getEnergy(ICapabilityProvider container, EnumFacing side) {
        return EnergyHelper.getEnergy(container, side, Energy.values());
    }

    public static long getMaxEnergy(ICapabilityProvider container, EnumFacing side, Energy ... energys) {
        if (container == null) {
            return 0L;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).getMaxEnergyStored();
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)) {
            return ((ITeslaHolder)container.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, side)).getCapacity();
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof IEnergyHandler) {
            return ((IEnergyHandler)container).getMaxEnergyStored(side);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).getMaxEnergyStored((ItemStack)container);
        }
        return 0L;
    }

    public static long getMaxEnergy(ICapabilityProvider container, EnumFacing side) {
        return EnergyHelper.getMaxEnergy(container, side, Energy.values());
    }

    public static long receiveEnergy(ICapabilityProvider container, EnumFacing side, int maxReceive, boolean simulate, Energy ... energys) {
        if (container == null) {
            return 0L;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).receiveEnergy(maxReceive, simulate);
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side)) {
            return ((ITeslaConsumer)container.getCapability(TeslaCapabilities.CAPABILITY_CONSUMER, side)).givePower((long)maxReceive, simulate);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)container).receiveEnergy(side, maxReceive, simulate);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).receiveEnergy((ItemStack)container, maxReceive, simulate);
        }
        return 0L;
    }

    public static long receiveEnergy(ICapabilityProvider container, EnumFacing side, int maxReceive, boolean simulate) {
        return EnergyHelper.receiveEnergy(container, side, maxReceive, simulate, Energy.values());
    }

    public static long extractEnergy(ICapabilityProvider container, EnumFacing side, int maxExtract, boolean simulate, Energy ... energys) {
        if (container == null) {
            return 0L;
        }
        HashSet set = Sets.newHashSet((Object[])energys);
        if (set.contains((Object)Energy.FORGE) && container.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return ((IEnergyStorage)container.getCapability(CapabilityEnergy.ENERGY, side)).extractEnergy(maxExtract, simulate);
        }
        if (set.contains((Object)Energy.TESLA) && LimeLib.teslaLoaded && container.hasCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side)) {
            return ((ITeslaProducer)container.getCapability(TeslaCapabilities.CAPABILITY_PRODUCER, side)).takePower((long)maxExtract, simulate);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof IEnergyProvider) {
            return ((IEnergyProvider)container).extractEnergy(side, maxExtract, simulate);
        }
        if (set.contains((Object)Energy.RF) && LimeLib.fluxLoaded && container instanceof ItemStack && ((ItemStack)container).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)((ItemStack)container).func_77973_b()).extractEnergy((ItemStack)container, maxExtract, simulate);
        }
        return 0L;
    }

    public static long extractEnergy(ICapabilityProvider container, EnumFacing side, int maxExtract, boolean simulate) {
        return EnergyHelper.extractEnergy(container, side, maxExtract, simulate, Energy.values());
    }

    public static enum Energy {
        RF("RF"),
        FORGE("FE"),
        TESLA("Tesla");

        public String unit;

        private Energy(String unit) {
            this.unit = unit;
        }
    }
}

