/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui.element;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.gui.element.GuiElement;
import mrriegel.limelib.gui.element.ITooltip;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.config.GuiUtils;

public abstract class AbstractSlot<T>
extends GuiElement
implements ITooltip {
    public int amount;
    public boolean number;
    public boolean square;
    public boolean smallFont;
    public boolean toolTip;
    public boolean editable;
    public T stack;

    public AbstractSlot(int id, int x, int y, int amount, GuiDrawer drawer, boolean number, boolean square, boolean smallFont, boolean toolTip) {
        super(id, x, y, 18, 18);
        this.amount = amount;
        this.number = number;
        this.square = square;
        this.smallFont = smallFont;
        this.toolTip = toolTip;
    }

    protected List<String> getTooltip(boolean shift) {
        return null;
    }

    public static class FluidSlot
    extends AbstractSlot<FluidStack> {
        public FluidSlot(FluidStack stack, int id, int x, int y, int amount, GuiDrawer drawer, boolean number, boolean square, boolean smallFont, boolean toolTip) {
            super(id, x, y, amount, drawer, number, square, smallFont, toolTip);
            this.stack = stack;
        }

        @Override
        public void drawTooltip(int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            if (this.toolTip && this.stack != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                ScaledResolution sr = new ScaledResolution(this.mc);
                List<String> tips = this.getTooltip(GuiScreen.func_146272_n());
                if (tips != null) {
                    GuiUtils.drawHoveringText(tips, (int)mouseX, (int)mouseY, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)-1, (FontRenderer)this.mc.field_71466_p);
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
            }
        }

        @Override
        protected List<String> getTooltip(boolean shift) {
            return Stream.concat(shift ? Stream.of(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Amount: " + this.amount + " mB") : Stream.empty(), Stream.of(((FluidStack)this.stack).getFluid().getLocalizedName(new FluidStack((FluidStack)this.stack, 1)))).collect(Collectors.toList());
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            if (this.stack != null) {
                GlStateManager.func_179094_E();
                TextureAtlasSprite fluidIcon = this.mc.func_147117_R().getTextureExtry(((FluidStack)this.stack).getFluid().getStill().toString());
                if (fluidIcon == null) {
                    return;
                }
                int color = ((FluidStack)this.stack).getFluid().getColor((FluidStack)this.stack);
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.func_175175_a(this.x, this.y, fluidIcon, 16, 16);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                if (this.number) {
                    String num = "" + (this.amount < 1000 ? this.amount : (this.amount < 1000000 ? this.amount / 1000 : (this.amount < 1000000000 ? this.amount / 1000000 : this.amount / 1000000000)));
                    num = num + (this.amount < 1000 ? "mB" : (this.amount < 1000000 ? "B" : (this.amount < 1000000000 ? "KB" : "MB")));
                    if (this.smallFont) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                        this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, new ItemStack((Item)Items.field_151029_X), this.x * 2 + 16, this.y * 2 + 16, num);
                        GlStateManager.func_179121_F();
                    } else {
                        this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, new ItemStack((Item)Items.field_151029_X), this.x, this.y, num);
                    }
                }
            }
            if (this.square && this.isMouseOver(mouseX, mouseY)) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                int j1 = this.x;
                int k1 = this.y;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }

        @Override
        public void onClick(int button) {
            if (this.editable) {
                FluidStack s = FluidUtil.getFluidContained((ItemStack)this.mc.field_71439_g.field_71071_by.func_70445_o());
                this.stack = s != null && s.getFluid() != null ? s.copy() : null;
            }
        }
    }

    public static class ItemSlot
    extends AbstractSlot<ItemStack> {
        public ItemSlot(ItemStack stack, int id, int x, int y, int amount, GuiDrawer drawer, boolean number, boolean square, boolean smallFont, boolean toolTip) {
            super(id, x, y, amount, drawer, number, square, smallFont, toolTip);
            this.stack = stack;
        }

        @Override
        public void drawTooltip(int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            if (this.toolTip && !((ItemStack)this.stack).func_190926_b()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                ScaledResolution sr = new ScaledResolution(this.mc);
                NBTTagCompound n = ((ItemStack)this.stack).func_77942_o() ? ((ItemStack)this.stack).func_77978_p().func_74737_b() : null;
                List<String> tips = this.getTooltip(GuiScreen.func_146272_n());
                if (tips != null) {
                    GuiUtils.drawHoveringText(tips, (int)mouseX, (int)mouseY, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)-1, (FontRenderer)this.mc.field_71466_p);
                }
                ((ItemStack)this.stack).func_77982_d(n);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
            }
        }

        @Override
        protected List<String> getTooltip(boolean shift) {
            return Stream.concat(shift ? Stream.of(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + "Amount: " + this.amount) : Stream.empty(), GuiDrawer.getTooltip((ItemStack)this.stack).stream()).collect(Collectors.toList());
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            GlStateManager.func_179094_E();
            if (!((ItemStack)this.stack).func_190926_b()) {
                String num;
                RenderHelper.func_74520_c();
                this.mc.func_175599_af().func_180450_b((ItemStack)this.stack, this.x, this.y);
                String string = this.amount < 1000 ? String.valueOf(this.amount) : (num = this.amount < 1000000 ? this.amount / 1000 + "K" : this.amount / 1000000 + "M");
                if (this.number) {
                    if (this.smallFont) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                        this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, (ItemStack)this.stack, this.x * 2 + 16, this.y * 2 + 16, num);
                        GlStateManager.func_179121_F();
                    } else {
                        this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, (ItemStack)this.stack, this.x, this.y, num);
                    }
                }
            }
            if (this.square && this.isMouseOver(mouseX, mouseY)) {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(this.x, this.y, this.x + 16, this.y + 16, -2130706433, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            GlStateManager.func_179121_F();
        }

        @Override
        public void onClick(int button) {
            if (this.editable) {
                this.stack = this.mc.field_71439_g.field_71071_by.func_70445_o();
            }
        }
    }
}

