/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiDrawer {
    public static final ResourceLocation COMMON_TEXTURES = new ResourceLocation("limelib:textures/gui/base.png");
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    public float zLevel = 0.0f;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static FontRenderer uni;
    private static FontRenderer notUni;

    public GuiDrawer(int guiLeft, int guiTop, int xSize, int ySize, float zLevel) {
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zLevel = zLevel;
    }

    public void drawSlot(int x, int y) {
        this.drawSizedSlot(x, y, 18);
    }

    public void drawSizedSlot(int x, int y, int size) {
        this.drawFramedRectangle(x, y, size, size);
    }

    public void drawPlayerSlots(int x, int y) {
        this.drawSlots(x, y + 58, 9, 1);
        this.drawSlots(x, y, 9, 3);
    }

    public void drawSlots(int x, int y, int width, int height) {
        for (int k = 0; k < height; ++k) {
            for (int i = 0; i < width; ++i) {
                this.drawSlot(x + i * 18, y + k * 18);
            }
        }
    }

    public void drawScrollbar(int x, int y, int length, float percent, Direction dir) {
        int width = dir.isHorizontal() ? length : 10;
        int height = dir.isHorizontal() ? 10 : length;
        this.drawFramedRectangle(x, y, width, height);
        if (!dir.isHorizontal()) {
            new GuiButtonExt(0, x + this.guiLeft + 1, y + this.guiTop + 1 + (int)(percent * (float)(length - 10)), 8, 8, "").func_191745_a(mc, GuiDrawer.getMouseX(), GuiDrawer.getMouseY(), mc.func_193989_ak());
        } else {
            new GuiButtonExt(0, x + this.guiLeft + 1 + (int)(percent * (float)(length - 10)), y + this.guiTop + 1, 8, 8, "").func_191745_a(mc, GuiDrawer.getMouseX(), GuiDrawer.getMouseY(), mc.func_193989_ak());
        }
    }

    public void drawTextfield(int x, int y, int width) {
        this.drawFramedRectangle(x, y, width, 12);
    }

    public void drawTextfield(GuiTextField textfield) {
        if (!textfield.func_146181_i()) {
            this.drawTextfield(textfield.field_146209_f - this.guiLeft - 2, textfield.field_146210_g - this.guiTop - 2, textfield.field_146218_h + 9);
        }
    }

    public void drawFramedRectangle(int x, int y, int width, int height) {
        this.bindTexture();
        GuiUtils.drawContinuousTexturedBox((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)0, (int)0, (int)width, (int)height, (int)18, (int)18, (int)1, (float)this.zLevel);
    }

    public void drawBackgroundTexture(int x, int y, int width, int height) {
        this.bindTexture();
        GuiUtils.drawContinuousTexturedBox((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)0, (int)18, (int)width, (int)height, (int)18, (int)18, (int)4, (float)this.zLevel);
    }

    public void drawBackgroundTexture(int x, int y) {
        this.drawBackgroundTexture(x, y, this.xSize, this.ySize);
    }

    public void drawBackgroundTexture() {
        this.drawBackgroundTexture(0, 0);
    }

    public void drawColoredRectangle(int x, int y, int width, int height, int color) {
        GuiUtils.drawGradientRect((int)((int)this.zLevel), (int)(x + this.guiLeft), (int)(y + this.guiTop), (int)(x + width + this.guiLeft), (int)(y + height + this.guiTop), (int)color, (int)color);
    }

    public void drawFrame(int x, int y, int width, int height, int frame, int color) {
        this.drawColoredRectangle(x, y, width, frame, color);
        this.drawColoredRectangle(x, y + 1, frame, height, color);
        this.drawColoredRectangle(x + 1, y + height - (frame - 1), width, frame, color);
        this.drawColoredRectangle(x + width - (frame - 1), y, frame, height, color);
    }

    public void drawEnergyBarV(int x, int y, int height, float percent) {
        int i;
        this.bindTexture();
        for (i = 0; i < height + 1; ++i) {
            if (i % 2 == 0) {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop + i), (int)0, (int)36, (int)8, (int)1, (float)this.zLevel);
                continue;
            }
            GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop + i), (int)0, (int)37, (int)8, (int)1, (float)this.zLevel);
        }
        i = 0;
        while ((float)i < (float)(height + 1) * (1.0f - percent)) {
            if (i % 2 == 0) {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop + i), (int)0, (int)38, (int)8, (int)1, (float)this.zLevel);
            } else {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop + i), (int)0, (int)39, (int)8, (int)1, (float)this.zLevel);
            }
            ++i;
        }
    }

    public void drawEnergyBarH(int x, int y, int width, float percent) {
        int i;
        this.bindTexture();
        for (i = 0; i < width + 1; ++i) {
            if (i % 2 == 0) {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft + i), (int)(y + this.guiTop), (int)8, (int)36, (int)1, (int)8, (float)this.zLevel);
                continue;
            }
            GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft + i), (int)(y + this.guiTop), (int)9, (int)36, (int)1, (int)8, (float)this.zLevel);
        }
        i = 0;
        while ((float)i < (float)(width + 1) * percent) {
            if (i % 2 == 0) {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft + i), (int)(y + this.guiTop), (int)10, (int)36, (int)1, (int)8, (float)this.zLevel);
            } else {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft + i), (int)(y + this.guiTop), (int)11, (int)36, (int)1, (int)8, (float)this.zLevel);
            }
            ++i;
        }
    }

    public void drawFluidRect(int x, int y, int width, int height, FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        TextureAtlasSprite icon = mc.func_147117_R().getTextureExtry(fluid.getFluid().getStill().toString());
        if (icon == null) {
            return;
        }
        x += this.guiLeft;
        int renderAmount = Math.max(height, 1);
        int posY = (y += this.guiTop) + height - renderAmount;
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GlStateManager.func_179147_l();
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = x + i;
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
    }

    public void drawItemStack(ItemStack stack, int x, int y) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        mc.func_175599_af().func_180450_b(stack, x + this.guiLeft, y + this.guiTop);
        GlStateManager.func_179121_F();
    }

    public void drawProgressArrow(int x, int y, float percent, Direction d) {
        this.bindTexture();
        int totalLength = 22;
        int currentLength = (int)((float)totalLength * percent);
        switch (d) {
            case DOWN: {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)93, (int)0, (int)15, (int)22, (float)this.zLevel);
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)108, (int)0, (int)16, (int)currentLength, (float)this.zLevel);
                break;
            }
            case LEFT: {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)40, (int)0, (int)22, (int)15, (float)this.zLevel);
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft + (totalLength - currentLength)), (int)(y + this.guiTop), (int)(40 + (totalLength - currentLength)), (int)15, (int)currentLength, (int)16, (float)this.zLevel);
                break;
            }
            case RIGHT: {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)18, (int)0, (int)22, (int)15, (float)this.zLevel);
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)18, (int)15, (int)currentLength, (int)16, (float)this.zLevel);
                break;
            }
            case UP: {
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)78, (int)0, (int)15, (int)22, (float)this.zLevel);
                GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft - 1), (int)(y + this.guiTop + (totalLength - currentLength)), (int)62, (int)(0 + (totalLength - currentLength)), (int)16, (int)currentLength, (float)this.zLevel);
            }
        }
    }

    public void drawFlame(int x, int y, float percent) {
        this.bindTexture();
        GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)24, (int)31, (int)13, (int)13, (float)this.zLevel);
        int totalHeight = 13;
        int currentHeight = (int)((float)totalHeight * percent);
        GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop + (totalHeight - currentHeight)), (int)37, (int)(31 + (totalHeight - currentHeight)), (int)13, (int)13, (float)this.zLevel);
    }

    public void drawStopSign(int x, int y) {
        this.bindTexture();
        GuiUtils.drawTexturedModalRect((int)(x + this.guiLeft), (int)(y + this.guiTop), (int)12, (int)36, (int)12, (int)12, (float)this.zLevel);
    }

    private void bindTexture() {
        mc.func_110434_K().func_110577_a(COMMON_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int getMouseX() {
        return Mouse.getX() * new ScaledResolution(mc).func_78326_a() / GuiDrawer.mc.field_71443_c;
    }

    public static int getMouseY() {
        ScaledResolution sr = new ScaledResolution(mc);
        return sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / GuiDrawer.mc.field_71440_d - 1;
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        List<String> list = GuiDrawer.getTooltip(stack);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        ScaledResolution sr = new ScaledResolution(mc);
        GuiUtils.drawHoveringText(list, (int)x, (int)y, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)-1, (FontRenderer)(font == null ? GuiDrawer.mc.field_71466_p : font));
    }

    public static void renderToolTip(List<String> list, int x, int y) {
        ScaledResolution sr = new ScaledResolution(mc);
        GuiUtils.drawHoveringText(list, (int)x, (int)y, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)-1, (FontRenderer)GuiDrawer.mc.field_71466_p);
    }

    public static List<String> getTooltip(ItemStack stack) {
        List list = stack.func_82840_a((EntityPlayer)GuiDrawer.mc.field_71439_g, (ITooltipFlag)(GuiDrawer.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        return list;
    }

    public static void openGui(GuiScreen screen) {
        if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            FMLCommonHandler.instance().showGuiScreen((Object)screen);
        }
    }

    public static FontRenderer getFontRenderer(boolean unicode) {
        if (unicode) {
            if (uni == null) {
                uni = new FontRenderer(GuiDrawer.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), GuiDrawer.mc.field_71446_o, true);
                return uni;
            }
            return uni;
        }
        if (notUni == null) {
            notUni = new FontRenderer(GuiDrawer.mc.field_71474_y, new ResourceLocation("textures/font/ascii.png"), GuiDrawer.mc.field_71446_o, false);
            return notUni;
        }
        return notUni;
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;


        public boolean isHorizontal() {
            return this == RIGHT || this == LEFT;
        }
    }
}

