/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mrriegel.limelib.gui.CommonContainer;
import mrriegel.limelib.helper.NBTStackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonContainerItem
extends CommonContainer<ItemStack> {
    protected ItemStack stack;
    boolean inited = true;

    public CommonContainerItem(InventoryPlayer invPlayer, int num) {
        super(invPlayer, invPlayer.func_70448_g(), Pair.of((Object)"inv", (Object)new InventoryBasic(null, false, num)));
    }

    protected void setStack(EntityPlayer player) {
        this.stack = player.field_71071_by.func_70448_g();
    }

    protected IInventory getItemInventory() {
        return (IInventory)this.invs.get("inv");
    }

    @Override
    protected void modifyInvs() {
        this.setStack(this.getPlayer());
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        this.readFromStack();
        super.modifyInvs();
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.inited) {
            this.writeToStack();
        }
    }

    public void writeToStack() {
        IInventory inv = this.getItemInventory();
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            stacks.add(i, inv.func_70301_a(i));
        }
        NBTStackHelper.setList(this.stack, "items", stacks);
        this.func_75142_b();
    }

    public void readFromStack() {
        List<ItemStack> stacks = NBTStackHelper.getList(this.stack, "items", ItemStack.class);
        IInventory inv = this.getItemInventory();
        inv.func_174888_l();
        for (int i = 0; i < Math.min(inv.func_70302_i_(), stacks.size()); ++i) {
            inv.func_70299_a(i, stacks.get(i));
        }
        this.invs.put("inv", inv);
        this.func_75142_b();
    }
}

