/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mrriegel.limelib.gui.slot.CommonSlot;
import mrriegel.limelib.gui.slot.SlotGhost;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class CommonContainer<T>
extends Container {
    protected InventoryPlayer invPlayer;
    protected Map<String, IInventory> invs;
    protected T save;

    public CommonContainer(InventoryPlayer invPlayer, T save, Pair<String, IInventory> ... invs) {
        this.invPlayer = invPlayer;
        this.invs = Maps.newHashMap();
        this.save = save;
        if (invs != null) {
            for (Pair<String, IInventory> e : invs) {
                if (e == null) continue;
                this.invs.put((String)e.getLeft(), (IInventory)e.getRight());
            }
        }
        this.modifyInvs();
        this.initSlots();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public EntityPlayer getPlayer() {
        return this.invPlayer.field_70458_d;
    }

    protected abstract void initSlots();

    protected void modifyInvs() {
    }

    protected abstract List<Area> allowedSlots(ItemStack var1, IInventory var2, int var3);

    protected List<Area> allowedSlots(ItemStack stack, IItemHandler inv, int index) {
        return null;
    }

    public void update(EntityPlayer player) {
    }

    protected Area getAreaForEntireInv(IInventory inv) {
        return this.getAreaForInv(inv, 0, inv.func_70302_i_());
    }

    protected Area getAreaForEntireInv(IItemHandler inv) {
        return this.getAreaForInv(inv, 0, inv.getSlots());
    }

    protected Area getAreaForInv(Object inv, int start, int total) {
        ArrayList l = Lists.newArrayList();
        for (Slot s : this.field_75151_b) {
            if (!CommonContainer.sameInventory(inv, s) || s.getSlotIndex() < start || s.getSlotIndex() >= total + start) continue;
            l.add(s.getSlotIndex());
        }
        if (l.isEmpty()) {
            return null;
        }
        Collections.sort(l);
        return new Area(inv, (int)((Integer)l.get(0)), (int)((Integer)l.get(l.size() - 1)));
    }

    protected Area getAreaForInv(IInventory inv, int start, int total) {
        return this.getAreaForInv((Object)inv, start, total);
    }

    protected Area getAreaForInv(IItemHandler inv, int start, int total) {
        return this.getAreaForInv((Object)inv, start, total);
    }

    protected List<Slot> getSlotsFor(Object inv) {
        return this.field_75151_b.stream().filter(s -> CommonContainer.sameInventory(inv, s)).collect(Collectors.toList());
    }

    protected void initPlayerSlots(int x, int y) {
        this.initSlots((IInventory)this.invPlayer, x, y + 58, 9, 1, 0);
        this.initSlots((IInventory)this.invPlayer, x, y, 9, 3, 9);
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height, int startIndex, Class<? extends Slot> clazz, Object ... args) {
        if (inv == null) {
            return;
        }
        for (int k = 0; k < height; ++k) {
            int id;
            for (int i = 0; i < width && (id = i + k * width + startIndex) < inv.func_70302_i_(); ++i) {
                Slot slot = null;
                try {
                    ArrayList lis = Lists.newArrayList((Object[])new Object[]{inv, id, x + i * 18, y + k * 18});
                    for (Object o2 : args) {
                        lis.add(o2);
                    }
                    slot = (Slot)ConstructorUtils.invokeConstructor(clazz, (Object[])lis.toArray(new Object[0]), (Class[])((Class[])lis.stream().map(o -> o.getClass()).toArray(Class[]::new)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (slot == null) continue;
                this.func_75146_a(slot);
            }
        }
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height, int startIndex) {
        this.initSlots(inv, x, y, width, height, startIndex, Slot.class, new Object[0]);
    }

    protected void initSlots(IInventory inv, int x, int y, int width, int height) {
        this.initSlots(inv, x, y, width, height, 0);
    }

    protected void initSlots(IItemHandler inv, int x, int y, int width, int height, int startIndex, Class<? extends Slot> clazz, Object ... args) {
        if (inv == null) {
            return;
        }
        for (int k = 0; k < height; ++k) {
            int id;
            for (int i = 0; i < width && (id = i + k * width + startIndex) < inv.getSlots(); ++i) {
                Slot slot = null;
                try {
                    ArrayList lis = Lists.newArrayList((Object[])new Object[]{inv, id, x + i * 18, y + k * 18});
                    for (Object o2 : args) {
                        lis.add(o2);
                    }
                    slot = (Slot)ConstructorUtils.invokeConstructor(clazz, (Object[])lis.toArray(new Object[0]), (Class[])((Class[])lis.stream().map(o -> o.getClass()).toArray(Class[]::new)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (slot == null) continue;
                this.func_75146_a(slot);
            }
        }
    }

    protected void initSlots(IItemHandler inv, int x, int y, int width, int height, int startIndex) {
        this.initSlots(inv, x, y, width, height, startIndex, Slot.class, new Object[0]);
    }

    protected void initSlots(IItemHandler inv, int x, int y, int width, int height) {
        this.initSlots(inv, x, y, width, height, 0);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        if (slot != null && slot.func_75216_d()) {
            List<Area> ar;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            Object inv = CommonContainer.getInv(slot);
            List<Area> list = inv instanceof IInventory ? this.allowedSlots(itemstack1, (IInventory)inv, slot.getSlotIndex()) : (ar = inv instanceof IItemHandler ? this.allowedSlots(itemstack1, (IInventory)inv, index) : null);
            if (ar == null) {
                return ItemStack.field_190927_a;
            }
            ar.removeAll(Collections.singleton(null));
            boolean merged = false;
            for (Area p : ar) {
                Slot minSlot = this.getSlotFromInv(p.inv, p.min);
                Slot maxSlot = this.getSlotFromInv(p.inv, p.max);
                if (minSlot == null || maxSlot == null) continue;
                if (this.hasGhost(p)) {
                    for (int i = p.min; i <= p.max; ++i) {
                        if (this.getSlotFromInv(p.inv, i).func_75216_d() || !(this.getSlotFromInv(p.inv, i) instanceof SlotGhost)) continue;
                        this.getSlotFromInv(p.inv, i).func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)1));
                        this.func_75142_b();
                        return ItemStack.field_190927_a;
                    }
                }
                if (!this.func_75135_a(itemstack1, minSlot.field_75222_d, maxSlot.field_75222_d + 1, false)) continue;
                merged = true;
                slot.func_75220_a(itemstack1, itemstack);
                break;
            }
            if (!merged) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    private boolean merge(ItemStack stack, int startindex, int endindex, boolean reverse) {
        Slot slot;
        int i;
        boolean merged = false;
        int n = i = reverse ? endindex - 1 : startindex;
        while (!stack.func_190926_b() && (reverse ? i >= startindex : i < endindex)) {
            int fit;
            slot = (Slot)this.field_75151_b.get(i);
            ItemStack slotstack = slot.func_75211_c();
            if (!slotstack.func_190926_b() && slot.func_75214_a(stack) && ItemHandlerHelper.canItemStacksStack((ItemStack)slotstack, (ItemStack)stack) && (fit = Math.min(slot.func_178170_b(stack), slotstack.func_77976_d()) - slotstack.func_190916_E()) != 0) {
                fit = Math.min(stack.func_190916_E(), fit);
                slotstack.func_190917_f(fit);
                slot.func_75218_e();
                stack.func_190918_g(fit);
                merged = true;
            }
            i += reverse ? -1 : 1;
        }
        int n2 = i = reverse ? endindex - 1 : startindex;
        while (!stack.func_190926_b() && (reverse ? i >= startindex : i < endindex)) {
            int fit;
            slot = (Slot)this.field_75151_b.get(i);
            if (!slot.func_75216_d() && slot.func_75214_a(stack) && (fit = Math.min(slot.func_178170_b(stack), stack.func_77976_d())) != 0) {
                fit = Math.min(stack.func_190916_E(), fit);
                ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)fit);
                slot.func_75215_d(copy);
                stack.func_190918_g(fit);
                merged = true;
            }
            i += reverse ? -1 : 1;
        }
        return merged;
    }

    public boolean func_75135_a(ItemStack stack, int startindex, int endindex, boolean reverse) {
        return this.merge(stack, startindex, endindex, reverse);
    }

    public Slot getSlotFromInv(Object inv, int slotIn) {
        if (inv instanceof IInventory) {
            return this.func_75147_a((IInventory)inv, slotIn);
        }
        if (!(inv instanceof IItemHandler)) {
            return null;
        }
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot.getSlotIndex() != slotIn || (!(slot instanceof SlotItemHandler) || ((SlotItemHandler)slot).getItemHandler() != inv) && (!(slot instanceof CommonSlot) || ((CommonSlot)slot).getItemHandler() != inv)) continue;
            return slot;
        }
        return null;
    }

    private final boolean hasGhost(Area area) {
        for (int i = area.min; i <= area.max; ++i) {
            if (!(this.getSlotFromInv(area.inv, i) instanceof SlotGhost)) continue;
            return true;
        }
        return false;
    }

    public static boolean sameInventory(Object inv, Slot slot) {
        return inv == CommonContainer.getInv(slot);
    }

    public static Object getInv(Slot slot) {
        if (slot instanceof SlotItemHandler) {
            return ((SlotItemHandler)slot).getItemHandler();
        }
        if (slot instanceof CommonSlot && ((CommonSlot)slot).isItemHandler()) {
            return ((CommonSlot)slot).getItemHandler();
        }
        return slot.field_75224_c;
    }

    protected static class Area {
        Object inv;
        int min;
        int max;

        public Area(Object inv, int min, int max) {
            this.inv = inv;
            this.min = min;
            this.max = max;
        }

        public Area(IInventory inv, int min, int max) {
            this((Object)inv, min, max);
        }

        public Area(IItemHandler inv, int min, int max) {
            this((Object)inv, min, max);
        }

        public String toString() {
            return "Area [inv=" + this.inv + ", min=" + this.min + ", max=" + this.max + "]";
        }
    }
}

