/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.book;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mrriegel.limelib.LimeLib;
import mrriegel.limelib.book.Article;
import mrriegel.limelib.book.Book;
import mrriegel.limelib.book.Chapter;
import mrriegel.limelib.gui.CommonGuiScreen;
import mrriegel.limelib.gui.GuiDrawer;
import mrriegel.limelib.gui.button.CommonGuiButton;
import mrriegel.limelib.gui.element.AbstractSlot;
import mrriegel.limelib.helper.ColorHelper;
import mrriegel.limelib.plugin.JEI;
import mrriegel.limelib.util.Utils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Mouse;

public class GuiBook
extends CommonGuiScreen {
    protected Book book;
    protected CommonGuiButton left;
    protected CommonGuiButton right;
    private static final int maxLines = 17;
    private static final int maxSubChapters = 11;
    protected List<GuiButton> articleButtons = Lists.newArrayList();
    protected String currentText;
    protected int maxPage = 1;
    protected int currentPage = 1;
    protected int articlePos = 0;
    protected int chapter = -1;
    protected int article = -1;
    protected Chapter currentChapter;
    protected Article currentArticle;
    protected List<AbstractSlot.ItemSlot> slots = Lists.newArrayList();
    protected final boolean unicode = false;

    public GuiBook(Book book) {
        this.book = book;
        this.xSize = 340;
        this.ySize = 200;
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(Utils.getCurrentModID());
        this.currentText = TextFormatting.BOLD + mod.getName() + " - " + mod.getVersion() + "\n\n" + "1.12.2";
    }

    public GuiBook(Book book, int chapter, int article) {
        this(book);
        this.chapter = chapter;
        this.article = article;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        int index;
        this.drawer.drawBackgroundTexture();
        this.drawer.drawFramedRectangle(5, 5, 50, this.ySize - 10);
        this.drawer.drawFramedRectangle(57, 5, 50, this.ySize - 10);
        this.drawer.drawFrame(109, 5, 225, this.ySize - 26, 1, Color.BLACK.getRGB());
        this.drawer.drawFrame(110, 6, 223, this.ySize - 28, 1, Color.DARK_GRAY.getRGB());
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        this.drawer.drawColoredRectangle(111, 7, 222, this.ySize - 29, ColorHelper.brighter(16765851, 0.22));
        String pages = this.currentPage + "/" + this.maxPage;
        this.func_73731_b(this.field_146289_q, pages, this.guiLeft + (218 - this.field_146289_q.func_78256_a(pages) / 2), this.guiTop + 185, 0xE0E0E0);
        List wrappedTextLines = this.field_146289_q.func_78271_c(this.currentText, 215);
        this.maxPage = wrappedTextLines.size() / 17;
        if (wrappedTextLines.size() % 17 != 0) {
            ++this.maxPage;
        }
        for (int i = 0; i < Math.min(wrappedTextLines.size(), 17) && (index = i + (this.currentPage - 1) * 17) < wrappedTextLines.size(); ++i) {
            this.field_146289_q.func_175065_a((String)wrappedTextLines.get(index), (float)(this.guiLeft + 113), (float)(this.guiTop + 9 + i * 10), 0x111111, false);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean uni = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(false);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146289_q.func_78264_a(uni);
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.left = new CommonGuiButton(0, this.guiLeft + 109, this.guiTop + 181, 9, 14, "<").setDesign(CommonGuiButton.Design.SIMPLE);
        this.field_146292_n.add(this.left);
        this.right = new CommonGuiButton(1, this.guiLeft + 326, this.guiTop + 181, 9, 14, ">").setDesign(CommonGuiButton.Design.SIMPLE);
        this.field_146292_n.add(this.right);
        for (i = 0; i < 10; ++i) {
            this.slots.add(new AbstractSlot.ItemSlot(ItemStack.field_190927_a, i, 0, this.guiTop + 8, 1, this.drawer, false, false, false, true));
        }
        this.elementList.addAll(this.slots);
        for (i = 0; i < this.book.chapters.size(); ++i) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{this.book.chapters.get((int)i).name});
            for (Article c : this.book.chapters.get((int)i).articles) {
                tooltip.add(TextFormatting.GRAY + "  " + c.getName());
            }
            tooltip.clear();
            this.field_146292_n.add(new CommonGuiButton(i + 100, this.guiLeft + 7, this.guiTop + 7 + i * 18, 46, 15, this.book.chapters.get((int)i).name).setTooltip(tooltip).setDesign(CommonGuiButton.Design.SIMPLE));
        }
        for (i = 0; i < 11; ++i) {
            CommonGuiButton b = new CommonGuiButton(i + 1000, this.guiLeft + 59, this.guiTop + 7 + i * 17, 46, 14, "").setDesign(CommonGuiButton.Design.SIMPLE);
            b.field_146125_m = false;
            this.articleButtons.add((GuiButton)b);
        }
        this.field_146292_n.addAll(this.articleButtons);
        this.openLast();
    }

    private void openLast() {
        if (this.chapter != -1 && this.article != -1) {
            this.articlePos = 0;
            this.currentChapter = this.book.chapters.get(this.chapter);
            this.initArticleButtons();
            this.currentArticle = this.currentChapter.articles.get(this.article);
            this.currentText = this.formatText();
            this.chapter = -1;
            this.initSlots();
        } else {
            if (this.book.lastChapter != null) {
                this.articlePos = 0;
                this.currentChapter = this.book.lastChapter;
                this.initArticleButtons();
            }
            if (this.book.lastArticle != null) {
                this.currentArticle = this.book.lastArticle;
                this.currentText = this.formatText();
                this.currentPage = this.book.lastPage;
                this.initSlots();
            }
        }
    }

    private String formatText() {
        String s = TextFormatting.BOLD + this.currentArticle.getName() + TextFormatting.RESET + "\n\n" + I18n.func_135052_a((String)this.currentArticle.text, (Object[])new Object[0]);
        s = s.replaceAll("<r>", TextFormatting.RESET.toString());
        s = s.replaceAll("<b>", TextFormatting.BOLD.toString());
        s = s.replaceAll("<i>", TextFormatting.ITALIC.toString());
        s = s.replaceAll("<u>", TextFormatting.UNDERLINE.toString());
        s = s.replaceAll("<s>", TextFormatting.STRIKETHROUGH.toString());
        for (int i = 0; i < TextFormatting.values().length; ++i) {
            s = s.replaceAll("<" + i + ">", TextFormatting.values()[i].toString());
            s = s.replaceAll("<" + TextFormatting.values()[i].func_96297_d() + ">", TextFormatting.values()[i].toString());
        }
        return s;
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        this.book.lastChapter = this.currentChapter != null ? this.currentChapter : null;
        this.book.lastArticle = this.currentArticle != null ? this.currentArticle : null;
        this.book.lastPage = this.currentPage;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Article sc;
        if (button.field_146127_k == 0) {
            this.currentPage = Math.max(1, this.currentPage - 1);
        } else if (button.field_146127_k == 1) {
            this.currentPage = Math.min(this.maxPage, this.currentPage + 1);
        } else if (button.field_146127_k >= 100 && button.field_146127_k <= 999) {
            Chapter c = this.book.chapters.get(button.field_146127_k - 100);
            if (c != null) {
                this.articlePos = 0;
                this.currentChapter = c;
                this.initArticleButtons();
            }
        } else if (button.field_146127_k >= 1000 && button.field_146127_k <= 9999 && this.currentChapter != null && (sc = this.currentChapter.articles.get(button.field_146127_k - 1000 + this.articlePos)) != null) {
            this.currentArticle = sc;
            this.currentText = this.formatText();
            this.currentPage = 1;
        }
        if (this.currentArticle != null) {
            this.initSlots();
        }
    }

    private void initSlots() {
        int i;
        for (i = 0; i < this.slots.size(); ++i) {
            this.slots.get((int)i).stack = ItemStack.field_190927_a;
        }
        if (this.currentPage != 1) {
            return;
        }
        for (i = 0; i < Math.min(this.currentArticle.stacks.size(), this.slots.size()); ++i) {
            this.slots.get((int)i).stack = this.currentArticle.stacks.get(i);
            this.slots.get((int)i).x = this.guiLeft + 114 + i * 17 + this.field_146289_q.func_78256_a(TextFormatting.BOLD + this.currentArticle.getName());
        }
    }

    private void initArticleButtons() {
        for (int i = 0; i < this.articleButtons.size(); ++i) {
            if (i < this.currentChapter.articles.size()) {
                this.articleButtons.get((int)i).field_146125_m = true;
                this.articleButtons.get((int)i).field_146126_j = this.currentChapter.articles.get(i + this.articlePos).getName();
                continue;
            }
            this.articleButtons.get((int)i).field_146125_m = false;
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = GuiDrawer.getMouseX();
        int mouseY = GuiDrawer.getMouseY();
        if (this.currentChapter != null) {
            GuiButton first = this.articleButtons.get(0);
            GuiButton last = this.articleButtons.get(this.articleButtons.size() - 1);
            if (this.isPointInRegion(first.field_146128_h, first.field_146129_i, first.field_146120_f, last.field_146129_i + last.field_146121_g - first.field_146129_i, this.guiLeft + mouseX, this.guiTop + mouseY)) {
                int m = Mouse.getEventDWheel();
                if (m > 0) {
                    this.articlePos = Math.max(0, this.articlePos - 1);
                } else if (m < 0) {
                    this.articlePos = Math.min(Math.max(0, this.currentChapter.articles.size() - 11), this.articlePos + 1);
                }
                this.initArticleButtons();
            }
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!LimeLib.jeiLoaded) {
            return;
        }
        for (AbstractSlot.ItemSlot slot : this.slots) {
            if (((ItemStack)slot.stack).func_190926_b() || !slot.isMouseOver(mouseX, mouseY) || mouseButton != 0 && mouseButton != 1) continue;
            if (mouseButton == 0) {
                JEI.showRecipes((ItemStack)slot.stack);
                break;
            }
            JEI.showUsage((ItemStack)slot.stack);
            break;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

