/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Stream;
import mrriegel.limelib.block.CommonBlock;
import mrriegel.limelib.helper.InvHelper;
import mrriegel.limelib.helper.NBTStackHelper;
import mrriegel.limelib.helper.RecipeHelper;
import mrriegel.limelib.tile.CommonTile;
import mrriegel.limelib.tile.IDataKeeper;
import mrriegel.limelib.util.LimeCapabilities;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class CommonBlockContainer<T extends CommonTile>
extends CommonBlock {
    protected boolean clearRecipe = true;

    public CommonBlockContainer(Material materialIn, String name) {
        super(materialIn, name);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof CommonTile) {
            for (ItemStack stack : ((CommonTile)t).getDroppingItems()) {
                CommonBlockContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack.func_77946_l());
            }
        }
        worldIn.func_175713_t(pos);
        worldIn.func_175666_e(pos, (Block)this);
    }

    @Override
    public void registerBlock() {
        super.registerBlock();
        if (!Stream.of(this.getTile().getConstructors()).anyMatch(c -> c.getParameterCount() == 0)) {
            throw new IllegalStateException(this.getTile() + " needs a public default constructor.");
        }
        GameRegistry.registerTileEntity(this.getTile(), (String)this.func_149739_a());
        if (this.clearRecipe && CommonBlockContainer.isDataKeeper(this.getTile(), null) && !this.getItemBlock().func_77614_k()) {
            final ItemStack result = new ItemStack((Block)this);
            ShapelessRecipes r = new ShapelessRecipes("", NBTStackHelper.set(new ItemStack((Item)this.getItemBlock()), "ClEaR", true), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{RecipeHelper.getIngredient(new ItemStack((Item)this.getItemBlock()))})){

                public ItemStack func_77572_b(InventoryCrafting inv) {
                    return result;
                }
            };
            RecipeHelper.add((IRecipe)r);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            return (TileEntity)this.getTile().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract Class<? extends T> getTile();

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CommonTile) {
            return ((CommonTile)tile).openGUI((EntityPlayerMP)playerIn);
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (CommonBlockContainer.isDataKeeper(null, worldIn.func_175625_s(pos)) && NBTStackHelper.get(stack, "idatakeeper", Boolean.class).booleanValue()) {
            IDataKeeper tile = CommonBlockContainer.getDataKeeper(worldIn.func_175625_s(pos));
            tile.readFromStack(stack);
            ((TileEntity)tile).func_70296_d();
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List lis = super.getDrops(world, pos, state, fortune);
        ItemStack stack = ItemStack.field_190927_a;
        TileEntity t = world.func_175625_s(pos);
        if (CommonBlockContainer.isDataKeeper(null, t) && lis.size() == 1 && ((ItemStack)lis.get(0)).func_77973_b() == Item.func_150898_a((Block)state.func_177230_c())) {
            IDataKeeper tile = CommonBlockContainer.getDataKeeper(t);
            stack = ((ItemStack)lis.get(0)).func_77946_l();
            NBTStackHelper.set(stack, "idatakeeper", true);
            tile.writeToStack(stack);
        }
        return !stack.func_190926_b() ? Lists.newArrayList((Object[])new ItemStack[]{stack}) : lis;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!CommonBlockContainer.isDataKeeper(null, worldIn.func_175625_s(pos))) {
            return;
        }
        List<ItemStack> lis = this.getDrops((IBlockAccess)worldIn, pos, state, 0);
        if (!player.field_71075_bZ.field_75098_d && lis.size() == 1) {
            worldIn.func_175698_g(pos);
            CommonBlockContainer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)lis.get(0));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (player.func_70093_af() && player.field_71075_bZ.field_75098_d && CommonBlockContainer.isDataKeeper(null, world.func_175625_s(pos)) && !stack.func_190926_b()) {
            IDataKeeper tile = CommonBlockContainer.getDataKeeper(world.func_175625_s(pos));
            NBTStackHelper.set(stack, "idatakeeper", true);
            tile.writeToStack(stack);
        }
        return stack;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CommonTile) {
            ((CommonTile)tileentity).neighborChanged(state, blockIn, fromPos);
        }
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        if (this.clearRecipe && NBTStackHelper.get(stack, "ClEaR", Boolean.class).booleanValue()) {
            tooltip.add(TextFormatting.YELLOW + "Clear content");
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return IInventory.class.isAssignableFrom(this.getTile());
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity t = worldIn.func_175625_s(pos);
        if (t instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)t));
        }
        if (t.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return Container.func_94526_b((IInventory)InvHelper.toInventory((IItemHandler)t.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)));
        }
        return 0;
    }

    private static boolean isDataKeeper(Class<? extends TileEntity> c, TileEntity t) {
        if (c != null) {
            return IDataKeeper.class.isAssignableFrom(c);
        }
        if (t != null) {
            return t.hasCapability(LimeCapabilities.datakeeperCapa, null) || t instanceof IDataKeeper;
        }
        return false;
    }

    private static IDataKeeper getDataKeeper(TileEntity t) {
        IDataKeeper dk = null;
        if (t != null) {
            dk = (IDataKeeper)t.getCapability(LimeCapabilities.datakeeperCapa, null);
        }
        if (dk == null) {
            dk = (IDataKeeper)t;
        }
        return dk;
    }
}

