/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mrriegel.limelib.Connect;
import mrriegel.limelib.LimeCommonProxy;
import mrriegel.limelib.LimeConfig;
import mrriegel.limelib.datapart.CapabilityDataPart;
import mrriegel.limelib.helper.RecipeHelper;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.plugin.TOP;
import mrriegel.limelib.tile.IHUDProvider;
import mrriegel.limelib.util.LimeCapabilities;
import mrriegel.limelib.util.ServerData;
import mrriegel.limelib.util.Utils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="limelib", name="LimeLib", version="1.7.12", acceptedMinecraftVersions="[1.12,1.13)")
public class LimeLib {
    @Mod.Instance(value="limelib")
    public static LimeLib INSTANCE;
    public static final String VERSION = "1.7.12";
    public static final String NAME = "LimeLib";
    public static final String MODID = "limelib";
    public static final Logger log;
    @SidedProxy(clientSide="mrriegel.limelib.LimeClientProxy", serverSide="mrriegel.limelib.LimeCommonProxy")
    public static LimeCommonProxy proxy;
    public static boolean wailaLoaded;
    public static boolean jeiLoaded;
    public static boolean teslaLoaded;
    public static boolean topLoaded;
    public static boolean fluxLoaded;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LimeConfig.init(event.getSuggestedConfigurationFile());
        Utils.init();
        CapabilityDataPart.register();
        LimeCapabilities.register();
        wailaLoaded = Loader.isModLoaded((String)"waila");
        jeiLoaded = Loader.isModLoaded((String)"jei");
        teslaLoaded = Loader.isModLoaded((String)"tesla");
        topLoaded = Loader.isModLoaded((String)"theoneprobe");
        fluxLoaded = Loader.isModLoaded((String)"redstoneflux");
        if (RecipeHelper.dev) {
            Connect.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        RecipeHelper.generateConstants();
        if (LimeConfig.commandBlockCreativeTab) {
            Blocks.field_150483_bI.func_149647_a(CreativeTabs.field_78028_d);
            Blocks.field_185777_dd.func_149647_a(CreativeTabs.field_78028_d);
            Blocks.field_185776_dc.func_149647_a(CreativeTabs.field_78028_d);
        }
        if (topLoaded) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)TOP.class.getName());
        }
        if (RecipeHelper.dev) {
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
            Connect.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        try {
            ServerData.start(event.getServer());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        try {
            ServerData.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void attachTile(final AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityFurnace) {
            event.addCapability(new ResourceLocation(MODID, "dd"), new ICapabilityProvider(){
                TileEntityFurnace tile;
                IHUDProvider pro;
                {
                    this.tile = (TileEntityFurnace)event.getObject();
                    this.pro = new IHUDProvider(){

                        @Override
                        public List<String> getData(boolean sneak, EnumFacing facing) {
                            ArrayList lis = Lists.newArrayList();
                            lis.add(TextFormatting.RED + "?~_\u6f2b~%z" + "Burntime: " + tile.func_174887_a_(0));
                            ItemStack in = tile.func_70301_a(0);
                            lis.add("Input: " + (in.func_190926_b() ? "" : in.func_82833_r() + " " + in.func_190916_E() + "x"));
                            ItemStack out = tile.func_70301_a(2);
                            lis.add("Output: " + (out.func_190926_b() ? "" : out.func_82833_r() + " " + out.func_190916_E() + "x"));
                            ItemStack fu = tile.func_70301_a(1);
                            lis.add("Fuel: " + (fu.func_190926_b() ? "" : fu.func_82833_r() + " " + fu.func_190916_E() + "x"));
                            lis.add("?~_\u6f2b~%z" + (sneak ? facing.toString().toUpperCase() : facing.toString().toLowerCase()));
                            return lis;
                        }

                        @Override
                        public Side readingSide() {
                            return Side.SERVER;
                        }

                        @Override
                        public double scale(boolean sneak, EnumFacing facing) {
                            int ticks = FMLClientHandler.instance().getClientPlayerEntity().field_70173_aa;
                            double k = (Math.sin((double)((float)ticks + FMLClientHandler.instance().getClient().func_184121_ak()) / 10.0) + 1.0) / 2.0 + 0.5;
                            if ("".isEmpty()) {
                                return k;
                            }
                            return System.currentTimeMillis() / 350L % 2L == 0L ? 0.99 : 0.97;
                        }

                        @Override
                        public boolean lineBreak(boolean sneak, EnumFacing facing) {
                            return false;
                        }

                        @Override
                        public boolean center(boolean sneak, EnumFacing facing) {
                            return false;
                        }
                    };
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LimeCapabilities.hudproviderCapa;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (this.hasCapability(capability, facing)) {
                        return (T)this.pro;
                    }
                    return null;
                }
            });
        }
    }

    static {
        log = LogManager.getLogger((String)NAME);
    }
}

