/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketDynamicInventory
extends PacketBase {
    private int type;
    private Object[] data;
    private ItemStack[] stacks;

    public PacketDynamicInventory() {
    }

    public PacketDynamicInventory(Entity entity) {
        super(GCCoreUtil.getDimensionID(entity.field_70170_p));
        assert (entity instanceof IInventory) : "Entity does not implement " + IInventory.class.getSimpleName();
        this.type = 0;
        this.data = new Object[]{entity.func_145782_y()};
        this.stacks = new ItemStack[((IInventory)entity).func_70302_i_()];
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = ((IInventory)entity).func_70301_a(i);
        }
    }

    public PacketDynamicInventory(TileEntity chest) {
        super(GCCoreUtil.getDimensionID(chest.func_145831_w()));
        assert (chest instanceof IInventory) : "Tile does not implement " + IInventory.class.getSimpleName();
        this.type = 1;
        this.data = new Object[]{chest.func_174877_v()};
        this.stacks = new ItemStack[((IInventory)chest).func_70302_i_()];
        for (int i = 0; i < this.stacks.length; ++i) {
            this.stacks[i] = ((IInventory)chest).func_70301_a(i);
        }
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type);
        switch (this.type) {
            case 0: {
                buffer.writeInt(((Integer)this.data[0]).intValue());
                break;
            }
            case 1: {
                buffer.writeInt(((BlockPos)this.data[0]).func_177958_n());
                buffer.writeInt(((BlockPos)this.data[0]).func_177956_o());
                buffer.writeInt(((BlockPos)this.data[0]).func_177952_p());
            }
        }
        buffer.writeInt(this.stacks.length);
        for (int i = 0; i < this.stacks.length; ++i) {
            try {
                NetworkUtil.writeItemStack(this.stacks[i], buffer);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = buffer.readInt();
        switch (this.type) {
            case 0: {
                this.data = new Object[1];
                this.data[0] = buffer.readInt();
                break;
            }
            case 1: {
                this.data = new Object[3];
                this.data[0] = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        }
        this.stacks = new ItemStack[buffer.readInt()];
        for (int i = 0; i < this.stacks.length; ++i) {
            try {
                this.stacks[i] = NetworkUtil.readItemStack(buffer);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p == null) {
            return;
        }
        switch (this.type) {
            case 0: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data[0]).intValue());
                if (!(entity instanceof IInventorySettable)) break;
                this.setInventoryStacks((IInventorySettable)entity);
                break;
            }
            case 1: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data[0]);
                if (!(tile instanceof IInventorySettable)) break;
                this.setInventoryStacks((IInventorySettable)tile);
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        switch (this.type) {
            case 0: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data[0]).intValue());
                if (!(entity instanceof IInventorySettable)) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamicInventory(entity), (EntityPlayerMP)player);
                break;
            }
            case 1: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data[0]);
                if (!(tile instanceof IInventorySettable)) break;
                GalacticraftCore.packetPipeline.sendTo(new PacketDynamicInventory(tile), (EntityPlayerMP)player);
            }
        }
    }

    private void setInventoryStacks(IInventorySettable inv) {
        inv.setSizeInventory(this.stacks.length);
        for (int i = 0; i < this.stacks.length; ++i) {
            inv.func_70299_a(i, this.stacks[i]);
        }
    }
}

