/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMulti
extends BlockAdvanced
implements IPartialSealableBlock,
ITileEntityProvider {
    public static final PropertyEnum<EnumBlockMultiType> MULTI_TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockMultiType.class);
    public static final PropertyInteger RENDER_TYPE = PropertyInteger.func_177719_a((String)"rendertype", (int)0, (int)7);
    protected static final AxisAlignedBB AABB_PAD = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB AABB_SOLAR = new AxisAlignedBB(0.0, (double)0.2f, 0.0, 1.0, (double)0.8f, 1.0);
    protected static final AxisAlignedBB AABB_SOLAR_POLE = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 1.0, (double)0.7f);
    protected static final AxisAlignedBB AABB_SOLAR_TOP = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    public BlockMulti(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
        this.func_149752_b(1.0E15f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE))) {
            case SOLAR_PANEL_0: 
            case SOLAR_PANEL_1: {
                boolean topPole;
                boolean midPole = source.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
                boolean bl = topPole = source.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
                if (topPole || midPole) {
                    return midPole ? AABB_SOLAR_POLE : AABB_SOLAR_TOP;
                }
                return AABB_SOLAR;
            }
            case ROCKET_PAD: 
            case BUGGY_FUEL_PAD: {
                return AABB_PAD;
            }
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public void makeFakeBlock(World worldObj, BlockPos pos, BlockPos mainBlock, int meta) {
        worldObj.func_180501_a(pos, GCBlocks.fakeBlock.func_176203_a(meta), meta == 5 ? 3 : 0);
        worldObj.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
    }

    public void makeFakeBlock(World worldObj, Collection<BlockPos> posList, BlockPos mainBlock, EnumBlockMultiType type) {
        for (BlockPos pos : posList) {
            worldObj.func_180501_a(pos, this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)type)), type == EnumBlockMultiType.CRYO_CHAMBER ? 3 : 0);
            worldObj.func_175690_a(pos, (TileEntity)new TileEntityMulti(mainBlock));
        }
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            return worldIn.func_180495_p(mainBlockPosition).func_177230_c().func_176195_g(blockState, worldIn, pos);
        }
        return this.field_149782_v;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        int metadata = this.func_176201_c(worldIn.func_180495_p(pos));
        if (metadata == 2 || metadata == 6) {
            return direction == EnumFacing.DOWN;
        }
        if (metadata == 4) {
            return direction == EnumFacing.UP;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti) {
            ((TileEntityMulti)tileEntity).onBlockRemoval();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.onBlockActivated(worldIn, pos, playerIn);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMulti tileEntity = (TileEntityMulti)world.func_175625_s(pos);
        return tileEntity.onBlockWrenched(world, pos, entityPlayer, hand, side, hitX, hitY, hitZ);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IBlockState mainBlockState;
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos) && Blocks.field_150350_a != (mainBlockState = world.func_180495_p(mainBlockPosition)).func_177230_c()) {
            return mainBlockState.func_177230_c().getPickBlock(mainBlockState, target, world, mainBlockPosition, player);
        }
        return ItemStack.field_190927_a;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            IBlockState mainState = world.func_180495_p(mainBlockPosition);
            return mainState.func_177230_c().getBedDirection(mainState, world, mainBlockPosition);
        }
        return EnumFacing.UP;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)pos)) {
            IBlockState mainState = world.func_180495_p(mainBlockPosition);
            return mainState.func_177230_c().isBed(state, world, mainBlockPosition, player);
        }
        return super.isBed(state, world, pos, player);
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        TileEntity tileEntity = world.func_175625_s(pos);
        BlockPos mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition;
        if (mainBlockPosition != null && !mainBlockPosition.equals((Object)pos)) {
            world.func_180495_p(mainBlockPosition).func_177230_c().setBedOccupied(world, mainBlockPosition, player, occupied);
        } else {
            super.setBedOccupied(world, pos, player, occupied);
        }
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (!(world instanceof World)) {
            return null;
        }
        int tries = 3;
        World worldIn = (World)world;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        BlockPos mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition;
        IBlockState cryoChamber = worldIn.func_180495_p(mainBlockPosition);
        EnumFacing enumfacing = EnumFacing.NORTH;
        if (GalacticraftCore.isPlanetsLoaded && cryoChamber.func_177230_c() == MarsBlocks.machine) {
            enumfacing = (EnumFacing)cryoChamber.func_177229_b((IProperty)BlockMachineMars.FACING);
        }
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockMulti.hasRoomForPlayer(worldIn, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    private static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos mainBlockPosition;
        TileEntity tileEntity = worldObj.func_175625_s(target.func_178782_a());
        if (tileEntity instanceof TileEntityMulti && (mainBlockPosition = ((TileEntityMulti)tileEntity).mainBlockPosition) != null && !mainBlockPosition.equals((Object)target.func_178782_a())) {
            manager.addBlockHitEffects(mainBlockPosition, target);
        }
        return super.addHitEffects(state, worldObj, target, manager);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MULTI_TYPE, (Comparable)((Object)EnumBlockMultiType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MULTI_TYPE, RENDER_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumBlockMultiType type = (EnumBlockMultiType)((Object)state.func_177229_b(MULTI_TYPE));
        int renderType = 0;
        switch (type) {
            case CRYO_CHAMBER: {
                IBlockState stateMain;
                IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
                TileEntityMulti tile = (TileEntityMulti)worldIn.func_175625_s(pos);
                renderType = stateAbove.func_177230_c() == this && stateAbove.func_177229_b(MULTI_TYPE) == EnumBlockMultiType.CRYO_CHAMBER ? 0 : 4;
                if (tile == null || tile.mainBlockPosition == null || !GalacticraftCore.isPlanetsLoaded || (stateMain = worldIn.func_180495_p(tile.mainBlockPosition)).func_177230_c() != MarsBlocks.machine || stateMain.func_177229_b((IProperty)BlockMachineMars.TYPE) != BlockMachineMars.EnumMachineType.CRYOGENIC_CHAMBER) break;
                EnumFacing dir = (EnumFacing)stateMain.func_177229_b((IProperty)BlockMachineMars.FACING);
                renderType += dir.func_176736_b();
                break;
            }
        }
        return state.func_177226_a((IProperty)RENDER_TYPE, (Comparable)Integer.valueOf(renderType));
    }

    public static void onPlacement(World worldIn, BlockPos pos, EntityLivingBase placer, Block callingBlock) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IMultiBlock) {
            boolean validSpot = true;
            LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
            ((IMultiBlock)tile).getPositions(pos, toCheck);
            for (BlockPos toTest : toCheck) {
                IBlockState blockAt = worldIn.func_180495_p(toTest);
                if (blockAt.func_177230_c().func_176200_f((IBlockAccess)worldIn, toTest)) continue;
                validSpot = false;
                break;
            }
            if (!validSpot) {
                worldIn.func_175698_g(pos);
                if (!worldIn.field_72995_K && placer instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)placer;
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.warning.noroom")));
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack nasaWorkbench = new ItemStack(callingBlock, 1, 0);
                        EntityItem entityitem = player.func_71019_a(nasaWorkbench, false);
                        entityitem.func_174867_a(0);
                        entityitem.func_145797_a(player.func_70005_c_());
                    }
                }
                return;
            }
            ((IMultiBlock)tile).onCreate(worldIn, pos);
        }
    }

    public static enum EnumBlockMultiType implements IStringSerializable
    {
        SOLAR_PANEL_0(0, "solar"),
        SPACE_STATION_BASE(1, "ss_base"),
        ROCKET_PAD(2, "rocket_pad"),
        NASA_WORKBENCH(3, "nasa_workbench"),
        SOLAR_PANEL_1(4, "solar_panel"),
        CRYO_CHAMBER(5, "cryo_chamber"),
        BUGGY_FUEL_PAD(6, "buggy_pad"),
        MINER_BASE(7, "miner_base"),
        DISH_LARGE(8, "dish_large");

        private final int meta;
        private final String name;

        private EnumBlockMultiType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockMultiType byMetadata(int meta) {
            return EnumBlockMultiType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

